/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;

public class LoadPermissionsRequest
extends CDOClientRequest<Map<CDORevision, CDOPermission>> {
    private InternalCDORevision[] revisions;

    public LoadPermissionsRequest(CDOClientProtocol protocol, InternalCDORevision[] revisions) {
        super(protocol, (short)55);
        this.revisions = revisions;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        int length = this.revisions.length;
        out.writeXInt(length);
        int i = 0;
        while (i < length) {
            InternalCDORevision revision = this.revisions[i];
            CDOID id = revision.getID();
            out.writeCDOID(id);
            byte bits = revision.getPermission().getBits();
            out.writeByte((int)bits);
            ++i;
        }
        int referenceChunk = this.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize();
        out.writeXInt(referenceChunk);
    }

    @Override
    protected Map<CDORevision, CDOPermission> confirming(CDODataInput in) throws IOException {
        HashMap<InternalCDORevision, CDOPermission> oldPermissions = null;
        int length = this.revisions.length;
        int i = 0;
        while (i < length) {
            CDOPermission newPermission;
            InternalCDORevision revision;
            CDOPermission oldPermission;
            byte bits = in.readByte();
            if (bits != -1 && (oldPermission = (revision = this.revisions[i]).getPermission()) != (newPermission = CDOPermission.get((int)bits))) {
                boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
                try {
                    if (oldPermission == CDOPermission.NONE) {
                        revision.readValues(in);
                    }
                }
                finally {
                    revision.bypassPermissionChecks(bypassPermissionChecks);
                }
                revision.setPermission(newPermission);
                if (oldPermissions == null) {
                    oldPermissions = new HashMap<InternalCDORevision, CDOPermission>();
                }
                oldPermissions.put(revision, oldPermission);
            }
            ++i;
        }
        return oldPermissions;
    }
}

