/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.notifications;

import java.util.HashMap;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;

public class BasicDawnLockingHandler
extends BasicDawnListener {
    public BasicDawnLockingHandler(IDawnEditor editor) {
        super(editor);
    }

    @Override
    public void handleLocksChangedEvent(CDOViewLocksChangedEvent event) {
        HashMap<Object, DawnState> changedObjects = new HashMap<Object, DawnState>();
        CDOView view = this.editor.getDawnEditorSupport().getView();
        CDOLockDelta[] cDOLockDeltaArray = event.getLockDeltas();
        int n = cDOLockDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOLockDelta lockDelta = cDOLockDeltaArray[n2];
            CDOID id = lockDelta.getID();
            if (id != null) {
                CDOObject object = view.getObject(id);
                if (object.cdoWriteLock().isLockedByOthers()) {
                    changedObjects.put(object, DawnState.LOCKED_REMOTELY);
                } else {
                    changedObjects.put(object, DawnState.CLEAN);
                }
            }
            ++n2;
        }
        IDawnEditorSupport dawnEditorSupport = this.editor.getDawnEditorSupport();
        dawnEditorSupport.handleRemoteLockChanges(changedObjects);
    }
}

