/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.templates.core.processes;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngineHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessHelper;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.core.templateengine.process.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.embedcdt.templates.core.Utils;

public class ConditionalAppendCreate
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        String projectName = args[0].getSimpleValue();
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String condition = args[1].getSimpleValue();
        if (!Utils.isConditionSatisfied(condition)) {
            return;
        }
        ProcessArgument[][] files = args[2].getComplexArrayValue();
        int i = 0;
        while (i < files.length) {
            String fileContents;
            URL sourceURL;
            ProcessArgument[] file = files[i];
            String fileSourcePath = file[0].getSimpleValue();
            String fileTargetPath = file[1].getSimpleValue();
            boolean replaceable = file[2].getSimpleValue().equals("true");
            try {
                File f = new File(fileSourcePath);
                if (f.isAbsolute()) {
                    sourceURL = f.toURL();
                } else {
                    sourceURL = TemplateEngineHelper.getTemplateResourceURLRelativeToTemplate((TemplateCore)template, (String)fileSourcePath);
                    if (sourceURL == null) {
                        throw new ProcessFailureException(this.getProcessMessage(processId, 4, String.valueOf(Messages.getString((String)"AppendCreate.1")) + fileSourcePath));
                    }
                }
            }
            catch (MalformedURLException e2) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendCreate.2")) + fileSourcePath);
            }
            catch (IOException e1) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendCreate.2")) + fileSourcePath);
            }
            try {
                fileContents = ProcessHelper.readFromFile((URL)sourceURL);
            }
            catch (IOException e1) {
                throw new ProcessFailureException(String.valueOf(Messages.getString((String)"AppendCreate.3")) + fileSourcePath);
            }
            if (replaceable) {
                fileContents = ProcessHelper.getValueAfterExpandingMacros((String)fileContents, (Set)ProcessHelper.getReplaceKeys((String)fileContents), (Map)template.getValueStore());
            }
            try {
                IFile iFile = projectHandle.getFile(fileTargetPath);
                if (!iFile.getParent().exists()) {
                    ProcessHelper.mkdirs((IProject)projectHandle, (IFolder)projectHandle.getFolder(iFile.getParent().getProjectRelativePath()));
                }
                ByteArrayInputStream contents = new ByteArrayInputStream(fileContents.getBytes());
                if (!iFile.exists()) {
                    iFile.create((InputStream)contents, true, null);
                    iFile.refreshLocal(1, null);
                } else {
                    iFile.appendContents((InputStream)contents, true, true, null);
                }
                projectHandle.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new ProcessFailureException(Messages.getString((String)"AppendCreate.4"), (Throwable)e);
            }
            ++i;
        }
    }
}

