/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class TclCommentDocumentationProvider
implements IScriptDocumentationProvider {
    private static final char COMMENT_SIGN = '#';
    private static final String P_BEGIN = "<p>";
    private static final String P_END = "</p>";
    private static final String LINE_BREAK = "<br>\n";

    protected String getLine(Document d, int line) throws BadLocationException {
        return d.get(d.getLineOffset(line), d.getLineLength(line));
    }

    protected List<String> getHeaderComment(IMember member) {
        ISourceModule compilationUnit;
        IBuffer buf;
        ISourceRange range;
        block10: {
            block9: {
                range = member.getSourceRange();
                if (range != null) break block9;
                return null;
            }
            buf = null;
            compilationUnit = member.getSourceModule();
            if (compilationUnit.isConsistent()) break block10;
            return null;
        }
        try {
            buf = compilationUnit.getBuffer();
            int start = range.getOffset();
            String contents = null;
            contents = buf != null ? buf.getContents() : member.getSourceModule().getSource();
            Document doc = new Document(contents);
            try {
                int line = doc.getLineOfOffset(start);
                if (--line >= 0) {
                    ArrayList<String> result = new ArrayList<String>();
                    do {
                        String curLine;
                        if ((curLine = this.getLine(doc, line).trim()).length() > 0 && curLine.charAt(0) == '#') {
                            result.add(0, curLine);
                            continue;
                        }
                        if (curLine.length() != 0 || !result.isEmpty()) break;
                    } while (--line >= 0);
                    return result;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return null;
    }

    public Reader getInfo(IMember member, boolean lookIntoParents, boolean lookIntoExternal) {
        List<String> header = this.getHeaderComment(member);
        if (header != null && !header.isEmpty()) {
            return new StringReader(this.convertToHTML(header));
        }
        return null;
    }

    protected String convertToHTML(List<String> header) {
        StringBuffer result = new StringBuffer();
        boolean paragraphStarted = false;
        int line = 0;
        while (line < header.size()) {
            String str = header.get(line);
            int begin = 0;
            int end = str.length();
            while (begin < end && str.charAt(begin) == '#') {
                ++begin;
            }
            while (begin < end && Character.isWhitespace(str.charAt(begin))) {
                ++begin;
            }
            while (begin < end && str.charAt(end - 1) == '#') {
                --end;
            }
            while (begin < end && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
            if (begin == end) {
                if (paragraphStarted) {
                    result.append(P_END);
                    paragraphStarted = false;
                }
            } else if ((str = str.substring(begin, end)).matches("\\w+(\\s+\\w+)*:")) {
                if (paragraphStarted) {
                    result.append(P_END);
                    paragraphStarted = false;
                }
                result.append("<h4>");
                result.append(TextUtils.escapeHTML((String)str));
                result.append("</h4>\n");
            } else {
                if (!paragraphStarted) {
                    result.append(P_BEGIN);
                    paragraphStarted = true;
                } else {
                    result.append(LINE_BREAK);
                }
                result.append(TextUtils.escapeHTML((String)str));
            }
            ++line;
        }
        if (paragraphStarted) {
            result.append(P_END);
        }
        return result.toString();
    }

    public Reader getInfo(String content) {
        return null;
    }
}

