/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;

public final class LaunchConfigurationUtils {
    public static boolean getBoolean(ILaunchConfiguration configuration, String name, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            if (configuration != null) {
                value = configuration.getAttribute(name, defaultValue);
            }
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log(e);
        }
        return value;
    }

    public static IProject getProject(ILaunchConfiguration configuration) {
        String projectName = LaunchConfigurationUtils.getProjectName(configuration);
        IProject project = null;
        if (projectName != null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return project;
    }

    public static String getProjectName(ILaunchConfiguration configuration) {
        String projectName = null;
        try {
            projectName = configuration.getAttribute("project", null);
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log(e);
        }
        return projectName;
    }

    public static boolean isBreakOnFirstLineEnabled(ILaunchConfiguration configuration, boolean defaultValue) {
        return LaunchConfigurationUtils.getBoolean(configuration, "enableBreakOnFirstLine", defaultValue);
    }

    public static boolean isDbgpLoggingEnabled(ILaunchConfiguration configuration) {
        return LaunchConfigurationUtils.isDbgpLoggingEnabled(configuration, false);
    }

    public static boolean isDbgpLoggingEnabled(ILaunchConfiguration configuration, boolean defaultValue) {
        return LaunchConfigurationUtils.getBoolean(configuration, "enableDbgpLogging", defaultValue);
    }

    public static String getString(ILaunchConfiguration configuration, String name, String defaultValue) {
        String value = defaultValue;
        try {
            if (configuration != null) {
                value = configuration.getAttribute(name, defaultValue);
            }
        }
        catch (CoreException e) {
            DLTKLaunchingPlugin.log(e);
        }
        return value;
    }

    public static int getConnectionTimeout(ILaunchConfiguration configuration, int defaultValue) {
        try {
            return configuration.getAttribute("dbpg_waiting_timeout", defaultValue);
        }
        catch (CoreException e) {
            return defaultValue;
        }
    }

    public static interface ILaunchConfigDefaultBooleanProvider {
        public boolean getDefault();
    }

    public static interface ILaunchConfigDefaultStringProvider {
        public String getDefault();
    }
}

