/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.AbstractExternalSourceModule;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;

public class ExternalSourceModule
extends AbstractExternalSourceModule {
    private IStorage storage;

    public ExternalSourceModule(ModelElement parent, String name, WorkingCopyOwner owner, IStorage storage) {
        super(parent, name, owner);
        this.storage = storage;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalSourceModule)) {
            return false;
        }
        return super.equals(obj);
    }

    public InputStream getContents() throws CoreException {
        return this.storage.getContents();
    }

    @Override
    public String getFileName() {
        return this.getPath().toOSString();
    }

    public IPath getFullPath() {
        if (this.storage != null) {
            return this.storage.getFullPath();
        }
        return this.getPath();
    }

    public String getName() {
        return this.storage.getName();
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    protected char[] getBufferContent() throws ModelException {
        IPath path = this.getBufferPath();
        IFileHandle file = EnvironmentPathUtils.getFile(path);
        Charset charset = (Charset)this.storage.getAdapter(Charset.class);
        IProjectFragment projectFragment = this.getProjectFragment();
        if (charset == null && projectFragment.isArchive()) {
            charset = StandardCharsets.UTF_8;
        }
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        long length = 0L;
        try {
            char[] cArray;
            block12: {
                InputStream stream = null;
                try {
                    stream = this.storage.getContents();
                    char[] rv = Util.getInputStreamAsCharArray(stream, -1, charset == null ? null : charset.name());
                    length = rv.length;
                    cArray = rv;
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            throw throwable;
                        }
                        catch (CoreException e) {
                            throw new ModelException(e, 969);
                        }
                    }
                    catch (IOException e) {
                        throw new ModelException(e, 985);
                    }
                }
                stream.close();
            }
            return cArray;
        }
        finally {
            p.done("#", "IO Read", length);
        }
    }

    protected IPath getBufferPath() {
        return this.getPath();
    }

    @Override
    protected String getModuleType() {
        return "DLTK External Source Module";
    }

    @Override
    protected String getNatureId() {
        IPath path = this.getFullPath();
        IDLTKLanguageToolkit toolkit = this.lookupLanguageToolkit(path);
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.getLanguageToolkit(this.getScriptProject());
        }
        return toolkit != null ? toolkit.getNatureId() : null;
    }

    @Override
    protected ISourceModule getOriginalSourceModule() {
        return new ExternalSourceModule((ModelElement)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY, this.storage);
    }
}

