/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;

public class SerializationHelper {
    public static String RESULT_FLAG = "results";
    public static int RI_VERSION_MAJOR = 1;
    public static int RI_VERSION_MINOR = 0;
    public static int RI_VERSION_SERVICE = 0;
    private static String DOT = ".";
    private static ILogger _log = ResultsViewPlugin.getLogger(null);

    private SerializationHelper() {
    }

    public static void SaveObjects(Object[] objs, String fileName) {
        File file = new File(ResultsViewPlugin.getDefault().getStateLocation().append(fileName).toOSString());
        if (!file.exists()) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(objs);
                oos.flush();
                oos.close();
            }
            catch (Exception e) {
                _log.error("SerializationHelper_serialization_error", (Throwable)e);
            }
        }
    }

    public static Object[] LoadObjects(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(ResultsViewPlugin.getDefault().getStateLocation().append(fileName).toOSString());
        try {
            if (file.exists() && file.isFile()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                Object obj = ois.readObject();
                ois.close();
                if (obj instanceof Object[]) {
                    return (Object[])obj;
                }
            }
        }
        catch (Exception e) {
            _log.error("SerializationHelper_deserialization_error", (Throwable)e);
        }
        return null;
    }

    public static boolean resultManagerVersionCompatible(String versionId) {
        if (!versionId.startsWith(RESULT_FLAG)) {
            return false;
        }
        String verSec = versionId.substring(RESULT_FLAG.length());
        String[] vers = verSec.split("\\" + DOT);
        return vers != null && vers.length > 0 && vers[0] != null && Integer.valueOf(vers[0]).intValue() == Integer.valueOf(RI_VERSION_MAJOR).intValue();
    }

    public static String getResultManagerVersion() {
        return String.valueOf(RESULT_FLAG) + String.valueOf(RI_VERSION_MAJOR) + DOT + String.valueOf(RI_VERSION_MINOR) + DOT + String.valueOf(RI_VERSION_SERVICE);
    }
}

