/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.utils.HexHelper;

public class ResultSetRow
implements IResultSetRow,
Serializable {
    private static final long serialVersionUID = -8798205166177300372L;
    private Object[] _values;

    public ResultSetRow(Object[] values) {
        this._values = values;
    }

    public ResultSetRow(int columnCount) {
        this._values = new Object[columnCount];
    }

    @Override
    public Object[] getData() {
        return this._values;
    }

    @Override
    public Object getData(int index) {
        if (this._values == null) {
            return null;
        }
        if (index < 0 || index > this._values.length - 1) {
            return null;
        }
        return this._values[index];
    }

    @Override
    public void setData(Object[] values) {
        this._values = values;
    }

    @Override
    public void setData(Object obj, int index) {
        this._values[index] = obj;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i = 0;
        while (i < this._values.length) {
            Object data = this._values[i];
            String dataStr = null;
            if (data != null) {
                if (data instanceof byte[]) {
                    byte[] os = (byte[])data;
                    dataStr = HexHelper.toHexString(os);
                } else {
                    dataStr = data.toString();
                }
            }
            this._values[i] = dataStr;
            ++i;
        }
        out.defaultWriteObject();
    }
}

