/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.ddl.shared;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.EngineeringOptionID;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.IEngineeringCallBack;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.datatools.enablement.mysql.ddl.MySqlDdlBuilder;
import org.eclipse.datatools.enablement.mysql.ddl.MySqlDdlScript;
import org.eclipse.datatools.enablement.mysql.ddl.shared.MySqlDdlBuilderHelper;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;

public class MySqlDdlGeneratorHelper
implements DDLGenerator {
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;
    private MySqlDdlBuilderHelper builder = null;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        return this.generateDDL(elements, progressMonitor, null);
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.createSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return this.dropSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor, null);
    }

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = new String[]{};
        EngineeringOption[] options = this.getSelectedOptions(elements);
        if (this.generateCreateStatement(options)) {
            statements = this.createSQLObjects(elements, this.generateQuotedIdentifiers(options), this.generateFullyQualifiedNames(options), progressMonitor);
        }
        if (this.generateDropStatement(options)) {
            String[] drop = this.dropSQLObjects(elements, this.generateQuotedIdentifiers(options), this.generateFullyQualifiedNames(options), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            System.arraycopy(drop, 0, statements, 0, drop.length);
            System.arraycopy(temp, 0, statements, drop.length, temp.length);
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, IEngineeringCallBack callback) {
        this.builder.setEngineeringCallBack(callback);
        String[] statements = this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        MySqlDdlScript script = new MySqlDdlScript();
        if (this.builder == null) {
            this.builder = new MySqlDdlBuilder();
        }
        Iterator it = null;
        it = this.getAllContainedDisplayableElementSet(elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames, this.generatePKConstraints(options))) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statement = null;
                if (o instanceof PrimaryKey) {
                    if (!this.generatePKConstraints(options)) continue;
                    statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames);
                } else {
                    if (!this.generateIndexes(options)) continue;
                    statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames);
                }
                if (statement == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes(options) || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        MySqlDdlScript script = new MySqlDdlScript();
        if (this.builder == null) {
            this.builder = new MySqlDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        EngineeringOption[] options = this.getSelectedOptions(elements);
        while (it.hasNext()) {
            List statements;
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables(options) || (statement = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statements = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)).isEmpty()) continue;
                for (String statement2 : statements) {
                    script.addAlterTableDropConstraintStatement(statement2);
                }
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statements = null;
                if (o instanceof PrimaryKey) {
                    if (!this.generatePKConstraints(options)) continue;
                    statements = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames);
                } else {
                    if (!this.generateIndexes(options)) continue;
                    statements = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames);
                }
                if (statements.isEmpty()) continue;
                for (String statement2 : statements) {
                    script.addAlterTableDropConstraintStatement(statement2);
                }
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statements = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)).isEmpty()) continue;
                for (String statement2 : statements) {
                    script.addAlterTableDropForeignKeyStatement(statement2);
                }
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes(options) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement);
        }
        return script.getStatements();
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        return this.calculateOptions(elements);
    }

    public EngineeringOption[] getSelectedOptions(SQLObject[] elements) {
        if (this.options == null) {
            this.getOptions(elements);
        }
        return this.options;
    }

    public boolean generateDropStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_DROP_STATEMENTS", options);
    }

    public boolean generateCreateStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_CREATE_STATEMENTS", options);
    }

    public boolean generateCommentStatement(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_COMMENTS", options);
    }

    public boolean generateDatabase(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_DATABASE", options);
    }

    public boolean generateSchemas(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SCHEMAS", options);
    }

    public boolean generateQuotedIdentifiers(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_QUOTED_IDENTIFIER", options);
    }

    public boolean generateFullyQualifiedNames(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FULLY_QUALIFIED_NAME", options);
    }

    public boolean generateTables(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_TABLES", options);
    }

    public boolean generateIndexes(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_INDICES", options);
    }

    public boolean generateStoredProcedures(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_STOREDPROCEDURES", options);
    }

    public boolean generateViews(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_VIEWS", options);
    }

    public boolean generateTriggers(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_TRIGGERS", options);
    }

    public boolean generateSequences(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SEQUENCES", options);
    }

    public boolean generateFunctions(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FUNCTIONS", options);
    }

    public boolean generateUserDefinedTypes(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_USER_DEFINED_TYPE", options);
    }

    public boolean generateCKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_CK_CONSTRAINTS", options);
    }

    public boolean generatePKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_PK_CONSTRAINTS", options);
    }

    public boolean generateFKConstraints(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_FK_CONSTRAINTS", options);
    }

    public boolean generateAssertions(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_ASSERTIONS", options);
    }

    private boolean getOptionValueByID(String optionID, EngineeringOption[] options) {
        return EngineeringOptionID.getOptionValueByID((String)optionID, (EngineeringOption[])options);
    }

    protected Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        int i = 0;
        while (i < elements.length) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
            ++i;
        }
        return s;
    }

    private EngineeringOption[] calculateOptions(SQLObject[] elements) {
        EngineeringOptionCategory[] categories_new = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        int i = 0;
        while (i < categories_new.length) {
            if (categories_new[i].getId().equals("GENERATE_OPTIONS")) {
                general_options = categories_new[i];
            } else if (categories_new[i].getId().equals("GENERATE_ELEMENTS")) {
                additional_element = categories_new[i];
            }
            ++i;
        }
        this.options = this.getOptionDependency(elements, general_options, additional_element);
        return this.options;
    }

    private EngineeringOption[] getOptionDependency(SQLObject[] elements, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        LinkedHashSet<String> sOptions = new LinkedHashSet<String>();
        sOptions.add("GENERATE_FULLY_QUALIFIED_NAME");
        sOptions.add("GENERATE_QUOTED_IDENTIFIER");
        sOptions.add("GENERATE_DROP_STATEMENTS");
        sOptions.add("GENERATE_CREATE_STATEMENTS");
        sOptions.add("GENERATE_COMMENTS");
        sOptions.addAll(this.getAllContainedDisplayableElementSetDepedency(elements));
        int idx = 0;
        int size = 0;
        EngineeringOption[] options = new EngineeringOption[sOptions.size()];
        int i = 0;
        Iterator it = sOptions.iterator();
        while (it.hasNext()) {
            options[i] = this.getEngineeringOption((String)it.next(), general_options, additional_element);
            if (options[i] != null && options[i].getCategory().getId().equals("GENERATE_ELEMENTS")) {
                idx = i;
                ++size;
            }
            ++i;
        }
        if (size == 1) {
            EngineeringOption option = options[idx];
            option.setBoolean(true);
        }
        return options;
    }

    protected EngineeringOption getEngineeringOption(String id, EngineeringOptionCategory general_options, EngineeringOptionCategory additional_element) {
        ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
        try {
            if (id.equalsIgnoreCase("GENERATE_FULLY_QUALIFIED_NAME")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_QUOTED_IDENTIFIER")) {
                return new EngineeringOption(id, resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_DROP_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_CREATE_STATEMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_COMMENTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_COMMENTS"), resource.getString("GENERATE_COMMENTS_DES"), true, general_options);
            }
            if (id.equalsIgnoreCase("GENERATE_SCHEMAS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SCHEMAS"), resource.getString("GENERATE_SCHEMAS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TABLES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TABLES"), resource.getString("GENERATE_TABLES_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_PK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_PK_CONSTRAINTS"), resource.getString("GENERATE_PK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_CK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_CK_CONSTRAINTS"), resource.getString("GENERATE_CK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FK_CONSTRAINTS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FK_CONSTRAINTS"), resource.getString("GENERATE_FK_CONSTRAINTS_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_INDICES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_INDEX"), resource.getString("GENERATE_INDEX_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_STOREDPROCEDURES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_STOREDPROCEDURE"), resource.getString("GENERATE_STOREDPROCEDURE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_FUNCTIONS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_FUNCTION"), resource.getString("GENERATE_FUNCTION_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_VIEWS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_VIEW"), resource.getString("GENERATE_VIEW_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_TRIGGERS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_TIGGER"), resource.getString("GENERATE_TIGGER_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_SEQUENCES")) {
                return new EngineeringOption(id, resource.getString("GENERATE_SEQUENCE"), resource.getString("GENERATE_SEQUENCE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_USER_DEFINED_TYPE")) {
                return new EngineeringOption(id, resource.getString("GENERATE_USER_DEFINED_TYPE"), resource.getString("GENERATE_USER_DEFINED_TYPE_DES"), true, additional_element);
            }
            if (id.equalsIgnoreCase("GENERATE_ASSERTIONS")) {
                return new EngineeringOption(id, resource.getString("GENERATE_ASSERTIONS"), resource.getString("GENERATE_GENERATE_ASSERTION_DES"), true, additional_element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Set getAllContainedDisplayableElementSetDepedency(SQLObject[] elements) {
        SingletonOptionDependency sod = SingletonOptionDependency.getSingletonObject();
        TreeSet s = new TreeSet();
        int i = 0;
        while (i < elements.length) {
            Class<Database> key = null;
            if (elements[i] instanceof Database) {
                key = Database.class;
            } else if (elements[i] instanceof Schema) {
                key = Schema.class;
            } else if (elements[i] instanceof PersistentTable) {
                key = Table.class;
            } else if (elements[i] instanceof Index) {
                key = Index.class;
            } else if (elements[i] instanceof Procedure) {
                key = Procedure.class;
            } else if (elements[i] instanceof UserDefinedFunction) {
                key = UserDefinedFunction.class;
            } else if (elements[i] instanceof ViewTable) {
                key = ViewTable.class;
            } else if (elements[i] instanceof Trigger) {
                key = Trigger.class;
            } else if (elements[i] instanceof Sequence) {
                key = Sequence.class;
            } else if (elements[i] instanceof UserDefinedType) {
                key = UserDefinedType.class;
            } else if (elements[i] instanceof UniqueConstraint) {
                key = UniqueConstraint.class;
            } else if (elements[i] instanceof CheckConstraint) {
                key = CheckConstraint.class;
            } else if (elements[i] instanceof ForeignKey) {
                key = ForeignKey.class;
            }
            try {
                int mask = sod.getMask(key);
                this.populateOptions(s, mask);
            }
            catch (Exception e) {
                System.err.println("Missing definition for: " + elements[i].getClass().toString());
                e.printStackTrace();
            }
            ++i;
        }
        return s;
    }

    protected void populateOptions(Set s, int mask) {
        if ((mask & 1) == 1) {
            s.add("GENERATE_DATABASE");
        }
        if ((mask & 4) == 4) {
            s.add("GENERATE_TABLES");
        }
        if ((mask & 0x80) == 128) {
            s.add("GENERATE_INDICES");
        }
        if ((mask & 8) == 8) {
            s.add("GENERATE_STOREDPROCEDURES");
        }
        if ((mask & 0x10) == 16) {
            s.add("GENERATE_FUNCTIONS");
        }
        if ((mask & 0x20) == 32) {
            s.add("GENERATE_VIEWS");
        }
        if ((mask & 0x40) == 64) {
            s.add("GENERATE_TRIGGERS");
        }
        if ((mask & 0x100) == 256) {
            s.add("GENERATE_SEQUENCES");
        }
        if ((mask & 0x200) == 512) {
            s.add("GENERATE_USER_DEFINED_TYPE");
        }
        if ((mask & 0x400) == 1024) {
            s.add("GENERATE_PK_CONSTRAINTS");
        }
        if ((mask & 0x1000) == 4096) {
            s.add("GENERATE_CK_CONSTRAINTS");
        }
        if ((mask & 0x800) == 2048) {
            s.add("GENERATE_FK_CONSTRAINTS");
        }
        if ((mask & 2) == 2) {
            s.add("GENERATE_SCHEMAS");
        }
    }

    protected MySqlDdlBuilderHelper getBuilder() {
        return this.builder;
    }

    protected void setBuilder(MySqlDdlBuilderHelper builder) {
        this.builder = builder;
    }

    public static class SingletonOptionDependency {
        private Map data = new HashMap();
        private static SingletonOptionDependency ref;

        private SingletonOptionDependency() {
        }

        public static SingletonOptionDependency getSingletonObject() {
            if (ref == null) {
                ref = new SingletonOptionDependency();
                int mask = 7396;
                SingletonOptionDependency.ref.data.put(Database.class, new Integer(mask));
                mask = 7396;
                SingletonOptionDependency.ref.data.put(Schema.class, new Integer(mask));
                mask = 7364;
                SingletonOptionDependency.ref.data.put(Table.class, new Integer(mask));
                mask = 128;
                SingletonOptionDependency.ref.data.put(Index.class, new Integer(mask));
                mask = 8;
                SingletonOptionDependency.ref.data.put(Procedure.class, new Integer(mask));
                mask = 16;
                SingletonOptionDependency.ref.data.put(UserDefinedFunction.class, new Integer(mask));
                mask = 96;
                SingletonOptionDependency.ref.data.put(ViewTable.class, new Integer(mask));
                mask = 64;
                SingletonOptionDependency.ref.data.put(Trigger.class, new Integer(mask));
                mask = 256;
                SingletonOptionDependency.ref.data.put(Sequence.class, new Integer(mask));
                mask = 512;
                SingletonOptionDependency.ref.data.put(UserDefinedType.class, new Integer(mask));
                mask = 1024;
                SingletonOptionDependency.ref.data.put(UniqueConstraint.class, new Integer(mask));
                mask = 2048;
                SingletonOptionDependency.ref.data.put(ForeignKey.class, new Integer(mask));
                mask = 4096;
                SingletonOptionDependency.ref.data.put(CheckConstraint.class, new Integer(mask));
            }
            return ref;
        }

        public Integer getMask(Class key) {
            return (Integer)this.data.get(key);
        }
    }
}

