/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.enablement.ibm.db2.ddl.DB2DdlMessages;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlBuilder;
import org.eclipse.datatools.enablement.ibm.db2.luw.ddl.LUWDdlGenerator;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWBufferPool;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartition;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDataPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionElement;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionExpression;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWPartitionKey;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWStorageTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.ManagementType;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.PartitionMethod;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.TableSpaceType;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Trigger;
import org.eclipse.datatools.enablement.ibm.db2.model.UnitType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public class LUWDdlBuilder9
extends LUWDdlBuilder {
    protected static final String DISTRIBUTE_BY = "DISTRIBUTE BY";
    protected static final String PARTITION_BY = "PARTITION BY";
    protected static final String PARTITION = "PARTITION";
    protected static final String HASH = "HASH";
    protected static final String REPLICATION = "REPLICATION";
    protected static final String RANGE = "RANGE";
    protected static final String NULLS_LAST = "NULLS LAST";
    protected static final String STARTING = "STARTING";
    protected static final String ENDING = "ENDING";
    protected static final String AT = "AT";
    protected static final String COMPRESS = "COMPRESS";
    protected static final String YES = "YES";
    protected static final String EXCLUSIVE = "EXCLUSIVE";

    public LUWDdlBuilder9() {
    }

    public LUWDdlBuilder9(LUWDdlGenerator generator) {
        super(generator);
    }

    @Override
    protected String getPartitionKey(LUWStorageTable table, boolean quoteIdentifiers) {
        LUWDataPartitionKey dataPartitionKey;
        StringBuffer buffer = new StringBuffer();
        LUWPartitionKey partitionKey = table.getPartitionKey();
        if (partitionKey != null) {
            StringBuffer partKeyBuf = new StringBuffer();
            PartitionMethod partMethod = partitionKey.getPartitionMethod();
            if (partMethod == PartitionMethod.HASHING_LITERAL) {
                partKeyBuf.append(NEWLINE).append("\t").append(DISTRIBUTE_BY).append(" ").append(HASH).append(" ").append("(");
                boolean hasKey = false;
                Iterator it = partitionKey.getColumns().iterator();
                while (it.hasNext()) {
                    hasKey = true;
                    Column column = (Column)it.next();
                    partKeyBuf.append(column.getName());
                    if (!it.hasNext()) continue;
                    partKeyBuf.append(", ");
                }
                partKeyBuf.append(")");
                if (hasKey) {
                    buffer.append(partKeyBuf);
                }
            } else if (partMethod == PartitionMethod.TABLE_REPLICATED_LITERAL) {
                if (table instanceof LUWMaterializedQueryTable) {
                    partKeyBuf.append(NEWLINE).append("\t").append(DISTRIBUTE_BY).append(" ").append(REPLICATION);
                    buffer.append(partKeyBuf);
                } else {
                    partKeyBuf.append(NEWLINE).append("\t").append(DISTRIBUTE_BY).append(" ").append(HASH).append(" ").append("(");
                    boolean hasKey = false;
                    Iterator it = partitionKey.getColumns().iterator();
                    while (it.hasNext()) {
                        hasKey = true;
                        Column column = (Column)it.next();
                        partKeyBuf.append(column.getName());
                        if (!it.hasNext()) continue;
                        partKeyBuf.append(", ");
                    }
                    partKeyBuf.append(")");
                    if (hasKey) {
                        buffer.append(partKeyBuf);
                    }
                }
            }
        }
        if ((dataPartitionKey = table.getDataPartitionKey()) != null) {
            buffer.append(this.getRangePartitions(dataPartitionKey));
        }
        return buffer.toString();
    }

    private String getRangePartitions(LUWDataPartitionKey partitionKey) {
        StringBuffer buffer = new StringBuffer();
        boolean hasKey = false;
        StringBuffer keyBuffer = new StringBuffer();
        keyBuffer.append(NEWLINE).append("\t").append(PARTITION_BY).append(" ").append(RANGE).append("(");
        ArrayList<Column> keyCols = new ArrayList<Column>();
        Iterator it = partitionKey.getPartitionExpressions().iterator();
        while (it.hasNext()) {
            hasKey = true;
            LUWPartitionExpression expression = (LUWPartitionExpression)it.next();
            Column column = expression.getColumn();
            keyBuffer.append(column.getName());
            keyCols.add(column);
            if (expression.isNullsLast()) {
                keyBuffer.append(" ").append(NULLS_LAST);
            }
            if (!it.hasNext()) continue;
            keyBuffer.append(", ");
        }
        keyBuffer.append(")");
        if (hasKey) {
            buffer.append(keyBuffer);
        }
        boolean hasDataPartition = false;
        StringBuffer datapartBuffer = new StringBuffer();
        datapartBuffer.append(NEWLINE).append("\t").append("(");
        LUWStorageTable table = partitionKey.getTable();
        Iterator iter = table.getDataPartitions().iterator();
        while (iter.hasNext()) {
            hasDataPartition = true;
            LUWDataPartition partition = (LUWDataPartition)iter.next();
            String partName = partition.getName();
            if (partName != null && !partName.equals("")) {
                datapartBuffer.append(PARTITION).append(" ").append(partName);
            }
            datapartBuffer.append(this.getRange(partition, keyCols));
            LUWTableSpace tsp = partition.getRegularDataTableSpace();
            if (tsp != null) {
                datapartBuffer.append(" ").append("IN").append(" ").append(tsp.getName());
            }
            if ((tsp = partition.getLOBDataTableSpace()) != null) {
                datapartBuffer.append(" ").append("LONG").append(" ").append("IN").append(" ").append(tsp.getName());
            }
            if (!iter.hasNext()) continue;
            datapartBuffer.append(", ").append(NEWLINE).append("\t");
        }
        datapartBuffer.append(")");
        if (hasDataPartition) {
            buffer.append(datapartBuffer);
        }
        return buffer.toString();
    }

    private String getRange(LUWDataPartition partition, Collection keyCols) {
        StringBuffer buffer = new StringBuffer();
        String startStr = "";
        String endStr = "";
        Iterator keyIter = keyCols.iterator();
        while (keyIter.hasNext()) {
            Column keyCol = (Column)keyIter.next();
            for (LUWPartitionElement element : partition.getPartitionElements()) {
                Column column = element.getLUWPartitionExpression().getColumn();
                if (column != keyCol) continue;
                DataType type = element.getLUWPartitionExpression().getColumn().getDataType();
                if (type instanceof CharacterStringDataType || type instanceof DateDataType || type instanceof TimeDataType) {
                    String rangeValue = element.getStarting();
                    startStr = rangeValue.equalsIgnoreCase("MINVALUE") || rangeValue.equalsIgnoreCase("MAXVALUE") ? String.valueOf(startStr) + rangeValue : String.valueOf(startStr) + this.getSingleQuotedString(rangeValue);
                    rangeValue = element.getEnding();
                    endStr = rangeValue.equalsIgnoreCase("MINVALUE") || rangeValue.equalsIgnoreCase("MAXVALUE") ? String.valueOf(endStr) + rangeValue : String.valueOf(endStr) + this.getSingleQuotedString(rangeValue);
                } else {
                    startStr = String.valueOf(startStr) + element.getStarting();
                    endStr = String.valueOf(endStr) + element.getEnding();
                }
                if (!keyIter.hasNext()) continue;
                startStr = String.valueOf(startStr) + ",";
                endStr = String.valueOf(endStr) + ",";
            }
        }
        buffer.append(" ").append(STARTING).append(" ").append("FROM").append(" ").append("(").append(startStr).append(")").append(" ");
        if (!partition.isLowInclusive()) {
            buffer.append(" ").append(EXCLUSIVE).append(" ");
        }
        buffer.append(ENDING).append(" ").append(AT).append(" ").append("(").append(endStr).append(")");
        if (!partition.isHighInclusive()) {
            buffer.append(" ").append(EXCLUSIVE).append(" ");
        }
        return buffer.toString();
    }

    @Override
    protected String getCompressionValue(LUWStorageTable table) {
        StringBuffer text = new StringBuffer();
        if (table.isRowCompression()) {
            text.append(NEWLINE).append("\t").append(COMPRESS).append(" ").append(YES);
        }
        text.append(super.getCompressionValue(table));
        return text.toString();
    }

    @Override
    protected boolean isTablespaceContainersRequried(LUWTableSpace tablespace) {
        return tablespace.getManagementType() != ManagementType.AUTOMATIC_STORAGE_LITERAL;
    }

    @Override
    protected String getAlterTableAlterRowCompressionString(LUWTable table) {
        String compressionStr = String.valueOf(NEWLINE) + "\t" + COMPRESS;
        compressionStr = table.isRowCompression() ? String.valueOf(compressionStr) + " YES" : String.valueOf(compressionStr) + " NO";
        return compressionStr;
    }

    @Override
    protected String getDistributeKeyword() {
        return DISTRIBUTE_BY;
    }

    @Override
    protected String getBufferPoolSize(LUWBufferPool bufferpool) {
        return " SIZE " + bufferpool.getSize();
    }

    @Override
    protected String getDataPartitionOptions(LUWIndex index) {
        String pmode;
        String ddl = "";
        if (index != null && (pmode = ((LUWTable)index.getTable()).getPartitionMode()) != null && !pmode.trim().equals("")) {
            LUWTableSpace luwtbspace;
            if (index.isNotPartitioned()) {
                ddl = String.valueOf(ddl) + NEWLINE + "NOT PARTITIONED ";
            }
            if ((luwtbspace = index.getTablespace()) != null) {
                ddl = String.valueOf(ddl) + NEWLINE + "IN " + luwtbspace.getName();
            }
        }
        return ddl;
    }

    @Override
    protected String RecoverDroppedTableString(LUWTableSpace tablespace) {
        String text = "";
        if (!(tablespace.getTablespaceType() != TableSpaceType.REGULAR_LITERAL && tablespace.getTablespaceType() != TableSpaceType.LARGE_LITERAL || tablespace.isRecoverDroppedTableOn())) {
            text = String.valueOf(text) + NEWLINE + "\t" + "DROPPED TABLE RECOVERY " + "OFF";
        }
        return text;
    }

    public String createTrigger(DB2Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String c;
        String statement = "CREATE TRIGGER " + this.getName((Trigger)trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "INSTEAD OF";
        }
        statement = String.valueOf(statement) + " ";
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ",  ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        String referenceStr = "";
        if (newRow != null && newRow.length() != 0 && !trigger.isDeleteType()) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals("") ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + "NEW" + " " + "AS" + " " + newRow;
        }
        if (oldRow != null && oldRow.length() != 0 && !trigger.isInsertType()) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals("") ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + "OLD" + " " + "AS" + " " + oldRow;
        }
        if (newTable != null && newTable.length() != 0) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals("") ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + this.getTriggerReferenceNewTable() + " " + "AS" + " " + newTable;
        }
        if (oldTable != null && oldTable.length() != 0 && !trigger.isInsertType()) {
            referenceStr = String.valueOf(referenceStr) + (referenceStr.equals("") ? " " : String.valueOf(NEWLINE) + "\t" + "\t") + this.getTriggerReferenceOldTable() + " " + "AS" + " " + oldTable;
        }
        if (!referenceStr.equals("")) {
            statement = String.valueOf(statement) + "\tREFERENCING " + referenceStr + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "\tFOR EACH ROW" : String.valueOf(statement) + "\tFOR EACH STATEMENT";
        statement = String.valueOf(statement) + NEWLINE;
        SearchCondition condition = trigger.getWhen();
        if (condition != null && (c = condition.getSQL()) != null && c.trim().length() != 0) {
            statement = String.valueOf(statement) + "WHEN (" + condition.getSQL() + ")" + NEWLINE;
        }
        String sqlBody = "";
        for (SQLStatement s : trigger.getActionStatement()) {
            sqlBody = String.valueOf(sqlBody) + s.getSQL();
        }
        if (sqlBody.equals("")) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(DB2DdlMessages.FE_TRIGGER_ACTION_EMPTY, this.getName((Trigger)trigger, quoteIdentifiers, qualifyNames)));
            return null;
        }
        statement = String.valueOf(statement) + sqlBody;
        return statement;
    }

    @Override
    public String tablespaceAutoResizeClause(LUWTableSpace tablespace) {
        return String.valueOf(NEWLINE) + "\t" + "AUTORESIZE" + " " + (tablespace.isAutoResize() ? "ON" : "OFF");
    }

    @Override
    public String tablespaceIncreaseSizeClause(LUWTableSpace tablespace) {
        long incrsize = tablespace.getIncreaseSize();
        UnitType incrunit = tablespace.getIncreaseSizeUnit();
        int incrpct = tablespace.getIncreasePercent();
        if (incrsize != 0L) {
            return String.valueOf(NEWLINE) + "\t" + "INCREASESIZE" + " " + incrsize + (incrunit != null ? " " + incrunit.getLiteral() : "");
        }
        if (incrpct != 0) {
            return String.valueOf(NEWLINE) + "\t" + "INCREASESIZE" + " " + incrpct + " " + "PERCENT";
        }
        return "";
    }

    @Override
    public String tablespaceMaxSizeClause(LUWTableSpace tablespace) {
        long maxsize = tablespace.getMaximumSize();
        UnitType maxunit = tablespace.getMaximumSizeUnit();
        if (maxsize != 0L) {
            return String.valueOf(NEWLINE) + "\t" + "MAXSIZE" + " " + maxsize + (maxunit != null ? " " + maxunit.getLiteral() : "");
        }
        return String.valueOf(NEWLINE) + "\t" + "MAXSIZE" + " " + "NONE";
    }

    @Override
    protected boolean supportsBufferpoolExtendedStorage() {
        return false;
    }
}

