/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.ICatalogAuthorizationIdentifier;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabasePackage;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogIndex;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogMaterializedQueryTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogNickname;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogProcedure;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSequence;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogUserDefinedFunction;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogView;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWTableSpace;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Role;
import org.eclipse.datatools.modelbase.sql.accesscontrol.impl.UserImpl;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogUser
extends UserImpl
implements ICatalogObject,
ICatalogAuthorizationIdentifier {
    private boolean receivedPrivilegesLoaded = false;
    private boolean receivedRoleAuthorizationLoaded = false;

    public void refresh() {
        if (this.receivedPrivilegesLoaded) {
            this.getReceivedPrivilege().clear();
            this.receivedPrivilegesLoaded = false;
        }
        if (this.receivedRoleAuthorizationLoaded) {
            this.receivedRoleAuthorization.clear();
            this.receivedRoleAuthorizationLoaded = false;
        }
        this.getGrantedPrivilege().clear();
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getReceivedRoleAuthorization() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getReceivedRoleAuthorization();
        }
        if (!this.receivedRoleAuthorizationLoaded) {
            this.loadReceivedRoleAuthorization();
        }
        return this.receivedRoleAuthorization;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 13) {
            this.getReceivedPrivilege();
        } else if (id == 10) {
            this.getReceivedRoleAuthorization();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadReceivedPrivilege() {
        if (this.receivedPrivilegesLoaded) {
            return;
        }
        this.receivedPrivilegesLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogUser.loadReceivedPrivilege(this.getConnection(), super.getReceivedPrivilege(), (AuthorizationIdentifier)this, "U");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadReceivedRoleAuthorization() {
        if (this.receivedRoleAuthorizationLoaded) {
            return;
        }
        this.receivedRoleAuthorizationLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        LUWCatalogUser.loadReceivedRoleAuthorization(this.getConnection(), super.getReceivedRoleAuthorization(), (AuthorizationIdentifier)this);
        this.eSetDeliver(deliver);
    }

    protected static void loadReceivedPrivilege(Connection connection, EList privileges, AuthorizationIdentifier authId, String granteeType) {
        String query = "SELECT 'D' AS OBJECT_TYPE, '' AS OBJECT_NAME,'' AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.DBAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'S' AS OBJECT_TYPE, SCHEMANAME AS OBJECT_NAME,'' AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.SCHEMAAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'T' AS OBJECT_TYPE, TABNAME AS OBJECT_NAME, TABSCHEMA AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.TABAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'P' AS OBJECT_TYPE, TBSPACE AS OBJECT_NAME, '' AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.TBSPACEAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'R' AS OBJECT_TYPE, SPECIFICNAME AS OBJECT_NAME, SCHEMA AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.ROUTINEAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'Q' AS OBJECT_TYPE, SEQNAME AS OBJECT_NAME, SEQSCHEMA AS OBJECT_OWNER, '' AS OBJECT_UID FROM SYSCAT.SEQUENCEAUTH WHERE GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'" + " UNION SELECT 'K' AS OBJECT_TYPE, A.PKGNAME AS OBJECT_NAME, A.PKGSCHEMA AS OBJECT_OWNER, HEX(P.UNIQUE_ID) AS OBJECT_UID FROM SYSCAT.PACKAGEAUTH A, SYSCAT.PACKAGES P WHERE A.PKGSCHEMA = P.PKGSCHEMA AND A.PKGNAME = P.PKGNAME AND A.GRANTEE = '" + authId.getName() + "' AND A.GRANTEETYPE = '" + granteeType + "'";
        String whereClause = " GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'";
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                DB2Package pkg;
                String obj_uid;
                String obj_type = r.getString("OBJECT_TYPE");
                String obj_name = r.getString("OBJECT_NAME") == null ? "" : r.getString("OBJECT_NAME").trim();
                String obj_owner = r.getString("OBJECT_OWNER") == null ? "" : r.getString("OBJECT_OWNER").trim();
                String string = obj_uid = r.getString("OBJECT_UID") == null ? "" : r.getString("OBJECT_UID").trim();
                if (obj_type.equals("D")) {
                    Database database = authId.getDatabase();
                    if (!(database instanceof LUWCatalogDatabase)) continue;
                    ((LUWCatalogDatabase)database).getPrivilegesWithFilter(whereClause);
                    continue;
                }
                if (obj_type.equals("S")) {
                    Schema schema = LUWCatalogUser.getSchema(authId, obj_name);
                    if (!(schema instanceof LUWCatalogSchema)) continue;
                    ((LUWCatalogSchema)schema).getPrivilegesWithFilter(whereClause);
                    continue;
                }
                if (obj_type.equals("T")) {
                    Table table = LUWCatalogUser.getTable(authId, obj_owner, obj_name);
                    if (table instanceof LUWCatalogTable) {
                        ((LUWCatalogTable)table).getPrivilegesWithFilter(whereClause);
                        continue;
                    }
                    if (table instanceof LUWCatalogView) {
                        ((LUWCatalogView)table).getPrivilegesWithFilter(whereClause);
                        continue;
                    }
                    if (table instanceof LUWCatalogMaterializedQueryTable) {
                        ((LUWCatalogMaterializedQueryTable)table).getPrivilegesWithFilter(whereClause);
                        continue;
                    }
                    if (!(table instanceof LUWCatalogNickname)) continue;
                    ((LUWCatalogNickname)table).getPrivilegesWithFilter(whereClause);
                    continue;
                }
                if (obj_type.equals("P")) {
                    LUWTableSpace tablespace = LUWCatalogUser.getTableSpace(authId, obj_name);
                    if (tablespace == null) continue;
                    tablespace.getPrivileges();
                    continue;
                }
                if (obj_type.equals("R")) {
                    Routine routine = LUWCatalogUser.getRountine(authId, obj_owner, obj_name);
                    if (routine instanceof LUWCatalogProcedure) {
                        ((LUWCatalogProcedure)routine).getPrivilegesWithFilter(whereClause);
                    }
                    if (!(routine instanceof LUWCatalogUserDefinedFunction)) continue;
                    ((LUWCatalogUserDefinedFunction)routine).getPrivilegesWithFilter(whereClause);
                    continue;
                }
                if (obj_type.equals("Q")) {
                    Sequence sequence = LUWCatalogUser.getSequence(authId, obj_owner, obj_name);
                    if (!(sequence instanceof LUWCatalogSequence)) continue;
                    ((LUWCatalogSequence)sequence).getPrivilegesWithFilter(whereClause);
                    continue;
                }
                if (!obj_type.equals("K") || !((pkg = LUWCatalogUser.getDB2Package(authId, obj_owner, obj_name, obj_uid)) instanceof LUWCatalogDatabasePackage)) continue;
                ((LUWCatalogDatabasePackage)pkg).getPrivilegesWithFilter(whereClause);
            }
            r.close();
            query = "SELECT I.INDNAME, TABNAME, TABSCHEMA FROM SYSCAT.INDEXAUTH A, SYSCAT.INDEXES I WHERE A.INDNAME = I.INDNAME AND A.INDSCHEMA = I.INDSCHEMA AND GRANTEE = '" + authId.getName() + "' AND GRANTEETYPE = '" + granteeType + "'";
            r = s.executeQuery(query);
            while (r.next()) {
                String indexName = r.getString("INDNAME").trim();
                String tableName = r.getString("TABNAME").trim();
                String schemaName = r.getString("TABSCHEMA").trim();
                Index index = LUWCatalogUser.getIndex(authId, schemaName, tableName, indexName);
                if (!(index instanceof LUWCatalogIndex)) continue;
                ((LUWCatalogIndex)index).getPrivilegesWithFilter(whereClause);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void loadReceivedRoleAuthorization(Connection connection, EList receivedRoleAuth, AuthorizationIdentifier authid) {
        try {
            DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(authid.getDatabase());
            String version = definition.getVersion();
            float ver = 9.1f;
            try {
                ver = Float.parseFloat(version.substring(1));
            }
            catch (NumberFormatException numberFormatException) {}
            if ((double)ver < 9.5) {
                return;
            }
            String query = "SELECT ROLENAME FROM SYSCAT.ROLEAUTH WHERE GRANTEE ='" + authid.getName() + "'";
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String roleName = r.getString("ROLENAME").trim();
                AuthorizationIdentifier role = LUWCatalogDatabase.getAuthorizationId(authid.getDatabase(), roleName, "R");
                if (!(role instanceof Role)) continue;
                ((Role)role).getRoleAuthorization();
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Schema getSchema(AuthorizationIdentifier authId, String schemaName) {
        Database d = authId.getDatabase();
        if (d instanceof LUWCatalogDatabase) {
            Schema s = ((LUWCatalogDatabase)d).getSchema(schemaName);
            if (s != null) {
                return s;
            }
        } else {
            for (Schema s : d.getSchemas()) {
                if (!s.getName().equals(schemaName)) continue;
                return s;
            }
        }
        return null;
    }

    private static Table getTable(AuthorizationIdentifier authId, String schemaName, String tableName) {
        Schema schema = LUWCatalogUser.getSchema(authId, schemaName);
        if (schema == null) {
            return null;
        }
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getTable(schemaName, tableName);
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    private static Index getIndex(AuthorizationIdentifier authId, String schemaName, String tableName, String indexName) {
        Table table = LUWCatalogUser.getTable(authId, schemaName, tableName);
        if (table == null) {
            return null;
        }
        for (Index index : table.getIndex()) {
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    private static Routine getRountine(AuthorizationIdentifier authId, String schemaName, String specificName) {
        Schema schema = LUWCatalogUser.getSchema(authId, schemaName);
        if (schema == null) {
            return null;
        }
        for (Routine routine : schema.getRoutines()) {
            if (!specificName.equals(routine.getSpecificName())) continue;
            return routine;
        }
        return null;
    }

    private static Sequence getSequence(AuthorizationIdentifier authId, String schemaName, String sequenceName) {
        Schema schema = LUWCatalogUser.getSchema(authId, schemaName);
        if (schema == null) {
            return null;
        }
        for (Sequence sequence : schema.getSequences()) {
            if (!sequenceName.equals(sequence.getName())) continue;
            return sequence;
        }
        return null;
    }

    private static LUWTableSpace getTableSpace(AuthorizationIdentifier authId, String spaceName) {
        LUWDatabase d = (LUWDatabase)authId.getDatabase();
        for (LUWTableSpace s : d.getTablespaces()) {
            if (!s.getName().equals(spaceName)) continue;
            return s;
        }
        return null;
    }

    private static DB2Package getDB2Package(AuthorizationIdentifier authId, String schemaName, String pkgName, String pkgUniqueID) {
        Schema schema = LUWCatalogUser.getSchema(authId, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getDB2Package(pkgName, pkgUniqueID);
        }
        return null;
    }

    public EList getCatalogReceivedPrivileges() {
        this.loadReceivedPrivilege();
        return this.receivedPrivilege;
    }
}

