/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.iseries.internal.ui.drivers;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.enablement.ibm.db2.iseries.internal.ui.drivers.Messages;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IIBMJDBCDriverProvider;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DB2ISeriesToolboxDriverUIContributor
implements IDriverUIContributor,
IIBMJDBCDriverProvider,
Listener {
    private static final String CUI_NEWCW_HOST_LBL_UI_ = Messages.getString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("CUI_NEWCW_USERNAME_LBL_UI_");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_ = Messages.getString("CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_URL_SUMMARY_DATA_TEXT_");
    private Label hostLabel;
    private Text hostText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label defaultSchemaLabel;
    private Text defaultSchemaText;
    private Button savePasswordButton;
    private Label urlLabel;
    private Text urlText;
    private DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private String urlOptionalParameters = "";
    private boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_USERID_REQ_UI_"));
            isComplete = false;
        } else if (this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_"));
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            Composite baseComposite = new Composite((Composite)this.parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.defaultSchemaLabel = new Label(baseComposite, 0);
            this.defaultSchemaLabel.setText(CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.defaultSchemaText.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2060);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.urlText.setLayoutData((Object)gd);
            this.parentComposite.setContent((Control)baseComposite);
            this.parentComposite.setMinSize(baseComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_, this.defaultSchemaText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    public void loadProperties() {
        String defaultSchema;
        String savePassword;
        String password;
        this.removeListeners();
        DB2iSeriesJDBCURL url = new DB2iSeriesJDBCURL(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        if ((defaultSchema = this.properties.getProperty("org.eclipse.datatools.connectivity.db.defaultSchema")) != null) {
            this.defaultSchemaText.setText(defaultSchema);
        }
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.hostText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.defaultSchema", this.defaultSchemaText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.contributorInformation.setProperties(this.properties);
    }

    public void updateURL() {
        String url = "jdbc:as400:" + this.hostText.getText().trim() + ";prompt=false;";
        url = String.valueOf(url) + this.getURLOptionalParameters();
        this.urlText.setText(url);
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    private void addListeners() {
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.defaultSchemaText.addListener(24, (Listener)this);
    }

    private void removeListeners() {
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.defaultSchemaText.removeListener(24, (Listener)this);
    }

    public void setURLOptionalParameters(String connProp) {
        this.urlOptionalParameters = connProp;
    }

    public String getURLOptionalParameters() {
        return this.urlOptionalParameters;
    }

    private class DB2iSeriesJDBCURL {
        private String subprotocol = "";
        private String node = "";
        private String properties = "";

        public DB2iSeriesJDBCURL(String url) {
            this.parseURL(url);
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        private void parseURL(String url) {
            try {
                DB2ISeriesToolboxDriverUIContributor.this.setURLOptionalParameters("");
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.node = remainingURL.substring(0, remainingURL.indexOf(59));
                this.properties = remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                String userOptionalParameters = "";
                String userParameter = "";
                if (remainingURL != null && remainingURL.length() > 0) {
                    StringTokenizer st = new StringTokenizer(remainingURL, ";");
                    int tokenLength = st.countTokens();
                    int i = 0;
                    while (i < tokenLength) {
                        userParameter = st.nextToken();
                        if (userParameter != null && userParameter.length() > 0 && !userParameter.startsWith("prompt")) {
                            userOptionalParameters = String.valueOf(userOptionalParameters) + userParameter + ";";
                        }
                        ++i;
                    }
                    DB2ISeriesToolboxDriverUIContributor.this.setURLOptionalParameters(userOptionalParameters);
                }
            }
            catch (Exception exception) {}
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

