/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.security;

import java.io.File;
import org.eclipse.datatools.connectivity.internal.security.CipherProviderExtensions;
import org.eclipse.datatools.connectivity.internal.security.DefaultCipherProvider;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;

public class SecurityManager {
    private static SecurityManager sInstance;
    private ICipherProvider mDefaultCipherProvider = new DefaultCipherProvider();

    public static SecurityManager getInstance() {
        if (sInstance == null) {
            sInstance = new SecurityManager();
        }
        return sInstance;
    }

    private SecurityManager() {
    }

    public ICipherProvider getDefaultCipherProvider() {
        return this.mDefaultCipherProvider;
    }

    public org.eclipse.datatools.connectivity.security.ICipherProvider getCipherProvider(File profileStoreFile) {
        org.eclipse.datatools.connectivity.security.ICipherProvider provider = CipherProviderExtensions.getCipherProviderForFile(profileStoreFile);
        if (provider == null) {
            provider = this.getDefaultCipherProvider();
        }
        return provider;
    }

    public org.eclipse.datatools.connectivity.security.ICipherProvider getCipherProviderForFileExtension(String fileExtension) {
        org.eclipse.datatools.connectivity.security.ICipherProvider provider = CipherProviderExtensions.getCipherProviderForFileExtension(fileExtension);
        if (provider == null) {
            provider = this.getDefaultCipherProvider();
        }
        return provider;
    }
}

