/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.datatools.connectivity.ui.dse.dialogs.ProfileSelectionDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;

public class SelectProfileAction
extends Action
implements IObjectActionDelegate {
    protected Object m_selobj = null;
    protected IViewPart view = null;
    protected String profileName = null;

    public SelectProfileAction() {
    }

    public SelectProfileAction(String text) {
        super(text);
    }

    public SelectProfileAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public SelectProfileAction(String text, int style) {
        super(text, style);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart instanceof CommonNavigator) {
            this.view = (IViewPart)targetPart;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        this.showProfileSelectionDialog();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.m_selobj = null;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            this.m_selobj = structuredSelection.getFirstElement();
        }
    }

    private void showProfileSelectionDialog() {
        int ret;
        ProfileSelectionDialog dialog = new ProfileSelectionDialog(this.view.getSite().getShell());
        if (this.profileName != null) {
            dialog.setCPName(this.profileName);
        }
        if ((ret = dialog.open()) == 0) {
            this.profileName = dialog.getCPName();
        }
    }

    public void setCPName(String name) {
        this.profileName = name;
    }

    public String getCPName() {
        return this.profileName;
    }
}

