/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.qmltypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLModuleInfo;
import org.eclipse.cdt.qt.core.qmljs.IJSArrayExpression;
import org.eclipse.cdt.qt.core.qmljs.IJSExpression;
import org.eclipse.cdt.qt.core.qmljs.IQmlASTNode;
import org.eclipse.cdt.qt.core.qmljs.IQmlBinding;
import org.eclipse.cdt.qt.core.qmljs.IQmlProgram;
import org.eclipse.cdt.qt.core.qmljs.IQmlPropertyBinding;
import org.eclipse.cdt.qt.core.qmljs.IQmlQualifiedID;
import org.eclipse.cdt.qt.core.qmljs.IQmlRootObject;
import org.eclipse.cdt.qt.core.qmljs.IQmlScriptBinding;
import org.eclipse.cdt.qt.core.qmljs.QMLExpressionEvaluator;

public class QMLModelBuilder {
    private final Map<String, QMLModuleInfo> moduleMap = new HashMap<String, QMLModuleInfo>();

    public QMLModuleInfo addModule(String module, IQmlASTNode ast) {
        IQmlRootObject obj;
        QMLModuleInfo info = this.moduleMap.get(module);
        if (!this.moduleMap.containsKey(module) && this.ensureNode(ast, IQmlProgram.class) && this.ensureNode(obj = ((IQmlProgram)ast).getRootObject(), IQmlRootObject.class)) {
            info = new QMLModuleInfo(this, obj);
            this.moduleMap.put(module, info);
        }
        return info;
    }

    public QMLModuleInfo getModule(String module) {
        return this.moduleMap.get(module);
    }

    public boolean hasModule(String module) {
        return this.moduleMap.get(module) != null;
    }

    boolean ensureIdentifier(IQmlQualifiedID actual, String expected) {
        if (!actual.getName().equals(expected)) {
            Activator.log("[QmlTypes] Unexpected node identifier: expected '" + expected + "', but was '" + actual.getName() + "'");
            return false;
        }
        return true;
    }

    boolean ensureNode(IQmlASTNode actual, Class<? extends IQmlASTNode> expected) {
        if (!expected.isInstance(actual)) {
            Activator.log("[QmlTypes] Expected node '" + expected + "', but was '" + actual.getClass().getInterfaces()[0] + "'");
            return false;
        }
        return true;
    }

    boolean ensureValue(Object actual, Class<?> expected) {
        if (!expected.isInstance(actual)) {
            Activator.log("[QmlTypes] Unexpected value: expected '" + expected + "', but was '" + actual.getClass().getInterfaces()[0] + "'");
            return false;
        }
        return true;
    }

    void unexpectedNode(IQmlASTNode node) {
        Activator.log("[QmlTypes] Unexpected node '" + node.getClass().getInterfaces()[0] + "'");
    }

    String getStringBinding(IQmlPropertyBinding prop) {
        IQmlScriptBinding sb;
        IQmlBinding b = prop.getBinding();
        if (this.ensureNode(b, IQmlScriptBinding.class) && this.ensureNode((sb = (IQmlScriptBinding)b).getScript(), IJSExpression.class)) {
            try {
                Object value = QMLExpressionEvaluator.evaluateConstExpr((IJSExpression)sb.getScript());
                if (value instanceof String) {
                    return (String)value;
                }
            }
            catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                this.handleException(e);
            }
        }
        return null;
    }

    String[] getStringArrayBinding(IQmlPropertyBinding prop) {
        IQmlScriptBinding sb;
        ArrayList<String> result = new ArrayList<String>();
        IQmlBinding b = prop.getBinding();
        if (this.ensureNode(b, IQmlScriptBinding.class) && this.ensureNode((sb = (IQmlScriptBinding)b).getScript(), IJSArrayExpression.class)) {
            IJSArrayExpression arrExpr = (IJSArrayExpression)sb.getScript();
            for (IJSExpression expr : arrExpr.getElements()) {
                try {
                    Object value = QMLExpressionEvaluator.evaluateConstExpr(expr);
                    if (!(value instanceof String)) continue;
                    result.add((String)value);
                }
                catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                    this.handleException(e);
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public Integer[] getIntegerArrayBinding(IQmlPropertyBinding prop) {
        IQmlScriptBinding sb;
        ArrayList<Integer> result = new ArrayList<Integer>();
        IQmlBinding b = prop.getBinding();
        if (this.ensureNode(b, IQmlScriptBinding.class) && this.ensureNode((sb = (IQmlScriptBinding)b).getScript(), IJSArrayExpression.class)) {
            IJSArrayExpression arrExpr = (IJSArrayExpression)sb.getScript();
            for (IJSExpression expr : arrExpr.getElements()) {
                try {
                    Object value = QMLExpressionEvaluator.evaluateConstExpr(expr);
                    if (!(value instanceof Number)) continue;
                    result.add(((Number)value).intValue());
                }
                catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                    this.handleException(e);
                }
            }
        }
        return result.toArray(new Integer[result.size()]);
    }

    boolean getBooleanBinding(IQmlPropertyBinding prop) {
        IQmlScriptBinding sb;
        IQmlBinding b = prop.getBinding();
        if (this.ensureNode(b, IQmlScriptBinding.class) && this.ensureNode((sb = (IQmlScriptBinding)b).getScript(), IJSExpression.class)) {
            try {
                Object value = QMLExpressionEvaluator.evaluateConstExpr((IJSExpression)sb.getScript());
                if (value instanceof Number) {
                    return (Boolean)value;
                }
            }
            catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                this.handleException(e);
            }
        }
        return false;
    }

    public Integer getIntegerBinding(IQmlPropertyBinding prop) {
        IQmlScriptBinding sb;
        IQmlBinding b = prop.getBinding();
        if (this.ensureNode(b, IQmlScriptBinding.class) && this.ensureNode((sb = (IQmlScriptBinding)b).getScript(), IJSExpression.class)) {
            try {
                Object value = QMLExpressionEvaluator.evaluateConstExpr((IJSExpression)sb.getScript());
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
            }
            catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                this.handleException(e);
            }
        }
        return 0;
    }

    public void handleException(Throwable t) {
        Activator.log("[QmlTypes] " + t.getMessage());
    }
}

