/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.GDBProcesses_7_4;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl2;
import org.eclipse.cdt.dsf.gdb.service.StartOrRestartProcessSequence_7_10;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;

public class GDBProcesses_7_10
extends GDBProcesses_7_4 {
    public GDBProcesses_7_10(DsfSession session) {
        super(session);
    }

    @Override
    protected Sequence getStartOrRestartProcessSequence(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        return new StartOrRestartProcessSequence_7_10(executor, containerDmc, attributes, restart, rm);
    }

    @Override
    protected void doReverseDebugStep(IProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        block14: {
            IReverseRunControl2 reverseService = (IReverseRunControl2)this.getServicesTracker().getService(IReverseRunControl2.class);
            if (reverseService != null) {
                ILaunch launch = (ILaunch)procCtx.getAdapter(ILaunch.class);
                if (launch != null) {
                    try {
                        boolean reverseEnabled = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
                        if (reverseEnabled) {
                            ICommandControlService.ICommandControlDMContext controlContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)procCtx, ICommandControlService.ICommandControlDMContext.class);
                            String reverseMode = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.dsf.gdb.REVERSE_MODE", "UseSoftTrace");
                            if (reverseMode.equals("UseSoftTrace")) {
                                reverseService.enableReverseMode(controlContext, IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE, rm);
                            } else if (reverseMode.equals("UseHardTrace")) {
                                String defaultValue = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb..reversedebugpref.tracemethodHardware", "UseGdbTrace", null);
                                IChangeReverseMethodHandler.ReverseDebugMethod traceMethod = IChangeReverseMethodHandler.ReverseDebugMethod.GDB_TRACE;
                                if (defaultValue.equals("UseBranchTrace")) {
                                    traceMethod = IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE;
                                } else if (defaultValue.equals("UseProcessorTrace")) {
                                    traceMethod = IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE;
                                }
                                reverseService.enableReverseMode(controlContext, traceMethod, rm);
                            } else {
                                rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unexpected Reverse debugging mode " + reverseMode, null));
                            }
                            break block14;
                        }
                        rm.done();
                    }
                    catch (CoreException e) {
                        rm.done();
                    }
                } else {
                    rm.done();
                }
            } else {
                super.doReverseDebugStep(procCtx, rm);
            }
        }
    }
}

