/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.properties;

import org.eclipse.cdt.internal.autotools.core.configure.ConfigureMessages;
import org.eclipse.cdt.internal.autotools.core.configure.IAConfiguration;
import org.eclipse.cdt.internal.autotools.ui.properties.AbstractConfigurePropertyOptionsPage;
import org.eclipse.cdt.internal.autotools.ui.properties.ToolListElement;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.MultiLineTextFieldEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AutotoolsToolPropertyOptionPage
extends AbstractConfigurePropertyOptionsPage {
    private static final int MARGIN = 3;
    private String toolName = "";
    private IAConfiguration cfg;
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private StringFieldEditor commandStringField;
    private static final String ALL_OPTIONS = "Tool.allopts";
    private static final String COMMAND = "Tool.command";

    public AutotoolsToolPropertyOptionPage(ToolListElement element, IAConfiguration cfg) {
        super(element.getName());
        this.toolName = element.getName();
        this.cfg = cfg;
    }

    @Override
    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite area = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginTop = 3;
        gl.marginLeft = 3;
        gl.marginRight = 3;
        area.setLayout((Layout)gl);
        area.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        FontMetrics fm = AbstractCPropertyTab.getFontMetrics((Control)area);
        this.commandStringField = new StringFieldEditor(this.toolName, ConfigureMessages.getString((String)COMMAND), area);
        this.commandStringField.setEmptyStringAllowed(false);
        GridData gd = (GridData)this.commandStringField.getTextControl(area).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)3);
        this.addField((FieldEditor)this.commandStringField);
        this.allOptionFieldEditor = new MultiLineTextFieldEditor("", ConfigureMessages.getString((String)ALL_OPTIONS), area);
        this.allOptionFieldEditor.getTextControl(area).setEditable(false);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.allOptionFieldEditor);
    }

    @Override
    public void updateFields() {
        this.allOptionFieldEditor.load();
    }

    @Override
    public void setValues() {
        this.commandStringField.load();
        this.updateFields();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.commandStringField) {
            this.cfg.setOption(this.toolName, this.commandStringField.getStringValue());
            this.updateFields();
        }
    }
}

