/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.marker;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class MarkersPropertyPage
extends PropertyPage {
    public MarkersPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(5, 20).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.doCreateContents(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doCreateContents(Composite parent) {
        IMarker marker = (IMarker)this.getElement().getAdapter(IMarker.class);
        String message = marker.getAttribute("message", "(no message provided)");
        String stacktrace = marker.getAttribute(GradleErrorMarker.ATTRIBUTE_STACKTRACE, "(no stacktrace provided)");
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText("Message:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)messageLabel);
        Text messageText = new Text(parent, 2824);
        GridDataFactory.fillDefaults().hint(100, this.convertHeightInCharsToPixels(MarkersPropertyPage.countLines(message))).align(4, 128).grab(true, false).applyTo((Control)messageText);
        messageText.setText(message);
        Label stackTraceLabel = new Label(parent, 0);
        stackTraceLabel.setText("Stacktrace:");
        GridDataFactory.swtDefaults().align(16384, 128).applyTo((Control)stackTraceLabel);
        Text stacktraceAreaText = new Text(parent, 2826);
        GridDataFactory.fillDefaults().hint(100, 100).grab(true, true).applyTo((Control)stacktraceAreaText);
        stacktraceAreaText.setText(stacktrace);
    }

    public static int countLines(String str) {
        return Lists.newArrayList((Iterable)Splitter.on((String)System.lineSeparator()).split((CharSequence)str)).size();
    }
}

