/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class LibraryFilter {
    LibraryFilter() {
    }

    public static void update(IJavaProject eclipseProject, EclipseProject modelProject, IProgressMonitor monitor) throws JavaModelException {
        if (LibraryFilter.supportsClasspathCustomization(modelProject)) {
            IClasspathEntry[] newClasspath = LibraryFilter.filterLibraries(eclipseProject.getRawClasspath());
            eclipseProject.setRawClasspath(newClasspath, monitor);
        }
    }

    private static IClasspathEntry[] filterLibraries(IClasspathEntry[] classpath) throws JavaModelException {
        return (IClasspathEntry[])FluentIterable.from(Arrays.asList(classpath)).filter((Predicate)new Predicate<IClasspathEntry>(){

            public boolean apply(IClasspathEntry entry) {
                return entry.getEntryKind() != 1;
            }
        }).toArray(IClasspathEntry.class);
    }

    private static boolean supportsClasspathCustomization(EclipseProject modelProject) {
        return CompatEclipseProject.supportsClasspathContainers(modelProject);
    }
}

