/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public final class LaunchUtils {
    private LaunchUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void launch(String name, ILaunchConfiguration configuration, String mode, ILaunch launch, Optional<? extends Job> jobOrNull, IProgressMonitor monitor) {
        monitor.beginTask(name, -1);
        try {
            if (!jobOrNull.isPresent()) {
                return;
            }
            Job job = jobOrNull.get();
            final CountDownLatch latch = new CountDownLatch(1);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    latch.countDown();
                }
            });
            job.schedule();
            try {
                boolean cancelRequested = false;
                while (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                    if (!monitor.isCanceled() || cancelRequested) continue;
                    job.cancel();
                    cancelRequested = true;
                }
            }
            catch (InterruptedException e) {
                CorePlugin.logger().error("Failed to launch Gradle tasks.", e);
            }
        }
        finally {
            monitor.done();
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }
}

