/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.buildship.core.SynchronizationResult;
import org.eclipse.buildship.core.internal.CachingProjectConnection;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.configuration.TestRunConfiguration;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.marker.GradleErrorMarker;
import org.eclipse.buildship.core.internal.marker.GradleMarkerManager;
import org.eclipse.buildship.core.internal.operation.BaseToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.core.internal.util.gradle.IdeAttachedProjectConnection;
import org.eclipse.buildship.core.internal.workspace.ConnectionAwareLauncherProxy;
import org.eclipse.buildship.core.internal.workspace.DefaultModelProvider;
import org.eclipse.buildship.core.internal.workspace.ImportRootProjectOperation;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.ProjectConfigurators;
import org.eclipse.buildship.core.internal.workspace.RunOnImportTasksOperation;
import org.eclipse.buildship.core.internal.workspace.SynchronizationProblem;
import org.eclipse.buildship.core.internal.workspace.SynchronizeGradleBuildOperation;
import org.eclipse.buildship.core.internal.workspace.ValidateProjectLocationOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class DefaultGradleBuild
implements InternalGradleBuild {
    private static Map<File, SynchronizeOperation> syncOperations = new ConcurrentHashMap<File, SynchronizeOperation>();
    private final BuildConfiguration buildConfig;
    private final ModelProvider modelProvider;
    private final Cache<Object, Object> projectConnectionCache;

    public DefaultGradleBuild(BuildConfiguration buildConfiguration) {
        this.buildConfig = buildConfiguration;
        this.modelProvider = new DefaultModelProvider(this);
        this.projectConnectionCache = CacheBuilder.newBuilder().build();
    }

    @Override
    public SynchronizationResult synchronize(IProgressMonitor monitor) {
        return this.synchronize(NewProjectHandler.IMPORT_AND_MERGE, GradleConnector.newCancellationTokenSource(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationResult synchronize(NewProjectHandler newProjectHandler, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        SynchronizeOperation operation = new SynchronizeOperation(this, newProjectHandler);
        SynchronizeOperation runningOperation = syncOperations.putIfAbsent(this.getBuildConfig().getRootProjectDirectory(), operation);
        if (runningOperation != null && (newProjectHandler == NewProjectHandler.NO_OP || Objects.equals(newProjectHandler, runningOperation.newProjectHandler))) {
            return DefaultSynchronizationResult.success();
        }
        try {
            SynchronizationResult synchronizationResult = operation.run(tokenSource, monitor);
            return synchronizationResult;
        }
        finally {
            syncOperations.remove(this.getBuildConfig().getRootProjectDirectory());
        }
    }

    public boolean isSynchronizing() {
        return syncOperations.containsKey(this.getBuildConfig().getRootProjectDirectory());
    }

    @Override
    public <T> T withConnection(Function<ProjectConnection, ? extends T> action, IProgressMonitor monitor) throws Exception {
        return this.withConnection(action, GradleConnector.newCancellationTokenSource(), monitor);
    }

    @Override
    public <T> T withConnection(Function<ProjectConnection, ? extends T> action, CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        Preconditions.checkNotNull(action);
        monitor = monitor != null ? monitor : new NullProgressMonitor();
        GradleConnectionOperation<? extends T> operation = new GradleConnectionOperation<T>(action);
        try {
            CorePlugin.operationManager().run(operation, tokenSource, monitor);
            return (T)((GradleConnectionOperation)operation).result;
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof Exception) {
                throw (Exception)e.getStatus().getException();
            }
            throw e;
        }
    }

    @Override
    public ModelProvider getModelProvider() {
        return this.modelProvider;
    }

    @Override
    public BuildLauncher newBuildLauncher(RunConfiguration runConfiguration, GradleProgressAttributes progressAttributes) {
        return ConnectionAwareLauncherProxy.newBuildLauncher(runConfiguration.toGradleArguments(), progressAttributes);
    }

    @Override
    public TestLauncher newTestLauncher(TestRunConfiguration testRunConfiguration, GradleProgressAttributes progressAttributes) {
        return ConnectionAwareLauncherProxy.newTestLauncher(testRunConfiguration.toGradleArguments(), progressAttributes);
    }

    @Override
    public BuildConfiguration getBuildConfig() {
        return this.buildConfig;
    }

    public int hashCode() {
        return Objects.hash(this.buildConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultGradleBuild other = (DefaultGradleBuild)obj;
        return Objects.equals(this.buildConfig, other.buildConfig);
    }

    private static Set<EclipseProject> collectAll(Map<String, EclipseProject> models) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Map.Entry<String, EclipseProject> model : models.entrySet()) {
            result.addAll(HierarchicalElementUtils.getAll(model.getValue()));
        }
        return result.build();
    }

    private static class DefaultSynchronizationResult
    implements SynchronizationResult {
        private final IStatus status;

        private DefaultSynchronizationResult(IStatus status) {
            this.status = status;
        }

        @Override
        public IStatus getStatus() {
            return this.status;
        }

        public static DefaultSynchronizationResult success() {
            return new DefaultSynchronizationResult(Status.OK_STATUS);
        }

        public static DefaultSynchronizationResult from(List<SynchronizationProblem> failures) {
            if (failures.isEmpty()) {
                return DefaultSynchronizationResult.success();
            }
            if (failures.size() == 1) {
                return DefaultSynchronizationResult.from(DefaultSynchronizationResult.statusFor(failures.get(0)));
            }
            boolean internalFailure = failures.stream().filter(f -> "org.eclipse.buildship.core".equals(f.getPluginId())).findFirst().isPresent();
            String pluginId = internalFailure ? "org.eclipse.buildship.core" : failures.get(0).getPluginId();
            MultiStatus status = new MultiStatus(pluginId, 0, "Gradle synchronization failed with multiple errors", null);
            failures.forEach(f -> status.addAll(DefaultSynchronizationResult.statusFor(f)));
            return DefaultSynchronizationResult.from((IStatus)status);
        }

        public static DefaultSynchronizationResult from(IStatus status) {
            return new DefaultSynchronizationResult(status);
        }

        private static IStatus statusFor(SynchronizationProblem failure) {
            return new Status(failure.getSeverity(), failure.getPluginId(), failure.getMessage(), (Throwable)failure.getException());
        }
    }

    private class GradleConnectionOperation<T>
    extends BaseToolingApiOperation {
        private final Function<ProjectConnection, ? extends T> action;
        private T result;

        public GradleConnectionOperation(Function<ProjectConnection, ? extends T> action) {
            super("Connecting to Gradle");
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
            ProjectConnection connection = IdeAttachedProjectConnection.newInstance(tokenSource, this.getGradleArguments(), monitor);
            if (DefaultGradleBuild.this.isSynchronizing()) {
                connection = new CachingProjectConnection(connection, (Cache<Object, Object>)DefaultGradleBuild.this.projectConnectionCache);
            }
            try {
                this.result = this.action.apply(connection);
            }
            finally {
                connection.close();
            }
        }

        private GradleArguments getGradleArguments() {
            return DefaultGradleBuild.this.buildConfig.toGradleArguments();
        }

        @Override
        public ISchedulingRule getRule() {
            return null;
        }
    }

    private static class SynchronizeOperation
    extends BaseToolingApiOperation {
        private final DefaultGradleBuild gradleBuild;
        private final NewProjectHandler newProjectHandler;
        private List<SynchronizationProblem> failures;

        public SynchronizeOperation(DefaultGradleBuild gradleBuild, NewProjectHandler newProjectHandler) {
            super("Synchronize project " + gradleBuild.getBuildConfig().getRootProjectDirectory().getName());
            this.gradleBuild = gradleBuild;
            this.newProjectHandler = newProjectHandler;
        }

        SynchronizationResult run(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
            DefaultSynchronizationResult result;
            GradleMarkerManager.clear(this.gradleBuild);
            try {
                CorePlugin.operationManager().run(this, tokenSource, monitor);
                for (SynchronizationProblem f : this.failures) {
                    if (f.getSeverity() == 4) {
                        GradleErrorMarker.createError(f.getResource(), this.gradleBuild, f.getMessage(), f.getException(), 0);
                        continue;
                    }
                    if (f.getSeverity() != 2) continue;
                    GradleErrorMarker.createWarning(f.getResource(), this.gradleBuild, f.getMessage(), f.getException(), 0);
                }
                result = DefaultSynchronizationResult.from(this.getFailures());
            }
            catch (CoreException e) {
                ToolingApiStatus status = ToolingApiStatus.from("Project synchronization", e);
                if (status.severityMatches(6)) {
                    GradleMarkerManager.addError(this.gradleBuild, status);
                }
                result = DefaultSynchronizationResult.from(e.getStatus());
            }
            if (result.status.matches(6)) {
                CorePlugin.getInstance().getLog().log(result.status);
            }
            return result;
        }

        public List<SynchronizationProblem> getFailures() {
            return this.failures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                progress.setTaskName(String.format("Synchronizing Gradle build at %s with workspace", this.gradleBuild.getBuildConfig().getRootProjectDirectory()));
                new ImportRootProjectOperation(this.gradleBuild.getBuildConfig(), this.newProjectHandler).run((IProgressMonitor)progress.newChild(1));
                Set allProjects = DefaultGradleBuild.collectAll(this.gradleBuild.modelProvider.fetchEclipseProjectAndRunSyncTasks(tokenSource, (IProgressMonitor)progress.newChild(1)));
                new ValidateProjectLocationOperation(allProjects).run((IProgressMonitor)progress.newChild(1));
                new RunOnImportTasksOperation(allProjects, this.gradleBuild.getBuildConfig()).run((IProgressMonitor)progress.newChild(1), tokenSource);
                this.failures = new SynchronizeGradleBuildOperation(allProjects, this.gradleBuild, this.newProjectHandler, ProjectConfigurators.create(this.gradleBuild, CorePlugin.extensionManager().loadConfigurators())).run((IProgressMonitor)progress.newChild(1));
            }
            finally {
                this.gradleBuild.projectConnectionCache.invalidateAll();
            }
        }

        @Override
        public ISchedulingRule getRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        public int hashCode() {
            return Objects.hash(this.gradleBuild, this.newProjectHandler);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SynchronizeOperation other = (SynchronizeOperation)obj;
            return Objects.equals(this.gradleBuild, other.gradleBuild) && Objects.equals(this.newProjectHandler, other.newProjectHandler);
        }
    }
}

