/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ResizeExpandableActivityFeature
extends DefaultResizeBPMNShapeFeature {
    public ResizeExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        ResizeShapeContext resizeShapeContext = (ResizeShapeContext)context;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        Point containerShapeCenter = GraphicsUtil.getShapeCenter((AnchorContainer)containerShape);
        Activity activity = (Activity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        ArrayList<ContainerShape> movedChildren = new ArrayList<ContainerShape>();
        List containerChildren = FeatureSupport.getContainerChildren((ContainerShape)containerShape);
        try {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)containerShape);
            BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)activity);
            if (bpmnShape.isIsExpanded()) {
                if (FeatureSupport.isElementExpanded((PictogramElement)containerShape)) {
                    GraphicsAlgorithm childGa;
                    FeatureSupport.ExpandableActivitySizeCalculator sizeCalc = new FeatureSupport.ExpandableActivitySizeCalculator(resizeShapeContext);
                    int deltaX = sizeCalc.deltaX;
                    int deltaY = sizeCalc.deltaY;
                    if (deltaX != 0) {
                        for (PictogramElement pe : containerChildren) {
                            childGa = pe.getGraphicsAlgorithm();
                            if (childGa == null) continue;
                            int x = childGa.getX() - deltaX;
                            childGa.setX(x);
                            if (!(pe instanceof ContainerShape)) continue;
                            movedChildren.add((ContainerShape)pe);
                        }
                    }
                    if (deltaY != 0) {
                        for (PictogramElement pe : containerChildren) {
                            childGa = pe.getGraphicsAlgorithm();
                            if (childGa == null) continue;
                            int y = childGa.getY() - deltaY;
                            childGa.setY(y);
                            if (movedChildren.contains(pe) || !(pe instanceof ContainerShape)) continue;
                            movedChildren.add((ContainerShape)pe);
                        }
                    }
                }
                super.resizeShape(context);
                if (FeatureSupport.isElementExpanded((PictogramElement)containerShape)) {
                    FeatureSupport.updateExpandedSize((ContainerShape)containerShape);
                }
            } else {
                for (PictogramElement pe : FeatureSupport.getContainerDecorators((ContainerShape)containerShape)) {
                    GraphicsAlgorithm childGa = pe.getGraphicsAlgorithm();
                    if (childGa == null) continue;
                    childGa.setWidth(context.getWidth());
                    childGa.setHeight(context.getHeight());
                }
                super.resizeShape(context);
                if (!FeatureSupport.isElementExpanded((PictogramElement)containerShape)) {
                    FeatureSupport.updateCollapsedSize((ContainerShape)containerShape);
                }
            }
            ArrayList<ContainerShape> alreadyMoved = new ArrayList<ContainerShape>();
            this.moveNeighborShapes(containerShape, containerShapeCenter, alreadyMoved);
        }
        catch (Exception e) {
            Activator.logError((Exception)e);
        }
        FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), movedChildren);
    }

    private void moveNeighborShapes(ContainerShape movedShape, Point movedShapeCenter, List<ContainerShape> alreadyMoved) {
        ArrayList<ContainerShape> movedShapes = new ArrayList<ContainerShape>();
        GraphicsUtil.LineSegment[] containerEdges = GraphicsUtil.getEdges((Shape)movedShape);
        ContainerShape movedShapeContainer = movedShape.getContainer();
        List neighborShapes = FeatureSupport.findAllShapes((ContainerShape)movedShapeContainer, (ContainerShape[])new ContainerShape[]{movedShape});
        for (ContainerShape s : neighborShapes) {
            if (!GraphicsUtil.intersects((Shape)movedShape, (Shape)s, (int)10) || s.getContainer() != movedShapeContainer) continue;
            GraphicsAlgorithm sGA = s.getGraphicsAlgorithm();
            int x0 = sGA.getX();
            int y0 = sGA.getY();
            int x1 = x0;
            int y1 = y0;
            Point p1 = GraphicsUtil.getShapeCenter((AnchorContainer)s);
            int dx = p1.getX() - movedShapeCenter.getX();
            int dy = p1.getY() - movedShapeCenter.getY();
            if (Math.abs(dx) > Math.abs(dy)) {
                x1 = dx < 0 ? containerEdges[2].getStart().getX() - sGA.getWidth() - 20 : containerEdges[3].getStart().getX() + 20;
            } else {
                y1 = dy < 0 ? containerEdges[0].getStart().getY() - sGA.getHeight() - 20 : containerEdges[1].getStart().getY() + 20;
            }
            movedShapes.add(s);
            MoveShapeContext moveContext = new MoveShapeContext((Shape)s);
            moveContext.setDeltaX(x1 - x0);
            moveContext.setDeltaY(y1 - y0);
            moveContext.setSourceContainer(movedShapeContainer);
            moveContext.setTargetContainer(movedShapeContainer);
            moveContext.setLocation(x1, y1);
            moveContext.putProperty((Object)"activity.move", (Object)true);
            IMoveShapeFeature moveFeature = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
            if (!moveFeature.canMoveShape((IMoveShapeContext)moveContext)) continue;
            moveFeature.moveShape((IMoveShapeContext)moveContext);
        }
        for (ContainerShape shape : movedShapes) {
            if (alreadyMoved.contains(shape)) continue;
            alreadyMoved.add(shape);
            this.moveNeighborShapes(shape, movedShapeCenter, alreadyMoved);
            FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (AnchorContainer)shape);
        }
    }
}

