/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.Bpmn2TabbedPropertySheetPage;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.model.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.model.ProxyURIConverterImplExtension;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntimeAdapter;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.DiagramEditorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2ToolBehaviorProvider;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2EditingDomainListener;
import org.eclipse.bpmn2.modeler.ui.editor.ConnectionLayerClippingStrategy;
import org.eclipse.bpmn2.modeler.ui.editor.DefaultBPMN2EditorDiagramBehavior;
import org.eclipse.bpmn2.modeler.ui.editor.Messages;
import org.eclipse.bpmn2.modeler.ui.property.PropertyTabDescriptorProvider;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorOutlinePage;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorSelectionSynchronizer;
import org.eclipse.bpmn2.modeler.ui.wizards.BPMN2DiagramCreator;
import org.eclipse.bpmn2.modeler.ui.wizards.FileService;
import org.eclipse.bpmn2.util.Bpmn2ResourceImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.GFPaletteRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class DefaultBPMN2Editor
extends DiagramEditor
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String CONTRIBUTOR_ID = "org.eclipse.bpmn2.modeler.ui.PropertyContributor";
    protected ModelHandler modelHandler;
    protected URI modelUri;
    protected URI diagramUri;
    private boolean editable = true;
    protected BPMNDiagram bpmnDiagram;
    protected Bpmn2ResourceImpl bpmnResource;
    private IEditorInput currentInput;
    private static ITabDescriptorProvider tabDescriptorProvider;
    private BPMN2EditingDomainListener editingDomainListener;
    private boolean selectionChanging;
    protected Bpmn2Preferences preferences;
    protected TargetRuntime targetRuntime;
    private ModelEnablements modelEnablements;
    private boolean importInProgress;
    private BPMN2EditorSelectionSynchronizer synchronizer;
    protected DiagramEditorAdapter editorAdapter;
    protected IPropertySheetPage propertySheetPage;
    protected IContentOutlinePage outlinePage;
    protected boolean saveInProgress = false;
    private static NotificationFilter filterNone;

    static {
        TargetRuntime.createTargetRuntimes();
        filterNone = new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                return false;
            }
        };
    }

    public IEditorInput getEditorInput() {
        return this.currentInput;
    }

    protected DiagramEditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.currentInput = input;
        if (this.getDiagramBehavior() == null) {
            super.init(site, input);
        } else if (input instanceof Bpmn2DiagramEditorInput) {
            this.bpmnDiagram = ((Bpmn2DiagramEditorInput)input).getBpmnDiagram();
            if (this.bpmnDiagram != null) {
                this.setBpmnDiagram(this.bpmnDiagram);
            }
        }
    }

    protected Bpmn2DiagramEditorInput createNewDiagramEditorInput(IEditorInput input, ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace) throws PartInitException {
        this.modelUri = FileService.getInputUri(input);
        if (this.modelUri == null) {
            throw new PartInitException(Messages.BPMN2Editor_Cannot_Create_Editor_Input);
        }
        input = BPMN2DiagramCreator.createDiagram(input, this.modelUri, diagramType, targetNamespace, this);
        this.diagramUri = ((Bpmn2DiagramEditorInput)((Object)input)).getUri();
        return (Bpmn2DiagramEditorInput)((Object)input);
    }

    private void saveModelFile() {
        try {
            this.bpmnResource.save(null);
            ((BasicCommandStack)this.getEditingDomain().getCommandStack()).saveIsDone();
            this.updateDirtyState();
        }
        catch (IOException e) {
            Activator.logError(e);
        }
    }

    protected EditorInputHelper getInputHelper() {
        return new EditorInputHelper();
    }

    protected void setInput(IEditorInput input) {
        EditorInputHelper inputHelper = this.getInputHelper();
        inputHelper.preSetInput(input, this);
        super.setInput(input);
        inputHelper.postSetInput(input, this);
    }

    protected DiagramEditorInput convertToDiagramEditorInput(IEditorInput input) throws PartInitException {
        Bpmn2DiagramEditorInput newInput = this.createNewDiagramEditorInput(input, ModelUtil.Bpmn2DiagramType.NONE, "");
        if (newInput == null) {
            newInput = super.convertToDiagramEditorInput(input);
        }
        return newInput;
    }

    protected void importDiagram() {
        try {
            this.importInProgress = true;
            Diagram diagram = this.getDiagramTypeProvider().getDiagram();
            IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
            diagram.setActive(true);
            Bpmn2DiagramEditorInput input = (Bpmn2DiagramEditorInput)this.getEditorInput();
            ModelUtil.Bpmn2DiagramType diagramType = input.getInitialDiagramType();
            String targetNamespace = input.getTargetNamespace();
            if (diagramType != ModelUtil.Bpmn2DiagramType.NONE) {
                this.bpmnDiagram = this.modelHandler.createDiagramType(diagramType, targetNamespace);
                featureProvider.link((PictogramElement)diagram, (Object)this.bpmnDiagram);
                this.saveModelFile();
            } else if (targetNamespace != null && !targetNamespace.isEmpty()) {
                this.modelHandler.getDefinitions().setTargetNamespace(targetNamespace);
            }
            DIImport di = new DIImport((IDiagramContainer)this, this.getPreferences());
            di.setModelHandler(this.modelHandler);
            di.generateFromDI();
        }
        finally {
            this.importInProgress = false;
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDirty() {
        if (!this.editable) {
            return false;
        }
        if (this.getEditorInput() == null) {
            return false;
        }
        return super.isDirty();
    }

    protected DiagramBehavior createDiagramBehavior() {
        DefaultBPMN2EditorDiagramBehavior diagramBehavior = new DefaultBPMN2EditorDiagramBehavior(this);
        return diagramBehavior;
    }

    public Bpmn2Preferences getPreferences() {
        if (this.preferences == null) {
            this.loadPreferences(this.getProject());
        }
        return this.preferences;
    }

    private void loadPreferences(IProject project) {
        this.preferences = Bpmn2Preferences.getInstance((IProject)project);
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public String getContributorId() {
        return CONTRIBUTOR_ID;
    }

    public TargetRuntime getTargetRuntime() {
        if (this.targetRuntime == null) {
            this.targetRuntime = this.getTargetRuntime(this.getEditorInput());
        }
        return this.targetRuntime;
    }

    public ModelEnablements getModelEnablements() {
        String profileName = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime());
        if (this.modelEnablements != null && !this.modelEnablements.getId().equals(profileName)) {
            this.modelEnablements = null;
        }
        if (this.modelEnablements == null) {
            this.modelEnablements = this.getPreferences().getModelEnablements(this.getTargetRuntime(), profileName);
            if (this.modelEnablements.size() == 0) {
                profileName = this.getPreferences().getDefaultToolProfile(TargetRuntime.getDefaultRuntime());
                ModelEnablements defaultEnablements = this.getPreferences().getModelEnablements(TargetRuntime.getDefaultRuntime(), profileName);
                this.modelEnablements.copy(defaultEnablements);
            }
        }
        return this.modelEnablements;
    }

    protected TargetRuntime getTargetRuntime(IEditorInput input) {
        if (this.targetRuntime == null && input != null) {
            if (input instanceof Bpmn2DiagramEditorInput) {
                this.targetRuntime = ((Bpmn2DiagramEditorInput)input).getRuntime();
            }
            if (this.targetRuntime == null) {
                this.targetRuntime = TargetRuntime.getRuntime((IEditorInput)input);
            }
        }
        return this.targetRuntime;
    }

    public void updatePalette() {
        GFPaletteRoot pr = (GFPaletteRoot)this.getPaletteRoot();
        if (pr != null) {
            this.modelEnablements = null;
            pr.updatePaletteEntries();
            Bpmn2ToolBehaviorProvider toolBehaviorProvider = (Bpmn2ToolBehaviorProvider)this.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
            toolBehaviorProvider.createPaletteProfilesGroup(this, (PaletteRoot)pr);
        }
    }

    public void refreshTitle() {
        if (this.getEditorInput() != null) {
            String name = this.getEditorInput().getName();
            this.setPartName(URI.decode((String)name));
        }
    }

    public BPMN2EditingDomainListener getEditingDomainListener() {
        if (this.editingDomainListener == null) {
            TransactionalEditingDomainImpl editingDomain = (TransactionalEditingDomainImpl)this.getEditingDomain();
            if (editingDomain == null) {
                return null;
            }
            this.editingDomainListener = new BPMN2EditingDomainListener(this);
            TransactionalEditingDomain.Lifecycle domainLifeCycle = (TransactionalEditingDomain.Lifecycle)editingDomain.getAdapter(TransactionalEditingDomain.Lifecycle.class);
            domainLifeCycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)this.editingDomainListener);
        }
        return this.editingDomainListener;
    }

    public BasicDiagnostic getDiagnostics() {
        return this.getEditingDomainListener().getDiagnostics();
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new BPMN2EditorSelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public Object getAdapter(Class required) {
        if (required == DiagramEditor.class) {
            return this;
        }
        if (required == ITabDescriptorProvider.class) {
            if (tabDescriptorProvider == null) {
                tabDescriptorProvider = new PropertyTabDescriptorProvider();
            }
            return tabDescriptorProvider;
        }
        if (required == TargetRuntime.class) {
            return this.getTargetRuntime();
        }
        if (required == Bpmn2Preferences.class) {
            return this.getPreferences();
        }
        if (required == IPropertySheetPage.class) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new Bpmn2TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!DefaultBPMN2Editor.this.propertySheetPage.getControl().isDisposed()) {
                            DefaultBPMN2Editor.this.propertySheetPage.getControl().addDisposeListener(new DisposeListener(){

                                public void widgetDisposed(DisposeEvent e) {
                                    (this).DefaultBPMN2Editor.this.propertySheetPage = null;
                                }
                            });
                        }
                    }
                });
            }
            return this.propertySheetPage;
        }
        if (required == SelectionSynchronizer.class) {
            return this.getSelectionSynchronizer();
        }
        if (required == IContentOutlinePage.class && this.getDiagramTypeProvider() != null) {
            if (this.outlinePage == null) {
                this.outlinePage = new BPMN2EditorOutlinePage(this);
            }
            return this.outlinePage;
        }
        if (required == ModelEnablements.class) {
            return this.getModelEnablements();
        }
        if (required == ToolPaletteDescriptor.class) {
            String profileName = this.getPreferences().getDefaultToolProfile(this.getTargetRuntime());
            return this.getTargetRuntime().getToolPalette(profileName);
        }
        if (required == NotificationFilter.class) {
            if (this.saveInProgress) {
                return filterNone;
            }
            return null;
        }
        if (required == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (required == Resource.class) {
            return this.getResource();
        }
        return super.getAdapter(required);
    }

    public void dispose() {
        if (this.targetRuntime != null) {
            this.targetRuntime.notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_SHUTDOWN, (Object)this, this.targetRuntime));
        }
        if (this.modelHandler != null) {
            this.modelHandler.dispose();
        }
        if (this.preferences != null) {
            this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.selectionChanged((IWorkbenchPart)this, null);
        }
        if (tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        if (this.getResourceSet() != null) {
            this.getResourceSet().eAdapters().remove((Object)this.getEditorAdapter());
        }
        super.dispose();
        if (this.modelUri != null) {
            ModelHandlerLocator.remove((URI)this.modelUri);
        }
        if (this.preferences != null) {
            this.preferences.dispose();
        }
        this.currentInput = null;
    }

    public IPath getModelPath() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getFullPath();
        }
        return null;
    }

    public IProject getProject() {
        if (this.getModelFile() != null) {
            return this.getModelFile().getProject();
        }
        return null;
    }

    public IFile getModelFile() {
        String uriString;
        if (this.modelUri != null && (uriString = this.modelUri.trimFragment().toPlatformString(true)) != null) {
            Path fullPath = new Path(uriString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)fullPath);
        }
        return null;
    }

    public URI getModelUri() {
        return this.modelUri;
    }

    public URI getDiagramUri() {
        return this.diagramUri;
    }

    public ModelHandler getModelHandler() {
        return this.modelHandler;
    }

    public Resource getResource() {
        return this.bpmnResource;
    }

    public ResourceSet getResourceSet() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        return editingDomain != null ? editingDomain.getResourceSet() : null;
    }

    public void refresh() {
        if (!this.importInProgress) {
            this.getDiagramBehavior().getRefreshBehavior().refresh();
        }
    }

    public void createPartControl(Composite parent) {
        if (this.getGraphicalViewer() == null) {
            super.createPartControl(parent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpmn2.modeler.help.TOC");
        }
    }

    public BPMNDiagram getBpmnDiagram() {
        Definitions definitions;
        if (this.bpmnDiagram == null && (definitions = ModelUtil.getDefinitions((Object)this.bpmnResource)) != null && definitions.getDiagrams().size() > 0) {
            this.bpmnDiagram = (BPMNDiagram)definitions.getDiagrams().get(0);
        }
        return this.bpmnDiagram;
    }

    public void setBpmnDiagram(BPMNDiagram bpmnDiagram) {
        Diagram diagram = DIUtils.getOrCreateDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)bpmnDiagram);
        this.selectPictogramElements(new PictogramElement[0]);
        this.getDiagramTypeProvider().resourceReloaded(diagram);
        this.getDiagramBehavior().getRefreshBehavior().initRefresh();
        this.setPictogramElementsForSelection(null);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)diagram);
        EditPart ep = viewer.getRootEditPart().getContents();
        if (ep instanceof AbstractGraphicalEditPart) {
            IFigure fig = ((AbstractGraphicalEditPart)ep).getFigure();
            fig.setBorder((Border)new MarginBorder(0, 0, 50, 50));
        }
        ConnectionLayerClippingStrategy.applyTo(viewer);
        this.getDiagramBehavior().refreshContent();
        this.bpmnDiagram = bpmnDiagram;
        this.modelEnablements = null;
    }

    public void doSave(IProgressMonitor monitor) {
        final PictogramElement[] selections = this.getSelectedPictogramElements();
        try {
            this.saveInProgress = true;
            super.doSave(monitor);
        }
        finally {
            this.saveInProgress = false;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                DefaultBPMN2Editor.this.selectPictogramElements(selections);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return this.getModelFile() != null;
    }

    public synchronized void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.selectionChanging && selection instanceof IStructuredSelection) {
            try {
                this.selectionChanging = true;
                Iterator iter = ((IStructuredSelection)selection).iterator();
                ArrayList filteredObjects = new ArrayList();
                ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
                while (iter.hasNext()) {
                    Object model;
                    boolean addIt = true;
                    Object o = iter.next();
                    if (o instanceof EditPart && (model = ((EditPart)o).getModel()) instanceof PictogramElement) {
                        if (FeatureSupport.isLabelShape((PictogramElement)((PictogramElement)model))) {
                            addIt = false;
                        } else {
                            pictogramElements.add((PictogramElement)model);
                        }
                    }
                    if (!addIt) continue;
                    filteredObjects.add(o);
                }
                StructuredSelection filteredSelection = new StructuredSelection(filteredObjects);
                super.selectionChanged(part, (ISelection)filteredSelection);
                super.selectPictogramElements(pictogramElements.toArray(new PictogramElement[pictogramElements.size()]));
                this.updateActions(this.getSelectionActions());
            }
            finally {
                this.selectionChanging = false;
            }
        }
    }

    public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
        this.getPreferences().reload();
        if (event.getKey().contains("/model.enablement/")) {
            this.modelEnablements = null;
        }
        if ((event.getKey().contains("show.advanced.properties") || event.getKey().contains("/tool.profile/")) && tabDescriptorProvider instanceof PropertyTabDescriptorProvider) {
            ((PropertyTabDescriptorProvider)tabDescriptorProvider).disposeTabDescriptors((Resource)this.bpmnResource);
        }
        if (event.getKey().contains("/shape.style/")) {
            int i = event.getKey().lastIndexOf(47);
            if (i <= 0) {
                return;
            }
            final String name = event.getKey().substring(i + 1);
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    IFeatureProvider fp = DefaultBPMN2Editor.this.getDiagramTypeProvider().getFeatureProvider();
                    Resource resource = DefaultBPMN2Editor.this.getDiagramTypeProvider().getDiagram().eResource();
                    for (PictogramElement pe : ModelUtil.getAllObjectsOfType((Resource)resource, PictogramElement.class)) {
                        UpdateContext context;
                        IUpdateFeature feature;
                        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
                        if (be == null || !be.eClass().getName().equals(name)) continue;
                        GraphicsAlgorithm ga = StyleUtil.getShapeStyleContainer((PictogramElement)pe);
                        String style = ShapeStyle.encode((ShapeStyle)ShapeStyle.getShapeStyle((BaseElement)be));
                        if (!style.equals(event.getNewValue())) continue;
                        StyleUtil.applyStyle((GraphicsAlgorithm)ga, (BaseElement)be);
                        if (!(pe instanceof Shape) || !FeatureSupport.isLabelShape((PictogramElement)pe) || (feature = fp.getUpdateFeature((IUpdateContext)(context = new UpdateContext(pe)))) == null || !feature.canUpdate((IUpdateContext)context)) continue;
                        feature.update((IUpdateContext)context);
                    }
                }
            });
        }
        if (event.getKey().contains(ShapeStyle.Category.GRID.toString())) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    ShapeStyle ss = DefaultBPMN2Editor.this.getPreferences().getShapeStyle(ShapeStyle.Category.GRID);
                    Diagram diagram = DefaultBPMN2Editor.this.getDiagramTypeProvider().getDiagram();
                    diagram.setGridUnit(ss.getDefaultWidth());
                    diagram.setVerticalGridUnit(ss.getDefaultHeight());
                    diagram.setSnapToGrid(ss.getSnapToGrid());
                    GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
                    IGaService gaService = Graphiti.getGaService();
                    ga.setForeground(gaService.manageColor(diagram, ss.getShapeForeground()));
                    DefaultBPMN2Editor.this.refresh();
                    DefaultBPMN2Editor.this.getGraphicalControl().redraw();
                    DefaultBPMN2Editor.this.getGraphicalControl().getDisplay().update();
                }
            });
        }
        if (event.getKey().contains(ShapeStyle.Category.CANVAS.toString())) {
            this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

                protected void doExecute() {
                    ShapeStyle ss = DefaultBPMN2Editor.this.getPreferences().getShapeStyle(ShapeStyle.Category.CANVAS);
                    Diagram diagram = DefaultBPMN2Editor.this.getDiagramTypeProvider().getDiagram();
                    GraphicsAlgorithm ga = diagram.getGraphicsAlgorithm();
                    IGaService gaService = Graphiti.getGaService();
                    ga.setBackground(gaService.manageColor(diagram, ss.getShapeBackground()));
                    DefaultBPMN2Editor.this.refresh();
                    DefaultBPMN2Editor.this.getGraphicalControl().redraw();
                }
            });
        }
    }

    public static IEditorPart openEditor(URI modelURI) {
        IEditorPart part = null;
        try {
            Bpmn2DiagramEditorInput input = BPMN2DiagramCreator.createDiagram(modelURI, ModelUtil.Bpmn2DiagramType.NONE, "");
            part = BPMN2DiagramCreator.openEditor(input);
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        return part;
    }

    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public class EditorInputHelper {
        public void preSetInput(IEditorInput input, DefaultBPMN2Editor editor) {
            input = this.recreateInput(input, editor);
            ResourceSet resourceSet = this.initializeResourceSet(input, editor);
            editor.bpmnResource = this.createBPMN2Resource(editor, resourceSet);
        }

        protected IEditorInput recreateInput(IEditorInput input, DefaultBPMN2Editor editor) {
            try {
                if (input instanceof Bpmn2DiagramEditorInput) {
                    ModelUtil.Bpmn2DiagramType diagramType = ModelUtil.Bpmn2DiagramType.NONE;
                    String targetNamespace = null;
                    diagramType = ((Bpmn2DiagramEditorInput)((Object)input)).getInitialDiagramType();
                    targetNamespace = ((Bpmn2DiagramEditorInput)((Object)input)).getTargetNamespace();
                    input = editor.createNewDiagramEditorInput((IEditorInput)input, diagramType, targetNamespace);
                }
                editor.currentInput = input;
            }
            catch (Exception e) {
                Activator.logError(e);
            }
            return input;
        }

        protected ResourceSet initializeResourceSet(IEditorInput input, DefaultBPMN2Editor editor) {
            TargetRuntime targetRuntime = editor.getTargetRuntime(input);
            targetRuntime.notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_STARTUP, (Object)editor, targetRuntime));
            ResourceSet resourceSet = editor.getEditingDomain().getResourceSet();
            resourceSet.setURIConverter((URIConverter)new ProxyURIConverterImplExtension(editor.modelUri));
            editor.editorAdapter = new DiagramEditorAdapter((DiagramEditor)editor);
            resourceSet.eAdapters().add((Object)editor.editorAdapter);
            targetRuntime.registerExtensionResourceFactory(resourceSet);
            return resourceSet;
        }

        protected Bpmn2ResourceImpl createBPMN2Resource(DefaultBPMN2Editor editor, ResourceSet resourceSet) {
            Bpmn2ResourceImpl resource = (Bpmn2ResourceImpl)resourceSet.createResource(editor.modelUri, "org.eclipse.bpmn2.content-type.xml");
            TargetRuntimeAdapter.adapt((Resource)resource, (TargetRuntime)DefaultBPMN2Editor.this.getTargetRuntime());
            return resource;
        }

        public void postSetInput(IEditorInput input, DefaultBPMN2Editor editor) {
            editor.getEditingDomainListener();
            editor.modelHandler = ModelHandlerLocator.createModelHandler((URI)editor.modelUri, (Bpmn2ResourceImpl)editor.bpmnResource);
            ModelHandlerLocator.put((URI)editor.diagramUri, (ModelHandler)editor.modelHandler);
            TargetRuntime rt = editor.getTargetRuntime();
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.EDITOR_INITIALIZED, (Object)editor, rt));
            this.importDiagram(input, editor);
        }

        protected void importDiagram(IEditorInput input, final DefaultBPMN2Editor editor) {
            try {
                editor.getPreferences().setDoCoreValidation(false);
                BasicCommandStack commandStack = (BasicCommandStack)editor.getEditingDomain().getCommandStack();
                commandStack.execute((Command)new RecordingCommand(editor.getEditingDomain()){

                    protected void doExecute() {
                        editor.importDiagram();
                    }
                });
                Definitions definitions = ModelUtil.getDefinitions((Object)editor.bpmnResource);
                if (definitions != null) {
                    ((Bpmn2DiagramEditorInput)input).setTargetNamespace(definitions.getTargetNamespace());
                    ((Bpmn2DiagramEditorInput)input).setInitialDiagramType(ModelUtil.getDiagramType((DiagramEditor)editor));
                }
                commandStack.saveIsDone();
                commandStack.flush();
            }
            finally {
                editor.getPreferences().setDoCoreValidation(true);
            }
        }
    }
}

