/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeAttributeValueFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class ProcessValidator
extends CValidator {
    String ncName;
    protected String fExitStandardFault;
    protected String fSupressJoinFailure;
    protected List<INode> fStartActivities;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
        this.fTypeToCheckList = new LinkedList();
        this.fStartActivities = new ArrayList<INode>();
        this.setValue("types.to.check", this.fTypeToCheckList);
        this.setValue("start.activities", this.fStartActivities);
    }

    @ARule(date="9/14/2006", desc="Rule to check the name of the process", author="michal.chmielewski@oracle.com", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_NAME);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the expression language for support in the BPEL model", date="9/14/2006", sa=4, errors="BPELC__UNSUPPORTED_XML_LANG")
    public void rule_CheckExpressionLanguage_3() {
        String value = this.mNode.getAttribute(AT_EXPRESSIONLANGUAGE);
        if (ProcessValidator.isEmpty(value)) {
            value = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
        }
        this.setValue(AT_EXPRESSIONLANGUAGE, value);
        if (!this.mModelQuery.hasSupport(1, value)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSUPPORTED_XML_LANG", AT_EXPRESSIONLANGUAGE, value);
        }
        this.setValue(AT_EXPRESSIONLANGUAGE, value);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks the query language for support in the BPEL model", date="9/14/2006", sa=4, errors="BPELC__UNSUPPORTED_XML_LANG")
    public void rule_CheckQueryLanguage_4() {
        String value = this.mNode.getAttribute(AT_QUERYLANGUAGE);
        if (ProcessValidator.isEmpty(value)) {
            value = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
        }
        this.setValue(AT_QUERYLANGUAGE, value);
        if (!this.mModelQuery.hasSupport(0, value)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__UNSUPPORTED_XML_LANG", AT_QUERYLANGUAGE, value);
        }
    }

    @ARule(sa=0, desc="Check exitOnStandardFault attribute setting", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckExitOnStandardFault_10() {
        this.fExitStandardFault = this.getAttribute(this.mNode, AT_EXIT_ON_STANDARD_FAULT, 0, Filters.BOOLEAN_FILTER, false);
        if (ProcessValidator.isEmpty(this.fExitStandardFault)) {
            this.fExitStandardFault = "no";
        }
        this.setValue(AT_EXIT_ON_STANDARD_FAULT, this.fExitStandardFault);
    }

    @ARule(sa=0, desc="Check supressJoinFailure attribute setting", author="michal.chmielewski@oracle.com", date="01/10/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckSuppressJoinFailre_11() {
        this.fSupressJoinFailure = this.getAttribute(this.mNode, AT_SUPPRESS_JOIN_FAILURE, 0, Filters.BOOLEAN_FILTER, false);
        if (ProcessValidator.isEmpty(this.fSupressJoinFailure)) {
            this.fSupressJoinFailure = "no";
        }
        this.setValue(AT_SUPPRESS_JOIN_FAILURE, this.fSupressJoinFailure);
    }

    @ARule(sa=15, desc="Verifies that a start activity has been found in the process", author="michal.chmielewski@oracle.com", date="02/01/2007", tag="pass2", order=1000, errors="BPELC_PROCESS__NO_START")
    public void CheckIfProcessHasStartActivity() {
        if (this.fStartActivities.size() > 0) {
            return;
        }
        IProblem problem = this.createError();
        problem.fill("BPELC_PROCESS__NO_START", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME));
    }

    @ARule(sa=57, desc="Check common correlation sets on all the start activities", author="michal.chmielewski@oracle.com", date="03/10/2007", tag="pass2", order=2000, errors="BPELC_CORRELATION__COMMON,BPELC_CORRELATION__JOIN")
    public void CheckCorrelationSetsOnStartActivities() {
        if (this.fStartActivities.size() < 2) {
            return;
        }
        ArrayList commonSets = null;
        for (INode n : this.fStartActivities) {
            List correlationSets = Collections.emptyList();
            if (this.containsValueKey(n, "correlation.sets")) {
                correlationSets = this.getValue(n, "correlation.sets", null);
            }
            if (commonSets == null) {
                commonSets = new ArrayList(correlationSets);
                continue;
            }
            if (commonSets.size() <= 0) continue;
            ArrayList<INode> intersection = new ArrayList<INode>();
            for (INode i1 : commonSets) {
                for (INode i2 : correlationSets) {
                    if (!i1.equals(i2)) continue;
                    intersection.add(i2);
                }
            }
            commonSets.clear();
            commonSets.addAll(intersection);
        }
        if (commonSets == null) {
            return;
        }
        for (INode s : this.fStartActivities) {
            IProblem problem;
            INode correlationsNode = mSelector.selectNode(s, ND_CORRELATIONS);
            if (commonSets.size() == 0) {
                problem = this.createError(s);
                problem.fill("BPELC_CORRELATION__COMMON", s.nodeName(), this.fStartActivities.size());
                continue;
            }
            for (INode correlationSet : commonSets) {
                INode correlationNode;
                String name = correlationSet.getAttribute(AT_NAME);
                if (name == null || this.isUndefined(correlationNode = mSelector.selectNode(correlationsNode, ND_CORRELATION, new NodeAttributeValueFilter(AT_SET, name))) || "join".equals(correlationNode.getAttribute(AT_INITIATE))) continue;
                problem = this.createError(correlationNode);
                problem.fill("BPELC_CORRELATION__JOIN", correlationNode.nodeName(), AT_INITIATE, "join");
            }
        }
    }

    @ARule(sa=14, desc="Check if used types/elements/messages have conflicting definitions", author="michal.chmielewski@oracle.com", date="02/10/2007", tag="pass2", order=300, errors="BPELC_XSD__CONFLICTING_DEFINITION")
    public void rule_CheckReferencedTypes() {
        Process process = this.mModelQuery.lookupProcess(this.mNode);
        for (INode node : this.fTypeToCheckList) {
            List<Import> conflicts = this.mModelQuery.findConflictingXSD(process, node);
            if (conflicts == null) continue;
            String conflicting = null;
            int i = 1;
            while (i < conflicts.size()) {
                conflicting = conflicting == null ? conflicts.get(i).getLocation() : String.valueOf(conflicting) + ", " + conflicts.get(i).getLocation();
                ++i;
            }
            IProblem problem = this.createError(node);
            problem.fill("BPELC_XSD__CONFLICTING_DEFINITION", node.getAttribute(AT_NAME), conflicts.get(0).getLocation(), conflicting);
        }
    }
}

