/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeAttributeValueFilter;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class FromPartValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_FROM_PARTS);
    protected String fPartName;
    protected String fVariableName;
    protected INode fVariableNode;
    private INode fPartNode;
    protected INode fActivityNode;
    private INode fMessageType;

    @Override
    protected void start() {
        super.start();
        this.fPartName = this.mNode.getAttribute(AT_PART);
        this.fVariableName = this.mNode.getAttribute(AT_TO_VARIABLE);
        this.fActivityNode = this.fParentNode.parentNode();
        QName activityName = this.fActivityNode.nodeName();
        this.fMessageType = ND_INVOKE.equals(activityName) ? (INode)this.getValue(this.fActivityNode, "output.message.type", null) : (INode)this.getValue(this.fActivityNode, "input.message.type", null);
    }

    @ARule(desc="Check toVariable on the toPart.", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckVariable_1() {
        this.fPartName = this.getAttribute(this.mNode, AT_PART, 0, Filters.NC_NAME, true);
        this.fVariableName = this.getAttribute(this.mNode, AT_TO_VARIABLE, 1, Filters.NC_NAME, true);
    }

    @ARule(sa=0, desc="Check to see if part='' toVariable='' is a duplicate entry.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_PART__DUPLICATE")
    public void rule_CheckDuplicatePartToVariable_1() {
        if (this.fPartName == null) {
            return;
        }
        String key = "part." + this.fPartName;
        if (this.containsValueKey(this.fParentNode, key)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PART__DUPLICATE", this.toString(this.mNode.nodeName()), this.fPartName, this.fVariableName);
            return;
        }
        this.setValue(this.fParentNode, key, Boolean.TRUE);
    }

    @ARule(sa=0, desc="Checks to see if the toVariable is defined.", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE", warnings="BPELC_REF_NODE_PROBLEMS")
    public void rule_CheckVariableDefined_4() {
        if (ND_ON_EVENT.equals(this.fActivityNode.nodeName())) {
            return;
        }
        if (this.fVariableName == null) {
            return;
        }
        this.fVariableNode = this.mModelQuery.lookup(this.mNode, 1, this.fVariableName);
        if (!this.checkAttributeNode(this.mNode, this.fVariableNode, AT_TO_VARIABLE, 0)) {
            this.fVariableNode = null;
        }
        if (!this.checkValidator(this.mNode, this.fVariableNode, AT_TO_VARIABLE, 0)) {
            this.fVariableNode = null;
            return;
        }
    }

    @ARule(sa=53, desc="Check to see if the toVariable matches the type of the partName", author="michal.chmielewski@oracle.com", date="01/20/2007", errors="BPELC_PART__DUPLICATE")
    public void rule_CheckMessagePart_5() {
        if (this.fPartName == null || this.isUndefined(this.fMessageType)) {
            return;
        }
        this.fPartNode = mSelector.selectNode(this.fMessageType, WSDL_ND_PART, new NodeAttributeValueFilter(AT_NAME, this.fPartName));
        if (this.isUndefined(this.fPartNode)) {
            IProblem problem = this.createError();
            problem.fill("BPELC__PA_NO_PART", this.toString(this.mNode.nodeName()), this.fPartName, this.fMessageType.getAttribute(AT_NAME));
            return;
        }
    }

    @ARule(sa=86, desc="Variables defined in fromPart are implicitly declared in the associated scope", author="michal.chmielewski@oracle.com", date="03/15/2007")
    public void rule_ImplicitOnEventVariable_10() {
        if (!ND_ON_EVENT.equals(this.fActivityNode.nodeName())) {
            return;
        }
    }
}

