/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class EventHandlersValidator
extends CValidator {
    public static IFilter<INode> PARENTS = Filters.SCOPE_OR_PROCESS;
    int fOnEvents;
    int fOnAlarms;
    static final IFilter<INode> EVENTS = new NodeNameFilter(ND_ON_EVENT, ND_ON_ALARM);

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.fOnEvents = this.checkChild(ND_ON_EVENT, 0, Integer.MAX_VALUE);
        this.fOnAlarms = this.checkChild(ND_ON_ALARM, 0, Integer.MAX_VALUE);
    }

    @ARule(date="01/10/2007", author="michal.chmielewski@oracle.com", desc="At least one onAlarm or onEvent must be present in event handlers.", sa=83, errors="BPELC__AT_LEAST_ONE")
    public void rule_CheckHandlerCount_1() {
        int count = this.fOnAlarms + this.fOnEvents;
        if (count < 1) {
            IProblem problem = this.createError();
            problem.fill("BPELC__AT_LEAST_ONE", this.toString(this.mNode.nodeName()), 0, EVENTS, 0);
        }
    }
}

