/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.bpel.validator.model.Filter;
import org.eclipse.bpel.validator.model.IFilter;

public class ValueFilter<T>
extends Filter
implements IFilter<T> {
    T[] fList;
    Comparator<T> fComparator;

    public ValueFilter(Comparator<T> comparator, T ... values) {
        this.fList = values;
        this.fComparator = comparator;
        Arrays.sort(this.fList, this.fComparator);
    }

    @Override
    public boolean select(T node) {
        if (this.fComparator != null) {
            return Arrays.binarySearch(this.fList, node, this.fComparator) >= 0;
        }
        return Arrays.binarySearch(this.fList, node) >= 0;
    }

    @Override
    public String toString() {
        return this.toString(this.fList);
    }
}

