/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

public class XMLNameWordDetector {
    public boolean isValid(CharSequence seq) {
        if (seq.length() == 0) {
            return false;
        }
        if (!this.isWordStart(seq.charAt(0))) {
            return false;
        }
        int i = 1;
        int j = seq.length();
        while (i < j) {
            if (!this.isWordPart(seq.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isWordPart(char c) {
        return XMLNameWordDetector.isNameChar(c);
    }

    public boolean isWordStart(char c) {
        return c == '_' || XMLNameWordDetector.isLetter(c);
    }

    public static boolean isNameChar(char c) {
        return XMLNameWordDetector.isLetter(c) || XMLNameWordDetector.isDigit(c) || c == '.' || c == '-' || c == '_' || XMLNameWordDetector.isCombiningCharacter(c) || XMLNameWordDetector.isExtender(c);
    }

    public static boolean isLetter(char c) {
        return XMLNameWordDetector.isBaseChar(c) || XMLNameWordDetector.isIdeographic(c);
    }

    public static boolean isBaseChar(char c) {
        switch (XMLNameWordDetector.getPlane(c)) {
            case 0: {
                return XMLNameWordDetector.range(c, 65, 90) || XMLNameWordDetector.range(c, 97, 122) || XMLNameWordDetector.range(c, 192, 214) || XMLNameWordDetector.range(c, 216, 246) || XMLNameWordDetector.range(c, 248, 255);
            }
            case 1: {
                return XMLNameWordDetector.range(c, 256, 305) || XMLNameWordDetector.range(c, 308, 318) || XMLNameWordDetector.range(c, 321, 328) || XMLNameWordDetector.range(c, 330, 382) || XMLNameWordDetector.range(c, 384, 451) || XMLNameWordDetector.range(c, 461, 496) || XMLNameWordDetector.range(c, 500, 501) || XMLNameWordDetector.range(c, 506, 511);
            }
            case 2: {
                return XMLNameWordDetector.range(c, 512, 535) || XMLNameWordDetector.range(c, 592, 680) || XMLNameWordDetector.range(c, 699, 705);
            }
            case 3: {
                return c == '\u0386' || XMLNameWordDetector.range(c, 904, 906) || c == '\u038c' || XMLNameWordDetector.range(c, 910, 929) || XMLNameWordDetector.range(c, 931, 974) || XMLNameWordDetector.range(c, 976, 982) || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || XMLNameWordDetector.range(c, 994, 1011);
            }
            case 4: {
                return XMLNameWordDetector.range(c, 1025, 1036) || XMLNameWordDetector.range(c, 1038, 1103) || XMLNameWordDetector.range(c, 1105, 1116) || XMLNameWordDetector.range(c, 1118, 1153) || XMLNameWordDetector.range(c, 1168, 1220) || XMLNameWordDetector.range(c, 1223, 1224) || XMLNameWordDetector.range(c, 1227, 1228) || XMLNameWordDetector.range(c, 1232, 1259) || XMLNameWordDetector.range(c, 1262, 1269) || XMLNameWordDetector.range(c, 1272, 1273);
            }
            case 5: {
                return XMLNameWordDetector.range(c, 1329, 1366) || c == '\u0559' || XMLNameWordDetector.range(c, 1377, 1414) || XMLNameWordDetector.range(c, 1488, 1514) || XMLNameWordDetector.range(c, 1520, 1522);
            }
            case 6: {
                return XMLNameWordDetector.range(c, 1569, 1594) || XMLNameWordDetector.range(c, 1601, 1610) || XMLNameWordDetector.range(c, 1649, 1719) || XMLNameWordDetector.range(c, 1722, 1726) || XMLNameWordDetector.range(c, 1728, 1742) || XMLNameWordDetector.range(c, 1744, 1747) || c == '\u06d5' || XMLNameWordDetector.range(c, 1765, 1766);
            }
            case 7: 
            case 8: {
                return false;
            }
            case 9: {
                return XMLNameWordDetector.range(c, 2309, 2361) || c == '\u093d' || XMLNameWordDetector.range(c, 2392, 2401) || XMLNameWordDetector.range(c, 2437, 2444) || XMLNameWordDetector.range(c, 2447, 2448) || XMLNameWordDetector.range(c, 2451, 2472) || XMLNameWordDetector.range(c, 2474, 2480) || c == '\u09b2' || XMLNameWordDetector.range(c, 2486, 2489) || XMLNameWordDetector.range(c, 2524, 2525) || XMLNameWordDetector.range(c, 2527, 2529) || XMLNameWordDetector.range(c, 2544, 2545);
            }
            case 10: {
                return XMLNameWordDetector.range(c, 2565, 2570) || XMLNameWordDetector.range(c, 2575, 2576) || XMLNameWordDetector.range(c, 2579, 2600) || XMLNameWordDetector.range(c, 2602, 2608) || XMLNameWordDetector.range(c, 2610, 2611) || XMLNameWordDetector.range(c, 2613, 2614) || XMLNameWordDetector.range(c, 2616, 2617) || XMLNameWordDetector.range(c, 2649, 2652) || c == '\u0a5e' || XMLNameWordDetector.range(c, 2674, 2676) || XMLNameWordDetector.range(c, 2693, 2699) || c == '\u0a8d' || XMLNameWordDetector.range(c, 2703, 2705) || XMLNameWordDetector.range(c, 2707, 2728) || XMLNameWordDetector.range(c, 2730, 2736) || XMLNameWordDetector.range(c, 2738, 2739) || XMLNameWordDetector.range(c, 2741, 2745) || c == '\u0abd' || c == '\u0ae0';
            }
            case 11: {
                return XMLNameWordDetector.range(c, 2821, 2828) || XMLNameWordDetector.range(c, 2831, 2832) || XMLNameWordDetector.range(c, 2835, 2856) || XMLNameWordDetector.range(c, 2858, 2864) || XMLNameWordDetector.range(c, 2866, 2867) || XMLNameWordDetector.range(c, 2870, 2873) || c == '\u0b3d' || XMLNameWordDetector.range(c, 2908, 2909) || XMLNameWordDetector.range(c, 2911, 2913) || XMLNameWordDetector.range(c, 2949, 2954) || XMLNameWordDetector.range(c, 2958, 2960) || XMLNameWordDetector.range(c, 2962, 2965) || XMLNameWordDetector.range(c, 2969, 2970) || c == '\u0b9c' || XMLNameWordDetector.range(c, 2974, 2975) || XMLNameWordDetector.range(c, 2979, 2980) || XMLNameWordDetector.range(c, 2984, 2986) || XMLNameWordDetector.range(c, 2990, 2997) || XMLNameWordDetector.range(c, 2999, 3001);
            }
            case 12: {
                return XMLNameWordDetector.range(c, 3077, 3084) || XMLNameWordDetector.range(c, 3086, 3088) || XMLNameWordDetector.range(c, 3090, 3112) || XMLNameWordDetector.range(c, 3114, 3123) || XMLNameWordDetector.range(c, 3125, 3129) || XMLNameWordDetector.range(c, 3168, 3169) || XMLNameWordDetector.range(c, 3205, 3212) || XMLNameWordDetector.range(c, 3214, 3216) || XMLNameWordDetector.range(c, 3218, 3240) || XMLNameWordDetector.range(c, 3242, 3251) || XMLNameWordDetector.range(c, 3253, 3257) || c == '\u0cde' || XMLNameWordDetector.range(c, 3296, 3297);
            }
            case 13: {
                return XMLNameWordDetector.range(c, 3333, 3340) || XMLNameWordDetector.range(c, 3342, 3344) || XMLNameWordDetector.range(c, 3346, 3368) || XMLNameWordDetector.range(c, 3370, 3385) || XMLNameWordDetector.range(c, 3424, 3425);
            }
            case 14: {
                return XMLNameWordDetector.range(c, 3585, 3630) || c == '\u0e30' || XMLNameWordDetector.range(c, 3634, 3635) || XMLNameWordDetector.range(c, 3648, 3653) || XMLNameWordDetector.range(c, 3713, 3714) || c == '\u0e84' || XMLNameWordDetector.range(c, 3719, 3720) || c == '\u0e8a' || c == '\u0e8d' || XMLNameWordDetector.range(c, 3732, 3735) || XMLNameWordDetector.range(c, 3737, 3743) || XMLNameWordDetector.range(c, 3745, 3747) || c == '\u0ea5' || c == '\u0ea7' || XMLNameWordDetector.range(c, 3754, 3755) || XMLNameWordDetector.range(c, 3757, 3758) || c == '\u0eb0' || XMLNameWordDetector.range(c, 3762, 3763) || c == '\u0ebd' || XMLNameWordDetector.range(c, 3776, 3780);
            }
            case 15: {
                return XMLNameWordDetector.range(c, 3904, 3911) || XMLNameWordDetector.range(c, 3913, 3945);
            }
            case 16: {
                return XMLNameWordDetector.range(c, 3904, 3911) || XMLNameWordDetector.range(c, 3913, 3945);
            }
            case 17: {
                return c == '\u1100' || XMLNameWordDetector.range(c, 4354, 4355) || XMLNameWordDetector.range(c, 4357, 4359) || c == '\u1109' || XMLNameWordDetector.range(c, 4363, 4364) || XMLNameWordDetector.range(c, 4366, 4370) || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || XMLNameWordDetector.range(c, 4436, 4437) || c == '\u1159' || XMLNameWordDetector.range(c, 4447, 4449) || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || XMLNameWordDetector.range(c, 4461, 4462) || XMLNameWordDetector.range(c, 4466, 4467) || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || XMLNameWordDetector.range(c, 4526, 4527) || XMLNameWordDetector.range(c, 4535, 4536) || c == '\u11ba' || XMLNameWordDetector.range(c, 4540, 4546) || c == '\u11eb' || c == '\u11f0' || c == '\u11f9';
            }
            case 30: {
                return XMLNameWordDetector.range(c, 7680, 7835) || XMLNameWordDetector.range(c, 7840, 7929);
            }
            case 31: {
                return XMLNameWordDetector.range(c, 7936, 7957) || XMLNameWordDetector.range(c, 7960, 7965) || XMLNameWordDetector.range(c, 7968, 8005) || XMLNameWordDetector.range(c, 8008, 8013) || XMLNameWordDetector.range(c, 8016, 8023) || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || XMLNameWordDetector.range(c, 8031, 8061) || XMLNameWordDetector.range(c, 8064, 8116) || XMLNameWordDetector.range(c, 8118, 8124) || c == '\u1fbe' || XMLNameWordDetector.range(c, 8130, 8132) || XMLNameWordDetector.range(c, 8134, 8140) || XMLNameWordDetector.range(c, 8144, 8147) || XMLNameWordDetector.range(c, 8150, 8155) || XMLNameWordDetector.range(c, 8160, 8172) || XMLNameWordDetector.range(c, 8178, 8180) || XMLNameWordDetector.range(c, 8182, 8188);
            }
            case 33: {
                return c == '\u2126' || XMLNameWordDetector.range(c, 8490, 8491) || c == '\u212e' || XMLNameWordDetector.range(c, 8576, 8578);
            }
            case 48: {
                return XMLNameWordDetector.range(c, 12353, 12436) || XMLNameWordDetector.range(c, 12449, 12538);
            }
            case 49: {
                return XMLNameWordDetector.range(c, 12549, 12588);
            }
        }
        return XMLNameWordDetector.range(c, 44032, 55203);
    }

    public static boolean isCombiningCharacter(char c) {
        switch (XMLNameWordDetector.getPlane(c)) {
            case 3: {
                return XMLNameWordDetector.range(c, 768, 837) || XMLNameWordDetector.range(c, 864, 865);
            }
            case 4: {
                return XMLNameWordDetector.range(c, 1155, 1158);
            }
            case 5: {
                return XMLNameWordDetector.range(c, 1425, 1441) || XMLNameWordDetector.range(c, 1443, 1465) || XMLNameWordDetector.range(c, 1467, 1469) || c == '\u05bf' || XMLNameWordDetector.range(c, 1473, 1474) || c == '\u05c4';
            }
            case 6: {
                return XMLNameWordDetector.range(c, 1611, 1618) || c == '\u0670' || XMLNameWordDetector.range(c, 1750, 1756) || XMLNameWordDetector.range(c, 1757, 1759) || XMLNameWordDetector.range(c, 1760, 1764) || XMLNameWordDetector.range(c, 1767, 1768) || XMLNameWordDetector.range(c, 1770, 1773);
            }
            case 9: {
                return XMLNameWordDetector.range(c, 2305, 2307) || c == '\u093c' || XMLNameWordDetector.range(c, 2366, 2380) || c == '\u094d' || XMLNameWordDetector.range(c, 2385, 2388) || XMLNameWordDetector.range(c, 2402, 2403) || XMLNameWordDetector.range(c, 2433, 2435) || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || XMLNameWordDetector.range(c, 2496, 2500) || XMLNameWordDetector.range(c, 2503, 2504) || XMLNameWordDetector.range(c, 2507, 2509) || c == '\u09d7' || XMLNameWordDetector.range(c, 2530, 2531);
            }
            case 10: {
                return c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || XMLNameWordDetector.range(c, 2624, 2626) || XMLNameWordDetector.range(c, 2631, 2632) || XMLNameWordDetector.range(c, 2635, 2637) || XMLNameWordDetector.range(c, 2672, 2673) || XMLNameWordDetector.range(c, 2689, 2691) || c == '\u0abc' || XMLNameWordDetector.range(c, 2750, 2757) || XMLNameWordDetector.range(c, 2759, 2761) || XMLNameWordDetector.range(c, 2763, 2765);
            }
            case 11: {
                return XMLNameWordDetector.range(c, 2817, 2819) || c == '\u0b3c' || XMLNameWordDetector.range(c, 2878, 2883) || XMLNameWordDetector.range(c, 2887, 2888) || XMLNameWordDetector.range(c, 2891, 2893) || XMLNameWordDetector.range(c, 2902, 2903) || XMLNameWordDetector.range(c, 2946, 2947) || XMLNameWordDetector.range(c, 3006, 3010) || XMLNameWordDetector.range(c, 3014, 3016) || XMLNameWordDetector.range(c, 3018, 3021) || c == '\u0bd7';
            }
            case 12: {
                return XMLNameWordDetector.range(c, 3073, 3075) || XMLNameWordDetector.range(c, 3134, 3140) || XMLNameWordDetector.range(c, 3142, 3144) || XMLNameWordDetector.range(c, 3146, 3149) || XMLNameWordDetector.range(c, 3157, 3158) || XMLNameWordDetector.range(c, 3202, 3203) || XMLNameWordDetector.range(c, 3262, 3268) || XMLNameWordDetector.range(c, 3270, 3272) || XMLNameWordDetector.range(c, 3274, 3277) || XMLNameWordDetector.range(c, 3285, 3286);
            }
            case 13: {
                return XMLNameWordDetector.range(c, 3330, 3331) || XMLNameWordDetector.range(c, 3390, 3395) || XMLNameWordDetector.range(c, 3398, 3400) || XMLNameWordDetector.range(c, 3402, 3405) || c == '\u0d57';
            }
            case 14: {
                return c == '\u0e31' || XMLNameWordDetector.range(c, 3636, 3642) || XMLNameWordDetector.range(c, 3655, 3662) || c == '\u0eb1' || XMLNameWordDetector.range(c, 3764, 3769) || XMLNameWordDetector.range(c, 3771, 3772) || XMLNameWordDetector.range(c, 3784, 3789);
            }
            case 15: {
                return XMLNameWordDetector.range(c, 3864, 3865) || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || XMLNameWordDetector.range(c, 3953, 3972) || XMLNameWordDetector.range(c, 3974, 3979) || XMLNameWordDetector.range(c, 3984, 3989) || c == '\u0f97' || XMLNameWordDetector.range(c, 3993, 4013) || XMLNameWordDetector.range(c, 4017, 4023) || c == '\u0fb9';
            }
            case 32: {
                return XMLNameWordDetector.range(c, 8400, 8412) || c == '\u20e1';
            }
            case 48: {
                return XMLNameWordDetector.range(c, 12330, 12335) || c == '\u3099' || c == '\u309a';
            }
        }
        return false;
    }

    public static boolean isIdeographic(char c) {
        return XMLNameWordDetector.range(c, 19968, 40869) || c == '\u3007' || XMLNameWordDetector.range(c, 12321, 12329);
    }

    public static boolean isDigit(char c) {
        switch (XMLNameWordDetector.getPlane(c)) {
            case 0: {
                return XMLNameWordDetector.range(c, 48, 57);
            }
            case 6: {
                return XMLNameWordDetector.range(c, 1632, 1641) || XMLNameWordDetector.range(c, 1776, 1785);
            }
            case 9: {
                return XMLNameWordDetector.range(c, 2406, 2415) || XMLNameWordDetector.range(c, 2534, 2543);
            }
            case 10: {
                return XMLNameWordDetector.range(c, 2662, 2671) || XMLNameWordDetector.range(c, 2790, 2799);
            }
            case 11: {
                return XMLNameWordDetector.range(c, 2918, 2927) || XMLNameWordDetector.range(c, 3047, 3055);
            }
            case 12: {
                return XMLNameWordDetector.range(c, 3174, 3183) || XMLNameWordDetector.range(c, 3302, 3311);
            }
            case 13: {
                return XMLNameWordDetector.range(c, 3430, 3439);
            }
            case 14: {
                return XMLNameWordDetector.range(c, 3664, 3673) || XMLNameWordDetector.range(c, 3792, 3801);
            }
            case 15: {
                return XMLNameWordDetector.range(c, 3872, 3881);
            }
        }
        return false;
    }

    public static boolean isExtender(char c) {
        boolean res;
        boolean bl = res = c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005';
        if (res) {
            return res;
        }
        return XMLNameWordDetector.range(c, 12337, 12341) || XMLNameWordDetector.range(c, 12445, 12446) || XMLNameWordDetector.range(c, 12540, 12542);
    }

    public static int getPlane(int c) {
        return c >>> 16;
    }

    public static boolean range(char c, int l, int h) {
        return c >= l && c <= h;
    }
}

