/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypeFactory;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypePackage;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.details.providers.AddSelectedObjectFilter;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.OperationsTreeContentProvider;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.BrowseUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class PartnerLinkImplSection
extends BPELPropertySection {
    private static final int BID_MY_ROLE_1 = 1;
    private static final int BID_MY_ROLE_2 = 2;
    private static final int BID_MY_ROLE_NONE = 3;
    private static final int BID_PARTNER_ROLE_1 = 101;
    private static final int BID_PARTNER_ROLE_2 = 102;
    private static final int BID_PARTNER_ROLE_NONE = 103;
    private static final int BID_INITIALIZE_PARTNER_ROLE = 201;
    private static final Role[] NO_ROLES = new Role[0];
    protected boolean inUpdate = false;
    protected Composite interfaceComposite;
    protected Composite referenceComposite;
    protected Composite parentComposite;
    protected Button interfaceBrowseButton;
    protected AddSelectedObjectFilter interfaceAddSelectedObjectFilter;
    protected CComboViewer referenceViewer;
    protected Button referenceBrowseButton;
    protected AddSelectedObjectFilter referenceAddSelectedObjectFilter;
    protected int lastChangeContext = -1;
    private Button partnerLinkTypeBrowseButton;
    private Button fMyRole1;
    private Button fMyRole2;
    private Button fMyRoleNone;
    private Button fPartnerRole1;
    private Button fPartnerRole2;
    private Button fPartnerRoleNone;
    private Role[] fRoles;
    private TreeViewer fMyOperationsTreeViewer;
    private TreeViewer fPartnerOperationsTreeViewer;
    private Hyperlink fPartnerLinkTypeHref;
    private StatusLabel2 fPartnerLinkTypeLabel;
    private Button fInitializePartnerRole;
    static Set<EStructuralFeature> notificationInterest = new HashSet<EStructuralFeature>();

    static {
        notificationInterest.add((EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerLinkType());
        notificationInterest.add((EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_MyRole());
        notificationInterest.add((EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerRole());
        notificationInterest.add((EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_InitializePartnerRole());
        notificationInterest.add((EStructuralFeature)PartnerlinktypePackage.eINSTANCE.getPartnerLinkType_Role());
        notificationInterest.add((EStructuralFeature)PartnerlinktypePackage.eINSTANCE.getRole_PortType());
        notificationInterest.add((EStructuralFeature)PartnerlinktypePackage.eINSTANCE.getRole_Name());
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new BatchedMultiObjectAdapter(){
            boolean updateInterface = false;
            boolean refreshAdapters = false;

            @Override
            public void notify(Notification n) {
                this.updateInterface = this.updateInterface || notificationInterest.contains(n.getFeature());
                this.refreshAdapters = this.refreshAdapters || this.updateInterface;
            }

            @Override
            public void finish() {
                if (this.updateInterface) {
                    PartnerLinkImplSection.this.updatePartnerLinkTypeWidgets();
                    PartnerLinkImplSection.this.doChildLayout();
                    this.updateInterface = false;
                }
                if (this.refreshAdapters) {
                    PartnerLinkImplSection.this.refreshAdapters();
                    this.refreshAdapters = false;
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        if (this.fAdapters.length > 0) {
            PartnerLink partnerLink = (PartnerLink)this.getInput();
            if (partnerLink.getPartnerLinkType() != null) {
                this.fAdapters[0].addToObject((Notifier)partnerLink.getPartnerLinkType());
            }
            Role[] roles = new Role[]{partnerLink.getMyRole(), partnerLink.getPartnerRole()};
            int i = 0;
            while (i < roles.length) {
                Role role = roles[i];
                if (role != null) {
                    this.fAdapters[0].addToObject((Notifier)role);
                }
                ++i;
            }
        }
    }

    protected Composite createPartnerLinkTypeWidgets(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 6) : new FlatFormAttachment((Control)top, 6);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        composite.setLayoutData((Object)data);
        this.partnerLinkTypeBrowseButton = this.fWidgetFactory.createButton(composite, Messages.PartnerLinkImplSection_Browse_1, 8);
        DecoratedLabel label = new DecoratedLabel(composite, 16384);
        label.setText(Messages.PartnerLinkImplSection_0);
        this.fWidgetFactory.adapt((Composite)label);
        this.fPartnerLinkTypeLabel = new StatusLabel2(label);
        this.fPartnerLinkTypeHref = this.fWidgetFactory.createHyperlink(composite, "", 0);
        this.fPartnerLinkTypeHref.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PartnerLinkType plt = PartnerLinkImplSection.this.getPartnerLinkType();
                if (plt == null) {
                    return;
                }
                BPELUtil.openEditor((EObject)PartnerLinkImplSection.this.getPartnerLinkType(), PartnerLinkImplSection.this.getBPELEditor());
            }
        });
        this.fPartnerLinkTypeHref.setToolTipText(Messages.PartnerLinkImplSection_1);
        this.partnerLinkTypeBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PartnerLinkImplSection.this.browseForPartnerLink();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 4);
        data.right = new FlatFormAttachment(100, -5);
        this.partnerLinkTypeBrowseButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment(0, 4);
        this.fPartnerLinkTypeLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.right = new FlatFormAttachment(60, 0);
        data.left = new FlatFormAttachment((Control)this.fPartnerLinkTypeLabel.getLabel(), 20);
        data.bottom = new FlatFormAttachment((Control)this.fPartnerLinkTypeLabel.getLabel(), -1, 1024);
        this.fPartnerLinkTypeHref.setLayoutData((Object)data);
        return composite;
    }

    protected void browseForPartnerLink() {
        Object obj = BrowseUtil.browseForPartnerLinkType(this.getInput(), this.partnerLinkTypeBrowseButton.getShell());
        if (obj == null) {
            return;
        }
        if (obj instanceof PartnerLinkType) {
            this.setPartnerLinkType((PartnerLinkType)obj);
        }
    }

    protected Composite createMyRolePartnerRoleWidgets(Composite top, Composite parent) {
        Composite composite = this.fWidgetFactory.createComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 5) : new FlatFormAttachment((Control)top, 5);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Group myGroup = this.fWidgetFactory.createGroup(composite, Messages.PartnerLinkImplSection_2);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        myGroup.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalIndent = 10;
        gridData.minimumWidth = 150;
        myGroup.setLayoutData((Object)gridData);
        this.fMyRole1 = this.createButton((Composite)myGroup, null, 1, false, 16);
        this.fMyRole2 = this.createButton((Composite)myGroup, null, 2, false, 16);
        this.fMyRoleNone = this.createButton((Composite)myGroup, Messages.PartnerLinkImplSection_10, 3, true, 16);
        this.updateRadio(this.fMyRole1, null);
        this.updateRadio(this.fMyRole2, null);
        Group partnerGroup = this.fWidgetFactory.createGroup(composite, Messages.PartnerLinkImplSection_4);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        partnerGroup.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalIndent = 10;
        gridData.minimumWidth = 150;
        partnerGroup.setLayoutData((Object)gridData);
        this.fPartnerRole1 = this.createButton((Composite)partnerGroup, null, 101, false, 16);
        this.fPartnerRole2 = this.createButton((Composite)partnerGroup, null, 102, false, 16);
        this.fPartnerRoleNone = this.createButton((Composite)partnerGroup, Messages.PartnerLinkImplSection_5, 103, true, 16);
        this.fInitializePartnerRole = this.createButton((Composite)partnerGroup, Messages.PartnerLinkImplSection_11, 201, false, 32);
        this.updateRadio(this.fPartnerRole1, null);
        this.updateRadio(this.fPartnerRole2, null);
        return composite;
    }

    protected Composite createRoleWidgets(Composite top, Composite parent) {
        return this.createMyRolePartnerRoleWidgets(top, parent);
    }

    protected Composite createPartnerLinkStructureWidgets(Composite top, Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 5) : new FlatFormAttachment((Control)top, 5);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        composite.setLayoutData((Object)data);
        Label treeLabel = this.fWidgetFactory.createLabel(composite, Messages.PartnerLinkImplSection_6);
        Tree tree = this.fWidgetFactory.createTree(composite, 0);
        this.fMyOperationsTreeViewer = new TreeViewer(tree);
        this.fMyOperationsTreeViewer.setContentProvider((IContentProvider)new OperationsTreeContentProvider(true));
        this.fMyOperationsTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fMyOperationsTreeViewer.setInput(null);
        this.fMyOperationsTreeViewer.setAutoExpandLevel(4);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 15);
        data.top = new FlatFormAttachment((Control)treeLabel, 4, 1024);
        treeLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 15);
        data.top = new FlatFormAttachment((Control)treeLabel, 5, 1024);
        data.right = new FlatFormAttachment(50, -5);
        data.bottom = new FlatFormAttachment(100, -5);
        tree.setLayoutData((Object)data);
        treeLabel = this.fWidgetFactory.createLabel(composite, Messages.PartnerLinkImplSection_7);
        tree = this.fWidgetFactory.createTree(composite, 0);
        this.fPartnerOperationsTreeViewer = new TreeViewer(tree);
        this.fPartnerOperationsTreeViewer.setContentProvider((IContentProvider)new OperationsTreeContentProvider(true));
        this.fPartnerOperationsTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fPartnerOperationsTreeViewer.setInput(null);
        this.fPartnerOperationsTreeViewer.setAutoExpandLevel(4);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(50, 15);
        data.top = new FlatFormAttachment((Control)treeLabel, 4, 1024);
        treeLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(50, 15);
        data.top = new FlatFormAttachment((Control)treeLabel, 5, 1024);
        data.right = new FlatFormAttachment(100, -5);
        data.bottom = new FlatFormAttachment(100, -5);
        tree.setLayoutData((Object)data);
        return null;
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        Composite ref = this.createPartnerLinkTypeWidgets(null, composite);
        ref = this.createRoleWidgets(ref, composite);
        this.createPartnerLinkStructureWidgets(ref, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_partner_link");
    }

    protected void doChildLayout() {
        this.parentComposite.layout(true, true);
    }

    protected void updateMyRolePartnerRoleWidgets(PartnerLink pl) {
        PartnerLinkType plt = pl.getPartnerLinkType();
        this.fRoles = NO_ROLES;
        if (plt != null) {
            this.fRoles = (Role[])plt.getRole().toArray((Object[])NO_ROLES);
        }
        Role myRole = pl.getMyRole();
        Role partnerRole = pl.getPartnerRole();
        this.updateRadio(this.fMyRole1, null);
        this.updateRadio(this.fMyRole2, null);
        this.updateRadio(this.fPartnerRole1, null);
        this.updateRadio(this.fPartnerRole2, null);
        this.select(this.fPartnerRoleNone);
        this.select(this.fMyRoleNone);
        this.select(this.fInitializePartnerRole);
        if (this.fRoles.length >= 1) {
            String role1 = this.fRoles[0].getName();
            this.updateRadio(this.fMyRole1, role1);
            this.updateRadio(this.fPartnerRole1, role1);
            if (this.fRoles[0].equals(myRole)) {
                this.select(this.fMyRole1);
            }
            if (this.fRoles[0].equals(partnerRole)) {
                this.select(this.fPartnerRole1);
            }
        }
        Boolean ipr = pl.getInitializePartnerRole();
        if (this.fRoles.length >= 2) {
            String role2 = this.fRoles[1].getName();
            this.updateRadio(this.fMyRole2, role2);
            this.updateRadio(this.fPartnerRole2, role2);
            if (this.fRoles[1].equals(myRole)) {
                this.select(this.fMyRole2);
            }
            if (this.fRoles[1].equals(partnerRole)) {
                this.select(this.fPartnerRole2);
            }
            this.fInitializePartnerRole.setEnabled(true);
            this.fInitializePartnerRole.setSelection(ipr != null && ipr != false);
        } else {
            this.fInitializePartnerRole.setSelection(false);
            this.fInitializePartnerRole.setEnabled(false);
        }
    }

    protected void updatePartnerLinkType(PartnerLink pl) {
        PartnerLinkType plt = pl.getPartnerLinkType();
        if (plt == null) {
            this.fPartnerLinkTypeHref.setText(Messages.PartnerLinkImplSection_8);
            this.fPartnerLinkTypeHref.setEnabled(false);
            return;
        }
        String name = null;
        ILabeledElement label = BPELUtil.adapt((Object)plt, ILabeledElement.class);
        if (label != null) {
            name = label.getLabel(plt);
        }
        this.fPartnerLinkTypeHref.setText(name);
        this.fPartnerLinkTypeHref.setEnabled(true);
    }

    protected void updatePartnerLinkTypeWidgets() {
        Object obj = this.getInput();
        if (obj == null) {
            throw new IllegalStateException();
        }
        PartnerLink pl = (PartnerLink)obj;
        this.updateMyRolePartnerRoleWidgets(pl);
        this.updatePartnerLinkType(pl);
        this.fMyOperationsTreeViewer.setInput((Object)ModelHelper.getPartnerPortType(pl, 1));
        this.fPartnerOperationsTreeViewer.setInput((Object)ModelHelper.getPartnerPortType(pl, 0));
        this.updateMarkers();
    }

    protected PartnerLinkType getPartnerLinkType() {
        PartnerLink pl = (PartnerLink)this.fModelObject;
        return pl.getPartnerLinkType();
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.updatePartnerLinkTypeWidgets();
        this.doChildLayout();
    }

    @Override
    public Object getUserContext() {
        return this.lastChangeContext;
    }

    @Override
    public void restoreUserContext(Object userContext) {
    }

    public void storeInterface(final PortType portType, final int whichRole) {
        final PartnerLink partnerLink = (PartnerLink)this.getInput();
        CompoundCommand cmd = new CompoundCommand();
        PartnerLinkType plt = partnerLink.getPartnerLinkType();
        if ((plt == null || plt.eIsProxy()) && portType != null) {
            plt = PartnerlinktypeFactory.eINSTANCE.createPartnerLinkType();
            Definition artifactsDefinition = this.getBPELEditor().getArtifactsDefinition();
            cmd.add((Command)ModelHelper.getCreatePartnerLinkTypeCommand(this.getProcess(), partnerLink, plt, artifactsDefinition, whichRole));
        }
        if (plt != null) {
            cmd.add((Command)new AutoUndoCommand((EObject)plt){

                @Override
                public void doExecute() {
                    Role role = whichRole == 0 ? partnerLink.getMyRole() : partnerLink.getPartnerRole();
                    role.setPortType((Object)portType);
                }
            });
        }
        if (!cmd.isEmpty()) {
            this.getCommandFramework().execute(this.wrapInShowContextCommand((Command)cmd));
        }
    }

    Button createButton(Composite parent, String label, int id, boolean checked, int type) {
        Button button = this.fWidgetFactory.createButton(parent, label, type);
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                PartnerLinkImplSection.this.buttonPressed((Integer)b.getData(), b.getSelection(), true);
            }
        });
        return button;
    }

    void updateRadio(Button button, String text) {
        if (text == null) {
            button.setText(Messages.PartnerLinkImplSection_9);
            button.setEnabled(false);
            button.setSelection(false);
        } else {
            button.setText(text);
            button.setEnabled(true);
        }
    }

    void select(Button button) {
        if ((button.getStyle() & 0x10) == 16) {
            Control[] controlArray = button.getParent().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button b;
                Control child = controlArray[n2];
                if (button != child && child instanceof Button && ((b = (Button)child).getStyle() & 0x10) == 16) {
                    this.unselect(b);
                }
                ++n2;
            }
        }
        button.setSelection(true);
        int id = (Integer)button.getData();
        this.buttonPressed(id, true, false);
    }

    void unselect(Button button) {
        if (button.getSelection()) {
            button.setSelection(false);
            int id = (Integer)button.getData();
            this.buttonPressed(id, false, false);
        }
    }

    protected void buttonPressed(int id, boolean selection, boolean event) {
        if (!event || !selection && id != 201) {
            return;
        }
        PartnerLink pl = (PartnerLink)this.getInput();
        SetCommand cmd = null;
        Role myRole = pl.getMyRole();
        Role partnerRole = pl.getPartnerRole();
        switch (id) {
            case 1: {
                if (myRole != null && myRole.equals(this.fRoles[0])) break;
                cmd = new SetCommand((EObject)pl, this.fRoles[0], (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_MyRole());
                break;
            }
            case 2: {
                if (myRole != null && myRole.equals(this.fRoles[1])) break;
                cmd = new SetCommand((EObject)pl, this.fRoles[1], (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_MyRole());
                break;
            }
            case 3: {
                if (myRole == null) break;
                cmd = new SetCommand((EObject)pl, null, (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_MyRole());
                break;
            }
            case 101: {
                if (partnerRole != null && partnerRole.equals(this.fRoles[0])) break;
                cmd = new SetCommand((EObject)pl, this.fRoles[0], (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerRole());
                break;
            }
            case 102: {
                if (partnerRole != null && partnerRole.equals(this.fRoles[1])) break;
                cmd = new SetCommand((EObject)pl, this.fRoles[1], (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerRole());
                break;
            }
            case 103: {
                if (partnerRole == null) break;
                cmd = new SetCommand((EObject)pl, null, (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerRole());
                break;
            }
            case 201: {
                cmd = new SetCommand((EObject)pl, this.fInitializePartnerRole.getSelection(), (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_InitializePartnerRole());
            }
        }
        if (cmd != null) {
            this.getCommandFramework().execute(cmd);
        }
    }

    private void setPartnerLinkType(PartnerLinkType type) {
        PartnerLink pl = (PartnerLink)this.getInput();
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new SetCommand((EObject)pl, type, (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerLinkType()));
        cmd.add((Command)new SetCommand((EObject)pl, null, (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_MyRole()));
        cmd.add((Command)new SetCommand((EObject)pl, null, (EStructuralFeature)BPELPackage.eINSTANCE.getPartnerLink_PartnerRole()));
        this.getCommandFramework().execute((Command)cmd);
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        boolean isValid = super.isValidMarker(marker);
        if (!isValid) {
            return false;
        }
        String context = null;
        try {
            context = (String)marker.getAttribute("href.context");
        }
        catch (Exception exception) {
            return false;
        }
        return !"name".equals(context);
    }

    @Override
    protected void updateMarkers() {
        this.fPartnerLinkTypeLabel.clear();
        IMarker[] iMarkerArray = this.getMarkers(this.getInput());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            this.fPartnerLinkTypeLabel.addStatus(BPELUtil.adapt((Object)m, IStatus.class));
            ++n2;
        }
    }
}

