/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddImportCommand;
import org.eclipse.bpel.ui.commands.RemoveImportCommand;
import org.eclipse.bpel.ui.details.providers.ColumnTableProvider;
import org.eclipse.bpel.ui.details.providers.ImportContentProvider;
import org.eclipse.bpel.ui.dialogs.SchemaImportDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.bpel.ui.util.TableCursor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ImportsSection
extends BPELPropertySection {
    protected Composite parentComposite;
    protected Composite activityComposite;
    protected Label importLabel;
    protected Table importTable;
    protected TableViewer importViewer;
    protected ColumnTableProvider tableProvider;
    protected TableCursor tableCursor = null;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void addAllAdapters() {
        Object obj;
        super.addAllAdapters();
        if (this.fAdapters.length > 0 && this.getModel() != null && (obj = this.getModel()) instanceof Process) {
            EList list = ((Process)obj).getImports();
            int i = 0;
            while (i < list.size()) {
                this.fAdapters[0].addToObject((Notifier)((Import)list.get(i)));
                ++i;
            }
        }
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                ImportsSection.this.importViewer.setInput(ImportsSection.this.getInput());
            }
        }};
    }

    protected void createImportWidgets(Composite parent) {
        Button browseWSDL = this.fWidgetFactory.createButton(parent, Messages.ImportsSection_0, 8);
        Button browseXSD = this.fWidgetFactory.createButton(parent, Messages.ImportsSection_1, 8);
        final Button removeImport = this.fWidgetFactory.createButton(parent, Messages.ImportsSection_2, 8);
        removeImport.setEnabled(false);
        removeImport.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportsSection.this.removeImport();
            }
        });
        browseWSDL.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportsSection.this.browseAndImportWSDL();
            }
        });
        browseXSD.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportsSection.this.browseAndImportXSD();
            }
        });
        FlatFormData data = new FlatFormData();
        data.right = new FlatFormAttachment(100, -25);
        data.top = new FlatFormAttachment(0, 4);
        removeImport.setLayoutData((Object)data);
        data = new FlatFormData();
        data.right = new FlatFormAttachment((Control)removeImport, -5);
        data.top = new FlatFormAttachment(0, 4);
        browseXSD.setLayoutData((Object)data);
        data = new FlatFormData();
        data.right = new FlatFormAttachment((Control)browseXSD, -5);
        data.top = new FlatFormAttachment(0, 4);
        browseWSDL.setLayoutData((Object)data);
        this.importLabel = this.fWidgetFactory.createLabel(parent, Messages.ImportDetails_Imports_20);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment((Control)browseWSDL, 4);
        this.importLabel.setLayoutData((Object)data);
        this.importTable = this.fWidgetFactory.createTable(parent, 66056);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(100, -25);
        data.top = new FlatFormAttachment((Control)this.importLabel, 4);
        data.bottom = new FlatFormAttachment(100, -5);
        this.importTable.setLayoutData((Object)data);
        this.importTable.setLinesVisible(true);
        this.importTable.setHeaderVisible(true);
        this.tableProvider = new ColumnTableProvider();
        this.tableProvider.add(new LocationColumn());
        this.tableProvider.add(new NamespaceColumn());
        this.tableProvider.add(new ImportTypeColumn());
        this.importViewer = new TableViewer(this.importTable);
        this.tableProvider.createTableLayout(this.importTable);
        this.importViewer.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.importViewer.setCellModifier((ICellModifier)this.tableProvider);
        this.importViewer.setContentProvider((IContentProvider)new ImportContentProvider());
        this.importViewer.setColumnProperties(this.tableProvider.getColumnProperties());
        this.importViewer.setCellEditors(this.tableProvider.createCellEditors((Composite)this.importTable));
        this.importViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeImport.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.tableCursor = BPELUtil.createTableCursor(this.importTable, this.importViewer);
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        if (this.getInput() != null) {
            this.importViewer.setInput(this.getInput());
        }
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        this.createImportWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_imports");
    }

    @Override
    public Object getUserContext() {
        return ((StructuredSelection)this.importViewer.getSelection()).getFirstElement();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.importTable.setFocus();
        if (userContext != null) {
            this.importViewer.setSelection((ISelection)new StructuredSelection(userContext));
        }
    }

    void removeImport() {
        ISelection selection = this.importViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IStructuredSelection ssel = null;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ssel = (IStructuredSelection)selection;
        Object obj = ssel.getFirstElement();
        RemoveImportCommand cmd = new RemoveImportCommand((EObject)BPELUtils.getProcess(this.getInput()), obj, IBPELUIConstants.CMD_REMOVE_IMPORT);
        if (cmd.canDoExecute()) {
            this.getCommandFramework().execute((Command)cmd);
        }
    }

    void browseAndImportWSDL() {
        SchemaImportDialog dialog = new SchemaImportDialog(this.importLabel.getShell(), (EObject)this.getInput());
        dialog.configureAsWSDLImport();
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result.length < 1) {
            return;
        }
        AddImportCommand cmd = new AddImportCommand(BPELUtils.getProcess(this.getInput()), result[0]);
        if (cmd.canDoExecute() && !cmd.wouldCreateDuplicateImport()) {
            this.getCommandFramework().execute((Command)cmd);
        }
    }

    void browseAndImportXSD() {
        SchemaImportDialog dialog = new SchemaImportDialog(this.importLabel.getShell(), (EObject)this.getInput());
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result.length < 1) {
            return;
        }
        AddImportCommand cmd = new AddImportCommand(BPELUtils.getProcess(this.getInput()), result[0]);
        if (cmd.canDoExecute() && !cmd.wouldCreateDuplicateImport()) {
            this.getCommandFramework().execute((Command)cmd);
        }
    }

    @Override
    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        return super.isValidMarker(marker);
    }

    public class ImportTypeColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.ImportsSection_3;
        }

        @Override
        public String getProperty() {
            return "ImportType";
        }

        @Override
        public int getInitialWeight() {
            return 30;
        }

        public String getText(Object element) {
            String s = ((Import)element).getImportType();
            return s == null ? "" : s;
        }
    }

    public class LocationColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.ImportDetails_Import_Location_12;
        }

        @Override
        public String getProperty() {
            return "Location";
        }

        @Override
        public int getInitialWeight() {
            return 30;
        }

        public String getText(Object element) {
            String s = ((Import)element).getLocation();
            return s == null ? "" : s;
        }
    }

    public class NamespaceColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        @Override
        public String getHeaderText() {
            return Messages.ImportDetails_Import_Namespace_12;
        }

        @Override
        public String getProperty() {
            return "Namespace";
        }

        @Override
        public int getInitialWeight() {
            return 30;
        }

        public String getText(Object element) {
            String s = ((Import)element).getNamespace();
            return s == null ? "" : NamespaceUtils.convertUriToNamespace(s);
        }
    }
}

