/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import org.eclipse.bpel.ui.figures.ConnectionCoordHistory;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class CenteredConnectionAnchor
extends AbstractConnectionAnchor {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int TOP_INNER = 4;
    public static final int BOTTOM_INNER = 5;
    public static final int LEFT_INNER = 6;
    public static final int RIGHT_INNER = 7;
    private int location;
    private int inset;
    private int offset = 0;

    public CenteredConnectionAnchor(IFigure owner, int location, int inset) {
        super(owner);
        this.location = location;
        this.inset = inset;
    }

    public CenteredConnectionAnchor(IFigure owner, int location, int inset, int offset) {
        this(owner, location, inset);
        this.offset = offset;
    }

    public Point getLocation(Point reference) {
        int y;
        int x;
        Rectangle r = this.getOwner().getBounds().getCopy();
        switch (this.location) {
            case 0: {
                x = r.right() - r.width / 2 + this.offset - 1;
                y = r.y + this.inset;
                x = ConnectionCoordHistory.getInstance().adjustX(x);
                break;
            }
            case 1: {
                x = r.right() - r.width / 2 + this.offset - 1;
                y = r.bottom() - this.inset;
                x = ConnectionCoordHistory.getInstance().adjustX(x);
                break;
            }
            case 2: {
                x = r.x + this.inset;
                y = r.bottom() - r.height / 2 + this.offset;
                y = ConnectionCoordHistory.getInstance().adjustY(y);
                break;
            }
            case 3: {
                x = r.right() - this.inset;
                y = r.bottom() - r.height / 2 + this.offset;
                y = ConnectionCoordHistory.getInstance().adjustY(y);
                break;
            }
            case 4: {
                x = r.right() - r.width / 2 + this.offset - 1;
                y = r.y + this.inset;
                x = ConnectionCoordHistory.getInstance().adjustX(x);
                break;
            }
            case 5: {
                x = r.right() - r.width / 2 + this.offset - 1;
                y = r.bottom() - 11 - this.inset;
                x = ConnectionCoordHistory.getInstance().adjustX(x);
                break;
            }
            case 6: {
                x = r.x + this.inset + 16;
                y = r.bottom() - r.height / 2 + this.offset;
                y = ConnectionCoordHistory.getInstance().adjustY(y);
                break;
            }
            case 7: {
                x = r.right() - this.inset - 16;
                y = r.bottom() - r.height / 2 + this.offset;
                y = ConnectionCoordHistory.getInstance().adjustY(y);
                break;
            }
            default: {
                x = r.right() - r.width / 2;
                y = r.bottom() - r.height / 2;
            }
        }
        PrecisionPoint p = new PrecisionPoint(x, y);
        this.getOwner().translateToAbsolute((Translatable)p);
        return p;
    }

    public Point getReferencePoint() {
        return this.getLocation(null);
    }
}

