/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import org.eclipse.bpel.ui.editors.xpath.XPathWordDetector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class XPathSourceDoubleClickStrategy
implements ITextDoubleClickStrategy {
    protected XPathWordDetector fWordDetector = new XPathWordDetector();
    protected ITextViewer fText;

    public void doubleClicked(ITextViewer part) {
        int pos = part.getSelectedRange().x;
        if (pos < 0) {
            return;
        }
        this.fText = part;
        if (!this.selectComment(pos)) {
            this.selectWord(pos);
        }
    }

    protected boolean selectComment(int caretPos) {
        int startPos;
        int pos;
        block8: {
            int c;
            IDocument doc;
            block7: {
                doc = this.fText.getDocument();
                pos = caretPos;
                c = 32;
                while (pos >= 0) {
                    c = doc.getChar(pos);
                    if (c == 92) {
                        pos -= 2;
                        continue;
                    }
                    if (c == 13 || c == 34) break;
                    --pos;
                }
                if (c == 34) break block7;
                return false;
            }
            try {
                startPos = pos;
                pos = caretPos;
                int length = doc.getLength();
                c = 32;
                while (pos < length) {
                    c = doc.getChar(pos);
                    if (c == 13 || c == 34) break;
                    ++pos;
                }
                if (c == 34) break block8;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        int endPos = pos;
        int offset = startPos + 1;
        int len = endPos - offset;
        this.fText.setSelectedRange(offset, len);
        return true;
    }

    protected boolean selectWord(int caretPos) {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = caretPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!this.fWordDetector.isWordPart(c)) break;
                --pos;
            }
            int startPos = pos;
            pos = caretPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!this.fWordDetector.isWordPart(c)) break;
                ++pos;
            }
            int endPos = pos;
            this.selectRange(startPos, endPos);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void selectRange(int startPos, int stopPos) {
        int offset = startPos + 1;
        int length = stopPos - offset;
        this.fText.setSelectedRange(offset, length);
    }
}

