/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.text.MessageFormat;
import org.eclipse.bpel.model.resource.BPELResourceSetImpl;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.providers.PartnerLinkTypeTreeContentProvider;
import org.eclipse.bpel.ui.details.providers.VariableTypeTreeContentProvider;
import org.eclipse.bpel.ui.details.providers.WSILContentProvider;
import org.eclipse.bpel.ui.util.filedialog.FileSelectionGroup;
import org.eclipse.bpel.wsil.model.inspection.Description;
import org.eclipse.bpel.wsil.model.inspection.Inspection;
import org.eclipse.bpel.wsil.model.inspection.Link;
import org.eclipse.bpel.wsil.model.inspection.Name;
import org.eclipse.bpel.wsil.model.inspection.Service;
import org.eclipse.bpel.wsil.model.inspection.TypeOfAbstract;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.part.DrillDownComposite;

public class SchemaImportDialog
extends SelectionStatusDialog {
    protected static final int BID_BROWSE_RESOURCE = 1025;
    protected static final int BID_BROWSE_URL = 1026;
    protected static final int BID_BROWSE_FILE = 1027;
    protected static final int BID_BROWSE = 1028;
    protected static final int BID_BROWSE_WSIL = 1029;
    private static final String IMPORT_KIND = "ImportKind";
    private static final String EMPTY = "";
    private String[] FILTER_EXTENSIONS = new String[]{"*.xsd", "*.wsdl", "*.*"};
    private String[] FILTER_NAMES = new String[]{"XML Schema Files", "WSDL Definition Files", "All"};
    private String resourceFilter = ".xsd";
    protected EObject modelObject;
    protected Tree fTree;
    protected TreeViewer fTreeViewer;
    Text fLocation;
    private Composite fLocationComposite;
    FileSelectionGroup fResourceComposite;
    private Composite fWSILComposite;
    protected TreeViewer fWSILTreeViewer;
    protected Tree fWSILTree;
    protected Text filterText;
    String fFilter = "";
    Button fBrowseButton;
    private Group fGroup;
    private IDialogSettings fSettings;
    private int KIND = 1025;
    private String fStructureTitle;
    private ITreeContentProvider fTreeContentProvider;
    protected Object fInput;
    protected BPELResourceSetImpl fHackedResourceSet;
    protected String fResourceKind = "xsd";
    long fRunnableStart;
    URI fRunnableLoadURI;
    Job fLoaderJob;
    IPreferenceStore fPrefStore = BPELUIPlugin.INSTANCE.getPreferenceStore();
    String fBasePath = this.fPrefStore.getString("pref_wsil_url");
    Button fBtnWSIL;

    public SchemaImportDialog(Shell parent) {
        super(parent);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fSettings = BPELUIPlugin.INSTANCE.getDialogSettingsFor((Object)this);
        try {
            this.KIND = this.fSettings.getInt(IMPORT_KIND);
        }
        catch (NumberFormatException numberFormatException) {
            this.KIND = 1025;
        }
        this.setDialogBoundsSettings(this.fSettings, this.getDialogBoundsStrategy());
        this.configureAsSchemaImport();
    }

    public SchemaImportDialog(Shell parent, EObject eObject) {
        this(parent);
        this.modelObject = eObject;
        this.setTitle(Messages.SchemaImportDialog_2);
        this.fHackedResourceSet = BPELUtils.slightlyHackedResourceSet((EObject)eObject);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createImportLocation(contents);
        this.createImportStructure(contents);
        this.buttonPressed(this.KIND, true);
        return contents;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1028: {
                FileDialog fileDialog = new FileDialog(this.getShell());
                fileDialog.setFilterExtensions(this.FILTER_EXTENSIONS);
                fileDialog.setFilterNames(this.FILTER_NAMES);
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                this.fLocation.setText(path);
                this.attemptLoad(path);
                break;
            }
            case 1: {
                if (this.fLoaderJob == null || this.fLoaderJob.getState() != 4) break;
                this.fLoaderJob.cancel();
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void buttonPressed(int id, boolean checked) {
        if (id == 1027 || id == 1025 || id == 1026 || id == 1029) {
            if (!checked) {
                return;
            }
            this.setVisibleControl((Control)this.fResourceComposite, id == 1025);
            this.setVisibleControl((Control)this.fLocationComposite, id == 1026 || id == 1027);
            this.setVisibleControl((Control)this.fWSILComposite, id == 1029);
            this.fBrowseButton.setEnabled(id == 1027 || id == 1029);
            this.fLocation.setText(EMPTY);
            this.markEmptySelection();
            this.KIND = id;
            this.fSettings.put(IMPORT_KIND, this.KIND);
            this.fGroup.getParent().layout(true);
        }
    }

    protected void setVisibleControl(Control c, boolean b) {
        Object layoutData = c.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)layoutData;
            data.exclude = !b;
        }
        c.setVisible(b);
    }

    public void create() {
        super.create();
        this.buttonPressed(this.KIND, true);
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int bid = (Integer)b.getData();
                SchemaImportDialog.this.buttonPressed(bid, b.getSelection());
            }
        });
        return button;
    }

    protected void createImportLocation(Composite parent) {
        this.fGroup = new Group(parent, 16);
        this.fGroup.setText(Messages.SchemaImportDialog_4);
        GridLayout layout = new GridLayout(1, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fGroup.setLayout((Layout)layout);
        this.fGroup.setLayoutData((Object)data);
        Composite container = new Composite((Composite)this.fGroup, 0);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        container.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        container.setLayoutData((Object)data);
        this.createRadioButton(container, Messages.SchemaImportDialog_5, 1025, this.KIND == 1025);
        this.createRadioButton(container, Messages.SchemaImportDialog_6, 1027, this.KIND == 1027);
        this.createRadioButton(container, Messages.SchemaImportDialog_7, 1026, this.KIND == 1026);
        this.fBtnWSIL = this.createRadioButton(container, Messages.SchemaImportDialog_15, 1029, this.KIND == 1029);
        this.fLocationComposite = new Composite((Composite)this.fGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.fLocationComposite.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fLocationComposite.setLayoutData((Object)data);
        Label location = new Label(this.fLocationComposite, 0);
        location.setText(Messages.SchemaImportDialog_8);
        this.fLocation = new Text(this.fLocationComposite, 2048);
        this.fLocation.setText(EMPTY);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fLocation.setLayoutData((Object)data);
        this.fLocation.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                String loc = SchemaImportDialog.this.fLocation.getText();
                if (loc.length() > 0) {
                    SchemaImportDialog.this.attemptLoad(loc);
                }
            }
        });
        this.fLocation.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13) {
                    SchemaImportDialog.this.attemptLoad(SchemaImportDialog.this.fLocation.getText());
                    event.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fBrowseButton = this.createButton(this.fLocationComposite, 1028, Messages.SchemaImportDialog_9, false);
        this.fResourceComposite = new FileSelectionGroup((Composite)this.fGroup, new Listener(){

            public void handleEvent(Event event) {
                IResource resource = SchemaImportDialog.this.fResourceComposite.getSelectedResource();
                if (resource != null && resource.getType() == 1) {
                    SchemaImportDialog.this.attemptLoad((IFile)resource);
                    return;
                }
                SchemaImportDialog.this.markEmptySelection();
            }
        }, Messages.SchemaImportDialog_10, this.resourceFilter);
        TreeViewer viewer = this.fResourceComposite.getTreeViewer();
        viewer.setAutoExpandLevel(2);
        this.createWSILStructure((Composite)this.fGroup);
    }

    protected Object createWSILStructure(Composite parent) {
        this.fWSILComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.fWSILComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 220;
        this.fWSILComposite.setLayoutData((Object)data);
        Label location = new Label(this.fWSILComposite, 0);
        location.setText(Messages.SchemaImportDialog_16);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 16384;
        location.setLayoutData((Object)data);
        this.filterText = new Text(this.fWSILComposite, 2048);
        data = new GridData(768);
        this.filterText.setLayoutData((Object)data);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                SchemaImportDialog.this.fFilter = SchemaImportDialog.this.filterText.getText().trim().toLowerCase();
                if (SchemaImportDialog.this.fFilter.length() > 0) {
                    SchemaImportDialog.this.fWSILTreeViewer.expandToLevel(3);
                }
                SchemaImportDialog.this.fWSILTreeViewer.refresh();
                e.doit = false;
            }
        });
        DrillDownComposite wsilTreeComposite = new DrillDownComposite(this.fWSILComposite, 2048);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        wsilTreeComposite.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        wsilTreeComposite.setLayoutData((Object)data);
        this.fWSILTree = new Tree((Composite)wsilTreeComposite, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fWSILTree.setLayoutData((Object)data);
        this.fWSILTreeViewer = new TreeViewer(this.fWSILTree);
        this.fWSILTreeViewer.setContentProvider((IContentProvider)new WSILContentProvider());
        this.fWSILTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelLabelProvider());
        Object wsilDoc = this.attemptLoad(URI.createURI((String)this.fBasePath), "wsil");
        this.fWSILTreeViewer.setInput(wsilDoc);
        if (wsilDoc == null || wsilDoc instanceof Throwable) {
            this.fBtnWSIL.setEnabled(false);
        }
        this.fWSILTreeViewer.expandToLevel(2);
        this.fWSILTreeViewer.addFilter((ViewerFilter)new TreeFilter());
        this.fWSILTreeViewer.setComparator((ViewerComparator)new WSILViewerComparator());
        wsilTreeComposite.setChildTree(this.fWSILTreeViewer);
        this.fWSILTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.getFirstElement() instanceof Service) {
                    Service serv = (Service)sel.getFirstElement();
                    Description descr = (Description)serv.getDescription().get(0);
                    SchemaImportDialog.this.attemptLoad(descr.getLocation());
                } else {
                    SchemaImportDialog.this.markEmptySelection();
                }
            }
        });
        return this.fWSILComposite;
    }

    protected Object createImportStructure(Composite parent) {
        Label location = new Label(parent, 0);
        location.setText(this.fStructureTitle);
        this.fTree = new Tree(parent, 2048);
        VariableTypeTreeContentProvider variableContentProvider = new VariableTypeTreeContentProvider(true, true);
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)(this.fTreeContentProvider != null ? this.fTreeContentProvider : variableContentProvider));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.setAutoExpandLevel(3);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fTree.setLayoutData((Object)data);
        return this.fTree;
    }

    Object attemptLoad(URI uri, String kind) {
        Resource resource = null;
        try {
            resource = this.fHackedResourceSet.getResource(uri, true, kind);
        }
        catch (Throwable t) {
            return t;
        }
        if (resource != null && resource.getErrors().isEmpty() && resource.isLoaded()) {
            return resource.getContents().get(0);
        }
        return null;
    }

    Object attemptLoad(URI uri) {
        return this.attemptLoad(uri, this.fResourceKind);
    }

    void attemptLoad(IFile file) {
        this.attemptLoad(file.getFullPath().toString());
    }

    void attemptLoad(String path) {
        if (this.fLoaderJob != null && this.fLoaderJob.getState() == 4) {
            this.fLoaderJob.cancel();
        }
        this.updateStatus(Status.OK_STATUS);
        if (path.length() == 0) {
            return;
        }
        URI uri = this.convertToURI(path);
        if (uri == null) {
            return;
        }
        if (uri.isRelative()) {
            String absolutepath = String.valueOf(this.fBasePath.substring(0, this.fBasePath.lastIndexOf(47) + 1)) + path;
            uri = URI.createURI((String)absolutepath);
        }
        this.fRunnableLoadURI = uri;
        final String msg = MessageFormat.format(Messages.SchemaImportDialog_17, this.fRunnableLoadURI);
        this.fLoaderJob = new Job(msg){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(msg, 1);
                monitor.worked(1);
                if (SchemaImportDialog.this.fBrowseButton != null && !SchemaImportDialog.this.fBrowseButton.isDisposed()) {
                    SchemaImportDialog.this.fBrowseButton.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).SchemaImportDialog.this.fInput = SchemaImportDialog.this.attemptLoad((this).SchemaImportDialog.this.fRunnableLoadURI);
                            SchemaImportDialog.this.loadDone();
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.fLoaderJob.schedule();
        this.fRunnableStart = System.currentTimeMillis();
        this.updateStatus((IStatus)new Status(1, BPELUIPlugin.INSTANCE.getID(), 0, msg, null));
    }

    void loadDone() {
        long elapsed = System.currentTimeMillis() - this.fRunnableStart;
        if (this.fInput == null || this.fInput instanceof Throwable) {
            this.markEmptySelection();
            this.updateStatus((IStatus)new Status(4, BPELUIPlugin.INSTANCE.getID(), 0, MessageFormat.format(Messages.SchemaImportDialog_19, this.fRunnableLoadURI, elapsed), (Throwable)this.fInput));
            this.fInput = null;
        } else {
            this.updateStatus((IStatus)new Status(1, BPELUIPlugin.INSTANCE.getID(), 0, MessageFormat.format(Messages.SchemaImportDialog_18, this.fRunnableLoadURI, elapsed), null));
            this.fTreeViewer.setInput(this.fInput);
            this.fTree.getVerticalBar().setSelection(0);
        }
    }

    void markEmptySelection() {
        this.updateStatus(Status.OK_STATUS);
        this.updateOK(false);
        this.fTreeViewer.setInput(null);
    }

    private URI convertToURI(String path) {
        try {
            switch (this.KIND) {
                case 1027: {
                    return URI.createFileURI((String)path);
                }
                case 1025: {
                    return URI.createPlatformResourceURI((String)path);
                }
                case 1026: 
                case 1029: {
                    return URI.createURI((String)path);
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.updateStatus((IStatus)new Status(4, BPELUIPlugin.INSTANCE.getID(), 0, Messages.SchemaImportDialog_13, (Throwable)ex));
            return null;
        }
    }

    public void updateOK(boolean state) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(state);
        }
    }

    protected void computeResult() {
        Object object = this.fTreeViewer.getInput();
        if (object == null) {
            return;
        }
        this.setSelectionResult(new Object[]{object});
    }

    public void configureAsSchemaImport() {
        this.setTitle(Messages.SchemaImportDialog_2);
        this.fStructureTitle = Messages.SchemaImportDialog_11;
        this.fResourceKind = "xsd";
    }

    public void configureAsWSDLImport() {
        this.setTitle(Messages.SchemaImportDialog_0);
        this.fStructureTitle = Messages.SchemaImportDialog_14;
        this.fTreeContentProvider = new PartnerLinkTypeTreeContentProvider(true);
        this.fResourceKind = "wsdl";
        String[] wsdl_FILTER_EXTENSIONS = new String[]{"*.wsdl", "*.xsd", "*.*"};
        this.FILTER_EXTENSIONS = wsdl_FILTER_EXTENSIONS;
        String[] wsdl_FILTER_NAMES = new String[]{"WSDL Definition Files", "XML Schema Files", "All"};
        this.FILTER_NAMES = wsdl_FILTER_NAMES;
        this.resourceFilter = ".wsdl";
    }

    public class TreeFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (SchemaImportDialog.this.fFilter == null || SchemaImportDialog.this.fFilter.length() == 0) {
                return true;
            }
            if (element instanceof Service) {
                String text = SchemaImportDialog.EMPTY;
                Service service = (Service)element;
                if (service.getName().size() > 0) {
                    Name name = (Name)service.getName().get(0);
                    text = String.valueOf(text) + name.getValue();
                }
                if (service.getAbstract().size() > 0) {
                    TypeOfAbstract abst = (TypeOfAbstract)service.getAbstract().get(0);
                    text = String.valueOf(text) + abst.getValue();
                }
                return text.toLowerCase().indexOf(SchemaImportDialog.this.fFilter) > -1;
            }
            return true;
        }
    }

    public class WSILViewerComparator
    extends ViewerComparator {
        public int category(Object element) {
            if (element instanceof Inspection) {
                return 1;
            }
            if (element instanceof Link) {
                return 2;
            }
            if (element instanceof Service) {
                return 3;
            }
            return 0;
        }
    }
}

