/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.List;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.emf.ecore.EObject;

public abstract class SwapInListCommand
extends AutoUndoCommand {
    protected EObject target;
    private int firstNo;
    private int secondNo;

    public SwapInListCommand(EObject target, int firstElement, int secondElement, String cmdLabel) {
        super(cmdLabel, target);
        this.target = target;
        if (firstElement < secondElement) {
            this.firstNo = firstElement;
            this.secondNo = secondElement;
        } else {
            this.firstNo = secondElement;
            this.secondNo = firstElement;
        }
    }

    protected abstract List getList();

    @Override
    public void doExecute() {
        List list = this.getList();
        if (list == null || list.isEmpty()) {
            throw new IllegalStateException();
        }
        Object first = list.get(this.firstNo);
        Object second = list.get(this.secondNo);
        list.remove(this.secondNo);
        list.remove(this.firstNo);
        list.add(this.firstNo, second);
        list.add(this.secondNo, first);
    }
}

