/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions.editpart;

import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.actions.editpart.IEditPartAction;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.InsertInContainerCommand;
import org.eclipse.bpel.ui.commands.SetNameAndDirectEditCommand;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.factories.UIObjectFactoryProvider;
import org.eclipse.bpel.ui.uiextensionmodel.StartNode;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CreateProcessFaultHandlerAction
implements IEditPartAction {
    protected final Object modelObject;
    protected final EditPart editPart;
    protected final EditPartViewer viewer;

    public CreateProcessFaultHandlerAction(EditPart editPart) {
        StartNode startNode = ((StartNodeEditPart)editPart).getStartNode();
        Process process = startNode.getProcess();
        this.modelObject = process;
        this.editPart = editPart;
        this.viewer = editPart.getViewer();
    }

    public Image getIconImg() {
        return BPELUIPlugin.INSTANCE.getImage("obj16/faulthandler.gif");
    }

    @Override
    public ImageDescriptor getIcon() {
        return BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/faulthandler.gif");
    }

    @Override
    public boolean onButtonPressed() {
        CompoundCommand command = new CompoundCommand(IBPELUIConstants.CMD_ADD_FAULTHANDLER);
        FaultHandler faultHandler = BPELFactory.eINSTANCE.createFaultHandler();
        Catch _catch = (Catch)UIObjectFactoryProvider.getInstance().getFactoryFor(BPELPackage.eINSTANCE.getCatch()).createInstance();
        faultHandler.getCatch().add((Object)_catch);
        command.add((Command)new InsertInContainerCommand((EObject)this.modelObject, (EObject)faultHandler, null));
        command.add((Command)new SetNameAndDirectEditCommand(_catch, this.viewer));
        ModelHelper.getBPELEditor(this.modelObject).getCommandStack().execute((Command)command);
        BPELUtil.setShowFaultHandler(this.editPart, true);
        return true;
    }

    @Override
    public String getToolTip() {
        return Messages.CreateFaultHandlerAction_Add_Fault_Handler_1;
    }

    public void onMouseEnter(Point location) {
    }

    public void onMouseExit(Point location) {
    }

    @Override
    public void onDispose() {
    }

    @Override
    public void onCreate() {
    }

    @Override
    public ImageDescriptor getDisabledIcon() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

