/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.actions;

import java.util.ArrayList;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELMultipageEditorPart;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.actions.BPELCopyAction;
import org.eclipse.bpel.ui.commands.BPELCopyCommand;
import org.eclipse.bpel.ui.commands.BPELPasteCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.RestoreSelectionCommand;
import org.eclipse.bpel.ui.commands.SetSelectionCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class BPELDuplicateAction
extends BPELCopyAction
implements IEditorActionDelegate {
    public static final String ACTION_ID = BPELDuplicateAction.class.getName();

    public BPELDuplicateAction() {
        super(null);
    }

    public BPELDuplicateAction(IWorkbenchPart editorPart) {
        super(editorPart);
    }

    @Override
    protected void init() {
        super.init();
        this.setText(Messages.BPELDuplicateAction_Duplicate_1);
        this.setToolTipText(Messages.BPELDuplicateAction_Duplicate_2);
        this.setId(ACTION_ID);
        this.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("elcl16/duplicate.png"));
        this.setDisabledImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("dlcl16/duplicate.png"));
        this.setEnabled(false);
    }

    @Override
    protected Command getCommand() {
        CompoundCommand cmd = new CompoundCommand(Messages.BPELCopyAction_Copy_3);
        BPELEditor bpelEditor = (BPELEditor)this.getWorkbenchPart();
        cmd.add((Command)new RestoreSelectionCommand((ISelectionProvider)bpelEditor.getAdaptingSelectionProvider(), true, true));
        BPELCopyCommand copyCmd = new BPELCopyCommand(bpelEditor);
        if (this.fSelection.isEmpty()) {
            for (Object o : ((IStructuredSelection)bpelEditor.getSelection()).toList()) {
                if (!(o instanceof EObject)) continue;
                this.fSelection.add((EObject)o);
            }
        }
        if (this.fSelection.isEmpty()) {
            return null;
        }
        copyCmd.setObjectList(new ArrayList<EObject>(this.fSelection));
        cmd.add((Command)copyCmd);
        BPELPasteCommand pasteCmd = new BPELPasteCommand(bpelEditor){

            @Override
            public boolean canDoExecute() {
                return true;
            }
        };
        pasteCmd.setTargetObject((EObject)this.fSelection.get(0), true);
        cmd.add((Command)pasteCmd);
        cmd.add((Command)new SetSelectionCommand(pasteCmd, false));
        return cmd;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof BPELMultipageEditorPart) {
            targetEditor = ((BPELMultipageEditorPart)targetEditor).getActiveEditor();
        }
        if (!(targetEditor instanceof BPELEditor)) {
            targetEditor = null;
        }
        this.setWorkbenchPart((IWorkbenchPart)targetEditor);
        if (targetEditor == null) {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
    }
}

