/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.resource.VariableResolver;
import org.eclipse.emf.ecore.EObject;

public class BPELVariableResolver
implements VariableResolver {
    @Override
    public Variable getVariable(EObject eObject, String variableName) {
        EObject container = eObject.eContainer();
        while (container != null) {
            Variable variable;
            if (container instanceof OnEvent) {
                variable = ((OnEvent)container).getVariable();
                if (variable != null && variable.getName().equals(variableName)) {
                    return variable;
                }
            } else if (container instanceof Catch) {
                variable = ((Catch)container).getFaultVariable();
                if (variable != null && variable.getName().equals(variableName)) {
                    return variable;
                }
            } else if (container instanceof ForEach) {
                variable = ((ForEach)container).getCounterName();
                if (variable != null && variable.getName().equals(variableName)) {
                    return variable;
                }
            } else {
                Variables variables = null;
                if (container instanceof Process) {
                    variables = ((Process)container).getVariables();
                } else if (container instanceof Scope) {
                    variables = ((Scope)container).getVariables();
                }
                if (variables != null) {
                    ArrayList<Variable> list = new ArrayList<Variable>();
                    list.addAll((Collection<Variable>)variables.getChildren());
                    list.addAll(variables.getExtensibilityElements());
                    for (Object e : list) {
                        Variable variable2;
                        String name;
                        if (!(e instanceof Variable) || (name = (variable2 = (Variable)e).getName()) == null || !name.equals(variableName)) continue;
                        return variable2;
                    }
                }
            }
            container = container.eContainer();
        }
        return null;
    }
}

