/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.BPELPlugin;
import org.eclipse.bpel.model.Branches;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.Compensate;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CompletionCondition;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationPattern;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Documentation;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.Empty;
import org.eclipse.bpel.model.EndpointReferenceRole;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.Exit;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.model.Extension;
import org.eclipse.bpel.model.Extensions;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.FromPart;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.OpaqueActivity;
import org.eclipse.bpel.model.PartnerActivity;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Query;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Rethrow;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.ServiceRef;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.ToPart;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.Wait;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.extensions.BPELActivityDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionDeserializer;
import org.eclipse.bpel.model.extensions.BPELExtensionRegistry;
import org.eclipse.bpel.model.extensions.BPELUnknownExtensionDeserializer;
import org.eclipse.bpel.model.extensions.ServiceReferenceDeserializer;
import org.eclipse.bpel.model.impl.FromImpl;
import org.eclipse.bpel.model.impl.FromPartImpl;
import org.eclipse.bpel.model.impl.OnEventImpl;
import org.eclipse.bpel.model.impl.OnMessageImpl;
import org.eclipse.bpel.model.impl.PartnerActivityImpl;
import org.eclipse.bpel.model.impl.ToImpl;
import org.eclipse.bpel.model.impl.ToPartImpl;
import org.eclipse.bpel.model.messageproperties.util.MessagepropertiesConstants;
import org.eclipse.bpel.model.proxy.CorrelationSetProxy;
import org.eclipse.bpel.model.proxy.LinkProxy;
import org.eclipse.bpel.model.proxy.MessageExchangeProxy;
import org.eclipse.bpel.model.proxy.MessageProxy;
import org.eclipse.bpel.model.proxy.PartnerLinkProxy;
import org.eclipse.bpel.model.proxy.PartnerLinkTypeProxy;
import org.eclipse.bpel.model.proxy.PropertyProxy;
import org.eclipse.bpel.model.proxy.RoleProxy;
import org.eclipse.bpel.model.proxy.VariableProxy;
import org.eclipse.bpel.model.proxy.XSDElementDeclarationProxy;
import org.eclipse.bpel.model.proxy.XSDTypeDefinitionProxy;
import org.eclipse.bpel.model.resource.BPELLinkResolver;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.resource.BPELVariableResolver;
import org.eclipse.bpel.model.resource.LineCapturingDOMParser;
import org.eclipse.bpel.model.resource.LinkResolver;
import org.eclipse.bpel.model.resource.SAXParseDiagnostic;
import org.eclipse.bpel.model.resource.VariableResolver;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class BPELReader
implements ErrorHandler {
    private Process process = null;
    private Resource fCurrentResource = null;
    private Resource fResource = null;
    private DocumentBuilder docBuilder = null;
    private BPELExtensionRegistry extensionRegistry = BPELExtensionRegistry.getInstance();
    private DOMParser fDOMParser;
    ErrorHandler fErrorHandler = null;
    public static VariableResolver VARIABLE_RESOLVER = new BPELVariableResolver();
    public static LinkResolver LINK_RESOLVER = new BPELLinkResolver();
    List<Runnable> fPass2Runnables = new ArrayList<Runnable>();

    public BPELReader(DocumentBuilder builder) throws IOException {
        if (builder == null) {
            throw new IOException(BPELPlugin.INSTANCE.getString("%BPELReader.missing_doc_builder"));
        }
        this.docBuilder = builder;
    }

    public BPELReader(DOMParser parser) {
        this.fDOMParser = parser;
    }

    public void read(BPELResource resource, Document doc) {
        this.fResource = resource;
        this.pass1(doc);
        this.pass2();
    }

    public BPELReader() {
        this.fDOMParser = new LineCapturingDOMParser();
        try {
            this.fDOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.fDOMParser.setFeature("http://apache.org/xml/features/xinclude", false);
        }
        catch (SAXNotRecognizedException e) {
            BPELPlugin.log("Not Recognized DOM Parser Feature", e);
        }
        catch (SAXNotSupportedException e) {
            BPELPlugin.log("Not Supported DOM Parser Feature", e);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    void armErrorHandler() {
        assert (this.docBuilder != null || this.fDOMParser != null);
        if (this.docBuilder != null) {
            this.docBuilder.setErrorHandler(this.fErrorHandler != null ? this.fErrorHandler : this);
        } else {
            this.fDOMParser.setErrorHandler(this.fErrorHandler != null ? this.fErrorHandler : this);
        }
    }

    Document read(InputSource inputSource) throws IOException, SAXException {
        assert (this.docBuilder != null || this.fDOMParser != null) : "No document builder/parser set";
        if (this.docBuilder != null) {
            return this.docBuilder.parse(inputSource);
        }
        this.fDOMParser.parse(inputSource);
        return this.fDOMParser.getDocument();
    }

    public void read(BPELResource resource, InputStream inputStream) {
        this.armErrorHandler();
        Document doc = null;
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setPublicId(resource.getURI().toString());
            inputSource.setSystemId(resource.getURI().toString());
            resource.setErrorHandler(this.fErrorHandler != null ? this.fErrorHandler : this);
            this.fCurrentResource = resource;
            doc = this.read(inputSource);
            this.fResource = resource;
        }
        catch (SAXException inputSource) {
        }
        catch (IOException ioe) {
            BPELPlugin.log("I/O Error Reading BPEL XML", ioe);
        }
        if (doc != null) {
            this.pass1(doc);
            this.pass2();
        }
        this.fCurrentResource = null;
    }

    public Resource getResource() {
        return this.fResource;
    }

    public List<EObject> fromXML(String xmlSource, String sourceDescription, Resource resource) {
        this.armErrorHandler();
        if (sourceDescription == null) {
            sourceDescription = "String";
        }
        Document doc = null;
        try {
            InputSource inputSource = new InputSource(new StringReader(xmlSource));
            inputSource.setPublicId(sourceDescription);
            this.fCurrentResource = resource;
            doc = this.read(inputSource);
        }
        catch (SAXException inputSource) {
        }
        catch (IOException ioe) {
            BPELPlugin.log("I/O Error Reading BPEL XML", ioe);
        }
        if (doc == null) {
            this.fCurrentResource = null;
            return Collections.emptyList();
        }
        this.fResource = resource;
        List<EObject> result = this.parseDocument(doc);
        this.pass2();
        this.fCurrentResource = null;
        return result;
    }

    protected void pass1(Document document) {
        Process p = this.xml2Resource(document);
        if (p != null) {
            this.fResource.getContents().add((Object)p);
        }
    }

    protected void pass2() {
        try {
            for (Runnable r : this.fPass2Runnables) {
                r.run();
            }
        }
        finally {
            this.fPass2Runnables.clear();
        }
    }

    protected List<Element> getChildElements(Element parentElement) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                list.add((Element)children.item(i));
            }
            ++i;
        }
        return list;
    }

    public List<Element> getBPELChildElementsByLocalName(Element parentElement, String localName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (localName.equals(node.getLocalName()) && BPELUtils.isBPELElement(node)) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public Element getBPELChildElementByLocalName(Element parentElement, String localName) {
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (localName.equals(node.getLocalName()) && BPELUtils.isBPELElement(node)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    protected Map<String, String> getAllNamespacesForElement(Element element) {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        Node tempNode = element;
        while (tempNode != null && tempNode.getNodeType() == 1) {
            NamedNodeMap attrs = tempNode.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                String key;
                Attr attr = (Attr)attrs.item(i);
                if ("http://www.w3.org/2000/xmlns/".equalsIgnoreCase(attr.getNamespaceURI()) && !nsMap.containsKey(key = BPELUtils.getNSPrefixMapKey(attr.getLocalName()))) {
                    nsMap.put(key, attr.getValue());
                }
                ++i;
            }
            tempNode = tempNode.getParentNode();
        }
        return nsMap;
    }

    protected void saveNamespacePrefix(EObject eObject, Element element) {
        INamespaceMap<String, String> nsMap = null;
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                if (nsMap == null) {
                    nsMap = BPELUtils.getNamespaceMap(eObject);
                }
                nsMap.put(BPELUtils.getNSPrefixMapKey(attr.getLocalName()), attr.getValue());
            }
            ++i;
        }
    }

    protected Activity getChildActivity(Element element) {
        NodeList activityElements = element.getChildNodes();
        int i = 0;
        while (i < activityElements.getLength()) {
            Element activityElement;
            Activity activity;
            if (activityElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(activityElement = (Element)activityElements.item(i))) != null) {
                return activity;
            }
            ++i;
        }
        return null;
    }

    protected void setPartnerLink(Element activityElement, final EObject eObject, final EReference reference) {
        if (!activityElement.hasAttribute("partnerLink")) {
            return;
        }
        final String partnerLinkName = activityElement.getAttribute("partnerLink");
        this.fPass2Runnables.add(new Runnable(){

            @Override
            public void run() {
                PartnerLink targetPartnerLink = BPELUtils.getPartnerLink(eObject, partnerLinkName);
                if (targetPartnerLink == null) {
                    targetPartnerLink = new PartnerLinkProxy(BPELReader.this.getResource().getURI(), partnerLinkName);
                }
                eObject.eSet((EStructuralFeature)reference, (Object)targetPartnerLink);
            }
        });
    }

    protected void setVariable(Element activityElement, final EObject eObject, String variableNameAttr, final EReference reference) {
        if (!activityElement.hasAttribute(variableNameAttr)) {
            return;
        }
        final String variableName = activityElement.getAttribute(variableNameAttr);
        this.fPass2Runnables.add(new Runnable(){

            @Override
            public void run() {
                Variable targetVariable = BPELReader.getVariable(eObject, variableName);
                if (targetVariable == null) {
                    targetVariable = new VariableProxy(BPELReader.this.getResource().getURI(), variableName);
                }
                eObject.eSet((EStructuralFeature)reference, (Object)targetVariable);
            }
        });
    }

    protected void setProperties(Element element, EObject eObject, String propertyName) {
        String propertyAttribute = element.getAttribute(propertyName);
        if (propertyAttribute == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(propertyAttribute);
        while (st.hasMoreTokens()) {
            QName qName = BPELUtils.createQName(element, st.nextToken());
            PropertyProxy property = new PropertyProxy(this.getResource().getURI(), qName);
            if (eObject instanceof CorrelationSet) {
                ((CorrelationSet)eObject).getProperties().add((Object)property);
                continue;
            }
            if (!(eObject instanceof To)) continue;
            ((To)eObject).setProperty(property);
        }
    }

    protected void setCompensationHandler(Element element, EObject eObject) {
        Element compensationHandlerElement = this.getBPELChildElementByLocalName(element, "compensationHandler");
        if (compensationHandlerElement != null) {
            CompensationHandler compensationHandler = this.xml2CompensationHandler(compensationHandlerElement);
            this.xml2ExtensibleElement(compensationHandler, compensationHandlerElement);
            if (eObject instanceof Invoke) {
                ((Invoke)eObject).setCompensationHandler(compensationHandler);
            } else if (eObject instanceof Scope) {
                ((Scope)eObject).setCompensationHandler(compensationHandler);
            }
        }
    }

    protected void setFaultHandler(Element element, BPELExtensibleElement extensibleElement) {
        List<Element> faultHandlerElements = this.getBPELChildElementsByLocalName(element, "faultHandlers");
        if (faultHandlerElements.size() > 0) {
            FaultHandler faultHandler = this.xml2FaultHandler(faultHandlerElements.get(0));
            if (extensibleElement instanceof Process) {
                ((Process)extensibleElement).setFaultHandlers(faultHandler);
            } else if (extensibleElement instanceof Invoke) {
                ((Invoke)extensibleElement).setFaultHandler(faultHandler);
            }
        }
    }

    protected void setEventHandler(Element element, BPELExtensibleElement extensibleElement) {
        List<Element> eventHandlerElements = this.getBPELChildElementsByLocalName(element, "eventHandlers");
        if (eventHandlerElements.size() > 0) {
            EventHandler eventHandler = this.xml2EventHandler(eventHandlerElements.get(0));
            if (extensibleElement instanceof Process) {
                ((Process)extensibleElement).setEventHandlers(eventHandler);
            } else if (extensibleElement instanceof Scope) {
                ((Scope)extensibleElement).setEventHandlers(eventHandler);
            }
        }
    }

    protected void setStandardAttributes(Element activityElement, Activity activity) {
        Attr suppressJoinFailure;
        Attr name = activityElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            activity.setName(name.getValue());
        }
        if ((suppressJoinFailure = activityElement.getAttributeNode("suppressJoinFailure")) != null && suppressJoinFailure.getSpecified()) {
            activity.setSuppressJoinFailure(suppressJoinFailure.getValue().equals("yes"));
        }
    }

    protected void setOperationParms(Element activityElement, PartnerActivity activity, EReference variableReference, EReference inputVariableReference, EReference outputVariableReference, EReference partnerReference) {
        Element correlationsElement;
        this.setPartnerLink(activityElement, (EObject)activity, partnerReference);
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            activity.setPortType(portType);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                activity.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((PartnerActivityImpl)activity).setOperationName(activityElement.getAttribute("operation"));
            }
        }
        if (variableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "variable", variableReference);
        }
        if (inputVariableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "inputVariable", inputVariableReference);
        }
        if (outputVariableReference != null) {
            this.setVariable(activityElement, (EObject)activity, "outputVariable", outputVariableReference);
        }
        if ((correlationsElement = this.getBPELChildElementByLocalName(activityElement, "correlations")) != null) {
            Correlations correlations = this.xml2Correlations(correlationsElement);
            activity.setCorrelations(correlations);
        }
    }

    protected void setOperationParmsOnMessage(Element activityElement, OnMessage onMessage) {
        this.setPartnerLink(activityElement, (EObject)onMessage, BPELPackage.eINSTANCE.getOnMessage_PartnerLink());
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            onMessage.setPortType(portType);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                onMessage.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((OnMessageImpl)onMessage).setOperationName(activityElement.getAttribute("operation"));
            }
        }
        this.setVariable(activityElement, (EObject)onMessage, "variable", BPELPackage.eINSTANCE.getOnMessage_Variable());
        Element correlationsElement = this.getBPELChildElementByLocalName(activityElement, "correlations");
        if (correlationsElement != null) {
            Correlations correlations = this.xml2Correlations(correlationsElement);
            onMessage.setCorrelations(correlations);
        }
    }

    protected void setOperationParmsOnEvent(Element activityElement, OnEvent onEvent) {
        QName qName;
        this.setPartnerLink(activityElement, (EObject)onEvent, BPELPackage.eINSTANCE.getOnEvent_PartnerLink());
        PortType portType = null;
        if (activityElement.hasAttribute("portType")) {
            portType = BPELUtils.getPortType(this.getResource().getURI(), activityElement, "portType");
            onEvent.setPortType(portType);
        }
        if (activityElement.hasAttribute("operation")) {
            if (portType != null) {
                onEvent.setOperation(BPELUtils.getOperation(this.getResource().getURI(), portType, activityElement, "operation"));
            } else {
                ((OnEventImpl)onEvent).setOperationName(activityElement.getAttribute("operation"));
            }
        }
        if (activityElement.hasAttribute("variable")) {
            Variable variable = BPELFactory.eINSTANCE.createVariable();
            String name = activityElement.getAttribute("variable");
            variable.setName(name);
            onEvent.setVariable(variable);
        }
        if (activityElement.hasAttribute("messageType")) {
            qName = BPELUtils.createAttributeValue(activityElement, "messageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            onEvent.setMessageType((Message)messageType);
        }
        if (activityElement.hasAttribute("element")) {
            qName = BPELUtils.createAttributeValue(activityElement, "element");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            onEvent.setXSDElement((XSDElementDeclaration)element);
        } else {
            onEvent.setXSDElement(null);
        }
        Element correlationsElement = this.getBPELChildElementByLocalName(activityElement, "correlations");
        if (correlationsElement != null) {
            Correlations correlations = this.xml2Correlations(correlationsElement);
            onEvent.setCorrelations(correlations);
        }
    }

    protected List<EObject> parseDocument(Document document) {
        Element element = document != null ? document.getDocumentElement() : null;
        ArrayList<EObject> list = new ArrayList<EObject>();
        if (element == null) {
            return list;
        }
        if (element.getLocalName().equals("bag")) {
            Node n = element.getFirstChild();
            while (n != null) {
                EObject next;
                if (n instanceof Element && (next = this.parseElement((Element)n)) != null) {
                    list.add(next);
                }
                n = n.getNextSibling();
            }
        } else {
            EObject next = this.parseElement(element);
            if (next != null) {
                list.add(next);
            }
        }
        return list;
    }

    EObject parseElement(Element element) {
        Method parseMethod = this.getParseMethod(element);
        if (parseMethod == null) {
            return null;
        }
        try {
            return (EObject)parseMethod.invoke((Object)this, element);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    Method getParseMethod(Element element) {
        if (!BPELUtils.isBPELElement(element)) {
            return null;
        }
        String methodName = element.getLocalName();
        methodName = "xml2" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
        return this.lookupMethod(this.getClass(), methodName, Element.class);
    }

    Method lookupMethod(Class<?> target, String methodName, Class<?> ... args) {
        if (target == null || target == Object.class) {
            return null;
        }
        Method[] methodArray = target.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && m.getParameterTypes().length == args.length) {
                Class<?>[] argTypes = m.getParameterTypes();
                int i = 0;
                while (i < args.length) {
                    if (!argTypes[i].isAssignableFrom(args[i])) {
                        // empty if block
                    }
                    ++i;
                }
                return m;
            }
            ++n2;
        }
        return this.lookupMethod(target.getSuperclass(), methodName, args);
    }

    protected Process xml2Resource(Document document) {
        Element processElement;
        Element element = processElement = document != null ? document.getDocumentElement() : null;
        if (processElement == null) {
            return null;
        }
        return this.xml2Process(processElement);
    }

    protected Process xml2Process(Element processElement) {
        Element extensionsElement;
        Element messageExchangesElements;
        Element correlationSetsElement;
        Element variablesElement;
        if (!processElement.getLocalName().equals("process")) {
            return null;
        }
        if (!BPELConstants.isBPELNamespace(processElement.getNamespaceURI())) {
            return null;
        }
        this.process = BPELFactory.eINSTANCE.createProcess();
        this.process.setElement(processElement);
        this.saveNamespacePrefix((EObject)this.process, processElement);
        if (processElement.hasAttribute("name")) {
            this.process.setName(processElement.getAttribute("name"));
        }
        if (processElement.hasAttribute("targetNamespace")) {
            this.process.setTargetNamespace(processElement.getAttribute("targetNamespace"));
        }
        if (processElement.hasAttribute("suppressJoinFailure")) {
            this.process.setSuppressJoinFailure(processElement.getAttribute("suppressJoinFailure").equals("yes"));
        }
        if (processElement.hasAttribute("exitOnStandardFault")) {
            this.process.setExitOnStandardFault(processElement.getAttribute("exitOnStandardFault").equals("yes"));
        }
        if (processElement.hasAttribute("variableAccessSerializable")) {
            this.process.setVariableAccessSerializable(processElement.getAttribute("variableAccessSerializable").equals("yes"));
        }
        if (processElement.hasAttribute("queryLanguage")) {
            this.process.setQueryLanguage(processElement.getAttribute("queryLanguage"));
        }
        if (processElement.hasAttribute("expressionLanguage")) {
            this.process.setExpressionLanguage(processElement.getAttribute("expressionLanguage"));
        }
        for (Element e : this.getBPELChildElementsByLocalName(processElement, "import")) {
            this.process.getImports().add((Object)this.xml2Import(e));
        }
        Element partnerLinksElement = this.getBPELChildElementByLocalName(processElement, "partnerLinks");
        if (partnerLinksElement != null) {
            this.process.setPartnerLinks(this.xml2PartnerLinks(partnerLinksElement));
        }
        if ((variablesElement = this.getBPELChildElementByLocalName(processElement, "variables")) != null) {
            this.process.setVariables(this.xml2Variables(variablesElement));
        }
        if ((correlationSetsElement = this.getBPELChildElementByLocalName(processElement, "correlationSets")) != null) {
            this.process.setCorrelationSets(this.xml2CorrelationSets(correlationSetsElement));
        }
        if ((messageExchangesElements = this.getBPELChildElementByLocalName(processElement, "messageExchanges")) != null) {
            this.process.setMessageExchanges(this.xml2MessageExchanges(messageExchangesElements));
        }
        if ((extensionsElement = this.getBPELChildElementByLocalName(processElement, "extensions")) != null) {
            this.process.setExtensions(this.xml2Extensions(extensionsElement));
        }
        this.setFaultHandler(processElement, this.process);
        this.setEventHandler(processElement, this.process);
        Activity activity = this.xml2Activity(processElement);
        this.process.setActivity(activity);
        this.xml2ExtensibleElement(this.process, processElement);
        return this.process;
    }

    public PartnerLinks xml2PartnerLinks(Element partnerLinksElement) {
        if (!partnerLinksElement.getLocalName().equals("partnerLinks")) {
            return null;
        }
        PartnerLinks partnerLinks = BPELFactory.eINSTANCE.createPartnerLinks();
        partnerLinks.setElement(partnerLinksElement);
        this.saveNamespacePrefix((EObject)partnerLinks, partnerLinksElement);
        for (Element e : this.getBPELChildElementsByLocalName(partnerLinksElement, "partnerLink")) {
            partnerLinks.getChildren().add((Object)this.xml2PartnerLink(e));
        }
        this.xml2ExtensibleElement(partnerLinks, partnerLinksElement);
        return partnerLinks;
    }

    public Variables xml2Variables(Element variablesElement) {
        if (!variablesElement.getLocalName().equals("variables")) {
            return null;
        }
        Variables variables = BPELFactory.eINSTANCE.createVariables();
        variables.setElement(variablesElement);
        this.saveNamespacePrefix((EObject)variables, variablesElement);
        for (Element e : this.getBPELChildElementsByLocalName(variablesElement, "variable")) {
            variables.getChildren().add((Object)this.xml2Variable(e));
        }
        this.xml2ExtensibleElement(variables, variablesElement);
        BasicEList toBeMoved = new BasicEList();
        for (Object next : variables.getExtensibilityElements()) {
            if (!(next instanceof Variable)) continue;
            toBeMoved.add((Variable)next);
        }
        List extensibility = variables.getExtensibilityElements();
        EList<Variable> children = variables.getChildren();
        for (Variable element : toBeMoved) {
            extensibility.remove(element);
            children.add(element);
        }
        return variables;
    }

    public CorrelationSets xml2CorrelationSets(Element correlationSetsElement) {
        if (!correlationSetsElement.getLocalName().equals("correlationSets")) {
            return null;
        }
        CorrelationSets correlationSets = BPELFactory.eINSTANCE.createCorrelationSets();
        correlationSets.setElement(correlationSetsElement);
        this.saveNamespacePrefix((EObject)correlationSets, correlationSetsElement);
        for (Element e : this.getBPELChildElementsByLocalName(correlationSetsElement, "correlationSet")) {
            correlationSets.getChildren().add((Object)this.xml2CorrelationSet(e));
        }
        this.xml2ExtensibleElement(correlationSets, correlationSetsElement);
        return correlationSets;
    }

    protected FromParts xml2FromParts(Element fromPartsElement) {
        if (!fromPartsElement.getLocalName().equals("fromParts")) {
            return null;
        }
        FromParts fromParts = BPELFactory.eINSTANCE.createFromParts();
        fromParts.setElement(fromPartsElement);
        this.saveNamespacePrefix((EObject)fromParts, fromPartsElement);
        for (Element e : this.getBPELChildElementsByLocalName(fromPartsElement, "fromPart")) {
            fromParts.getChildren().add((Object)this.xml2FromPart(e));
        }
        this.xml2ExtensibleElement(fromParts, fromPartsElement);
        return fromParts;
    }

    protected ToParts xml2ToParts(Element toPartsElement) {
        if (!toPartsElement.getLocalName().equals("toParts")) {
            return null;
        }
        ToParts toParts = BPELFactory.eINSTANCE.createToParts();
        toParts.setElement(toPartsElement);
        this.saveNamespacePrefix((EObject)toParts, toPartsElement);
        for (Element e : this.getBPELChildElementsByLocalName(toPartsElement, "toPart")) {
            toParts.getChildren().add((Object)this.xml2ToPart(e));
        }
        this.xml2ExtensibleElement(toParts, toPartsElement);
        return toParts;
    }

    public MessageExchanges xml2MessageExchanges(Element messageExchangesElement) {
        if (!messageExchangesElement.getLocalName().equals("messageExchanges")) {
            return null;
        }
        MessageExchanges messageExchanges = BPELFactory.eINSTANCE.createMessageExchanges();
        messageExchanges.setElement(messageExchangesElement);
        this.saveNamespacePrefix((EObject)messageExchanges, messageExchangesElement);
        for (Element e : this.getBPELChildElementsByLocalName(messageExchangesElement, "messageExchange")) {
            messageExchanges.getChildren().add((Object)this.xml2MessageExchange(e));
        }
        this.xml2ExtensibleElement(messageExchanges, messageExchangesElement);
        return messageExchanges;
    }

    protected Extensions xml2Extensions(Element extensionsElement) {
        if (!extensionsElement.getLocalName().equals("extensions")) {
            return null;
        }
        Extensions extensions = BPELFactory.eINSTANCE.createExtensions();
        extensions.setElement(extensionsElement);
        this.saveNamespacePrefix((EObject)extensions, extensionsElement);
        for (Element e : this.getBPELChildElementsByLocalName(extensionsElement, "extension")) {
            extensions.getChildren().add((Object)this.xml2Extension(e));
        }
        this.xml2ExtensibleElement(extensions, extensionsElement);
        return extensions;
    }

    protected CompensationHandler xml2CompensationHandler(Element activityElement) {
        CompensationHandler compensationHandler = BPELFactory.eINSTANCE.createCompensationHandler();
        compensationHandler.setElement(activityElement);
        this.saveNamespacePrefix((EObject)compensationHandler, activityElement);
        compensationHandler.setActivity(this.getChildActivity(activityElement));
        return compensationHandler;
    }

    protected CorrelationSet xml2CorrelationSet(Element correlationSetElement) {
        CorrelationSet correlationSet = BPELFactory.eINSTANCE.createCorrelationSet();
        correlationSet.setElement(correlationSetElement);
        this.saveNamespacePrefix((EObject)correlationSet, correlationSetElement);
        if (correlationSetElement == null) {
            return correlationSet;
        }
        Attr name = correlationSetElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            correlationSet.setName(name.getValue());
        }
        this.setProperties(correlationSetElement, (EObject)correlationSet, "properties");
        this.xml2ExtensibleElement(correlationSet, correlationSetElement);
        return correlationSet;
    }

    protected MessageExchange xml2MessageExchange(Element messageExchangeElement) {
        if (!messageExchangeElement.getLocalName().equals("messageExchange")) {
            return null;
        }
        MessageExchange messageExchange = BPELFactory.eINSTANCE.createMessageExchange();
        messageExchange.setElement(messageExchangeElement);
        this.saveNamespacePrefix((EObject)messageExchange, messageExchangeElement);
        if (messageExchangeElement.hasAttribute("name")) {
            messageExchange.setName(messageExchangeElement.getAttribute("name"));
        }
        this.xml2ExtensibleElement(messageExchange, messageExchangeElement);
        return messageExchange;
    }

    protected Extension xml2Extension(Element extensionElement) {
        Extension extension = BPELFactory.eINSTANCE.createExtension();
        extension.setElement(extensionElement);
        this.saveNamespacePrefix((EObject)extension, extensionElement);
        if (extensionElement == null) {
            return extension;
        }
        if (extensionElement.hasAttribute("namespace")) {
            extension.setNamespace(extensionElement.getAttribute("namespace"));
        }
        if (extensionElement.hasAttribute("mustUnderstand")) {
            extension.setMustUnderstand(extensionElement.getAttribute("mustUnderstand").equals("yes"));
        }
        this.xml2ExtensibleElement(extension, extensionElement);
        return extension;
    }

    protected PartnerLink xml2PartnerLink(Element partnerLinkElement) {
        Attr partnerLinkTypeName;
        if (!partnerLinkElement.getLocalName().equals("partnerLink")) {
            return null;
        }
        PartnerLink partnerLink = BPELFactory.eINSTANCE.createPartnerLink();
        partnerLink.setElement(partnerLinkElement);
        this.saveNamespacePrefix((EObject)partnerLink, partnerLinkElement);
        if (partnerLinkElement.hasAttribute("name")) {
            partnerLink.setName(partnerLinkElement.getAttribute("name"));
        }
        if (partnerLinkElement.hasAttribute("initializePartnerRole")) {
            partnerLink.setInitializePartnerRole(partnerLinkElement.getAttribute("initializePartnerRole").equals("yes"));
        }
        if ((partnerLinkTypeName = partnerLinkElement.getAttributeNode("partnerLinkType")) != null && partnerLinkTypeName.getSpecified()) {
            QName sltQName = BPELUtils.createAttributeValue(partnerLinkElement, "partnerLinkType");
            PartnerLinkTypeProxy slt = new PartnerLinkTypeProxy(this.getResource().getURI(), sltQName);
            partnerLink.setPartnerLinkType(slt);
            if (slt != null) {
                RoleProxy role;
                partnerLink.setPartnerLinkType(slt);
                if (partnerLinkElement.hasAttribute("myRole")) {
                    role = new RoleProxy(this.getResource(), slt, partnerLinkElement.getAttribute("myRole"));
                    partnerLink.setMyRole(role);
                }
                if (partnerLinkElement.hasAttribute("partnerRole")) {
                    role = new RoleProxy(this.getResource(), slt, partnerLinkElement.getAttribute("partnerRole"));
                    partnerLink.setPartnerRole(role);
                }
            }
        }
        this.xml2ExtensibleElement(partnerLink, partnerLinkElement);
        return partnerLink;
    }

    protected Variable xml2Variable(Element variableElement) {
        Element fromElement;
        QName qName;
        if (!variableElement.getLocalName().equals("variable")) {
            return null;
        }
        Variable variable = BPELFactory.eINSTANCE.createVariable();
        variable.setElement(variableElement);
        this.saveNamespacePrefix((EObject)variable, variableElement);
        if (variableElement.hasAttribute("name")) {
            String name = variableElement.getAttribute("name");
            variable.setName(name);
        }
        if (variableElement.hasAttribute("messageType")) {
            qName = BPELUtils.createAttributeValue(variableElement, "messageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            variable.setMessageType((Message)messageType);
        }
        if (variableElement.hasAttribute("type")) {
            qName = BPELUtils.createAttributeValue(variableElement, "type");
            XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
            variable.setType((XSDTypeDefinition)type);
        }
        if (variableElement.hasAttribute("element")) {
            qName = BPELUtils.createAttributeValue(variableElement, "element");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            variable.setXSDElement((XSDElementDeclaration)element);
        }
        if ((fromElement = this.getBPELChildElementByLocalName(variableElement, "from")) != null) {
            From from = BPELFactory.eINSTANCE.createFrom();
            from.setElement(fromElement);
            this.xml2From(from, fromElement);
            variable.setFrom(from);
        }
        this.xml2ExtensibleElement(variable, variableElement);
        return variable;
    }

    protected FaultHandler xml2FaultHandler(Element faultHandlerElement) {
        String localName = faultHandlerElement.getLocalName();
        if (!localName.equals("faultHandlers") && !localName.equals("invoke")) {
            return null;
        }
        FaultHandler faultHandler = BPELFactory.eINSTANCE.createFaultHandler();
        if (localName.equals("faultHandlers")) {
            faultHandler.setElement(faultHandlerElement);
        }
        this.saveNamespacePrefix((EObject)faultHandler, faultHandlerElement);
        for (Element e : this.getBPELChildElementsByLocalName(faultHandlerElement, "catch")) {
            faultHandler.getCatch().add((Object)this.xml2Catch(e));
        }
        Element catchAllElement = this.getBPELChildElementByLocalName(faultHandlerElement, "catchAll");
        if (catchAllElement != null) {
            CatchAll catchAll = this.xml2CatchAll(catchAllElement);
            faultHandler.setCatchAll(catchAll);
        }
        if (faultHandlerElement.getLocalName().equals("faultHandlers")) {
            this.xml2ExtensibleElement(faultHandler, faultHandlerElement);
        }
        return faultHandler;
    }

    protected CatchAll xml2CatchAll(Element catchAllElement) {
        if (!catchAllElement.getLocalName().equals("catchAll")) {
            return null;
        }
        CatchAll catchAll = BPELFactory.eINSTANCE.createCatchAll();
        catchAll.setElement(catchAllElement);
        this.saveNamespacePrefix((EObject)catchAll, catchAllElement);
        for (Element e : this.getChildElements(catchAllElement)) {
            Activity activity = this.xml2Activity(e);
            if (activity == null) continue;
            catchAll.setActivity(activity);
            break;
        }
        this.xml2ExtensibleElement(catchAll, catchAllElement);
        return catchAll;
    }

    protected Catch xml2Catch(Element catchElement) {
        QName qName;
        Catch _catch = BPELFactory.eINSTANCE.createCatch();
        _catch.setElement(catchElement);
        this.saveNamespacePrefix((EObject)_catch, catchElement);
        if (catchElement == null) {
            return _catch;
        }
        if (catchElement.hasAttribute("faultName")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultName");
            _catch.setFaultName(qName);
        }
        if (catchElement.hasAttribute("faultVariable")) {
            Variable variable = BPELFactory.eINSTANCE.createVariable();
            variable.setName(catchElement.getAttribute("faultVariable"));
            _catch.setFaultVariable(variable);
        }
        if (catchElement.hasAttribute("faultMessageType")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultMessageType");
            MessageProxy messageType = new MessageProxy(this.getResource().getURI(), qName);
            _catch.setFaultMessageType((Message)messageType);
        }
        if (catchElement.hasAttribute("faultElement")) {
            qName = BPELUtils.createAttributeValue(catchElement, "faultElement");
            XSDElementDeclarationProxy element = new XSDElementDeclarationProxy(this.getResource().getURI(), qName);
            _catch.setFaultElement((XSDElementDeclaration)element);
        }
        NodeList catchElements = catchElement.getChildNodes();
        Element activityElement = null;
        if (catchElements != null && catchElements.getLength() > 0) {
            int i = 0;
            while (i < catchElements.getLength()) {
                Activity activity;
                if (catchElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(activityElement = (Element)catchElements.item(i))) != null) {
                    _catch.setActivity(activity);
                    break;
                }
                ++i;
            }
        }
        this.xml2ExtensibleElement(_catch, catchElement);
        return _catch;
    }

    public Activity xml2Activity(Element activityElement) {
        Activity activity = null;
        boolean checkExtensibility = true;
        if (!BPELUtils.isBPELElement(activityElement)) {
            return null;
        }
        String localName = activityElement.getLocalName();
        if (localName.equals("process")) {
            activity = this.getChildActivity(activityElement);
            checkExtensibility = false;
        } else if (localName.equals("receive")) {
            activity = this.xml2Receive(activityElement);
        } else if (localName.equals("reply")) {
            activity = this.xml2Reply(activityElement);
        } else if (localName.equals("invoke")) {
            activity = this.xml2Invoke(activityElement);
        } else if (localName.equals("assign")) {
            activity = this.xml2Assign(activityElement);
        } else if (localName.equals("throw")) {
            activity = this.xml2Throw(activityElement);
        } else if (localName.equals("exit")) {
            activity = this.xml2Exit(activityElement);
        } else if (localName.equals("wait")) {
            activity = this.xml2Wait(activityElement);
        } else if (localName.equals("empty")) {
            activity = this.xml2Empty(activityElement);
        } else if (localName.equals("sequence")) {
            activity = this.xml2Sequence(activityElement);
        } else if (localName.equals("if")) {
            activity = this.xml2If(activityElement);
        } else if (localName.equals("while")) {
            activity = this.xml2While(activityElement);
        } else if (localName.equals("pick")) {
            activity = this.xml2Pick(activityElement);
        } else if (localName.equals("flow")) {
            activity = this.xml2Flow(activityElement);
        } else if (localName.equals("scope")) {
            activity = this.xml2Scope(activityElement);
        } else if (localName.equals("compensate")) {
            activity = this.xml2Compensate(activityElement);
        } else if (localName.equals("compensateScope")) {
            activity = this.xml2CompensateScope(activityElement);
        } else if (localName.equals("rethrow")) {
            activity = this.xml2Rethrow(activityElement);
        } else {
            if (localName.equals("extensionActivity")) {
                activity = this.xml2ExtensionActivity(activityElement);
                return activity;
            }
            if (localName.equals("opaqueActivity")) {
                activity = this.xml2OpaqueActivity(activityElement);
            } else if (localName.equals("forEach")) {
                activity = this.xml2ForEach(activityElement);
            } else if (localName.equals("repeatUntil")) {
                activity = this.xml2RepeatUntil(activityElement);
            } else if (localName.equals("validate")) {
                activity = this.xml2Validate(activityElement);
            } else {
                return null;
            }
        }
        this.setStandardElements(activityElement, activity);
        if (checkExtensibility) {
            this.xml2ExtensibleElement(activity, activityElement);
            this.saveNamespacePrefix((EObject)activity, activityElement);
        }
        return activity;
    }

    protected void setStandardElements(Element activityElement, Activity activity) {
        Element sourcesElement;
        Element targetsElement = this.getBPELChildElementByLocalName(activityElement, "targets");
        if (targetsElement != null) {
            activity.setTargets(this.xml2Targets(targetsElement));
        }
        if ((sourcesElement = this.getBPELChildElementByLocalName(activityElement, "sources")) != null) {
            activity.setSources(this.xml2Sources(sourcesElement));
        }
    }

    protected Targets xml2Targets(Element targetsElement) {
        Targets targets = BPELFactory.eINSTANCE.createTargets();
        targets.setElement(targetsElement);
        for (Element e : this.getBPELChildElementsByLocalName(targetsElement, "target")) {
            targets.getChildren().add((Object)this.xml2Target(e));
        }
        Element joinConditionElement = this.getBPELChildElementByLocalName(targetsElement, "joinCondition");
        if (joinConditionElement != null) {
            targets.setJoinCondition(this.xml2Condition(joinConditionElement));
        }
        this.xml2ExtensibleElement(targets, targetsElement);
        return targets;
    }

    protected Target xml2Target(Element targetElement) {
        final Target target = BPELFactory.eINSTANCE.createTarget();
        target.setElement(targetElement);
        this.saveNamespacePrefix((EObject)target, targetElement);
        this.xml2ExtensibleElement(target, targetElement);
        if (targetElement.hasAttribute("linkName")) {
            final String linkName = targetElement.getAttribute("linkName");
            this.fPass2Runnables.add(new Runnable(){

                @Override
                public void run() {
                    Link link = BPELReader.getLink(target.getActivity(), linkName);
                    if (link != null) {
                        target.setLink(link);
                    } else {
                        target.setLink(new LinkProxy(BPELReader.this.getResource().getURI(), linkName));
                    }
                }
            });
        }
        return target;
    }

    protected Sources xml2Sources(Element sourcesElement) {
        Sources sources = BPELFactory.eINSTANCE.createSources();
        sources.setElement(sourcesElement);
        for (Element e : this.getBPELChildElementsByLocalName(sourcesElement, "source")) {
            sources.getChildren().add((Object)this.xml2Source(e));
        }
        this.xml2ExtensibleElement(sources, sourcesElement);
        return sources;
    }

    protected Source xml2Source(Element sourceElement) {
        final String linkName = sourceElement.getAttribute("linkName");
        final Source source = BPELFactory.eINSTANCE.createSource();
        source.setElement(sourceElement);
        this.saveNamespacePrefix((EObject)source, sourceElement);
        Element transitionConditionElement = this.getBPELChildElementByLocalName(sourceElement, "transitionCondition");
        if (transitionConditionElement != null) {
            Condition transitionCondition = this.xml2Condition(transitionConditionElement);
            source.setTransitionCondition(transitionCondition);
        }
        this.xml2ExtensibleElement(source, sourceElement);
        this.fPass2Runnables.add(new Runnable(){

            @Override
            public void run() {
                Link link = BPELReader.getLink(source.getActivity(), linkName);
                if (link != null) {
                    source.setLink(link);
                } else {
                    source.setLink(new LinkProxy(BPELReader.this.getResource().getURI(), linkName));
                }
            }
        });
        return source;
    }

    protected Activity xml2Scope(Element scopeElement) {
        Element faultHandlerElement;
        Element messageExchangesElement;
        Element partnerLinksElement;
        Element correlationSetsElement;
        Element variablesElement;
        Attr exitOnStandardFault;
        Attr isolated;
        Scope scope = BPELFactory.eINSTANCE.createScope();
        scope.setElement(scopeElement);
        Attr name = scopeElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            scope.setName(name.getValue());
        }
        if ((isolated = scopeElement.getAttributeNode("isolated")) != null && isolated.getSpecified()) {
            scope.setIsolated(isolated.getValue().equals("yes"));
        }
        if ((exitOnStandardFault = scopeElement.getAttributeNode("exitOnStandardFault")) != null && exitOnStandardFault.getSpecified()) {
            scope.setExitOnStandardFault(exitOnStandardFault.getValue().equals("yes"));
        }
        if ((variablesElement = this.getBPELChildElementByLocalName(scopeElement, "variables")) != null) {
            Variables variables = this.xml2Variables(variablesElement);
            scope.setVariables(variables);
        }
        if ((correlationSetsElement = this.getBPELChildElementByLocalName(scopeElement, "correlationSets")) != null) {
            CorrelationSets correlationSets = this.xml2CorrelationSets(correlationSetsElement);
            scope.setCorrelationSets(correlationSets);
        }
        if ((partnerLinksElement = this.getBPELChildElementByLocalName(scopeElement, "partnerLinks")) != null) {
            PartnerLinks partnerLinks = this.xml2PartnerLinks(partnerLinksElement);
            scope.setPartnerLinks(partnerLinks);
        }
        if ((messageExchangesElement = this.getBPELChildElementByLocalName(scopeElement, "messageExchanges")) != null) {
            MessageExchanges messageExchanges = this.xml2MessageExchanges(messageExchangesElement);
            scope.setMessageExchanges(messageExchanges);
        }
        if ((faultHandlerElement = this.getBPELChildElementByLocalName(scopeElement, "faultHandlers")) != null) {
            FaultHandler faultHandler = this.xml2FaultHandler(faultHandlerElement);
            scope.setFaultHandlers(faultHandler);
        }
        this.setCompensationHandler(scopeElement, (EObject)scope);
        Element terminationHandlerElement = this.getBPELChildElementByLocalName(scopeElement, "terminationHandler");
        if (terminationHandlerElement != null) {
            TerminationHandler terminationHandler = this.xml2TerminationHandler(terminationHandlerElement);
            scope.setTerminationHandler(terminationHandler);
        }
        this.setEventHandler(scopeElement, scope);
        this.setStandardAttributes(scopeElement, scope);
        NodeList scopeElements = scopeElement.getChildNodes();
        Element activityElement = null;
        if (scopeElements != null && scopeElements.getLength() > 0) {
            int i = 0;
            while (i < scopeElements.getLength()) {
                Activity activity;
                if (scopeElements.item(i).getNodeType() == 1 && !(activityElement = (Element)scopeElements.item(i)).getLocalName().equals("faultHandlers") && !activityElement.getLocalName().equals("compensationHandler") && (activity = this.xml2Activity(activityElement)) != null) {
                    scope.setActivity(activity);
                    break;
                }
                ++i;
            }
        }
        return scope;
    }

    protected Activity xml2Flow(Element flowElement) {
        Element completionConditionElement;
        Element linksElement;
        Flow flow = BPELFactory.eINSTANCE.createFlow();
        flow.setElement(flowElement);
        Attr name = flowElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            flow.setName(name.getValue());
        }
        if ((linksElement = this.getBPELChildElementByLocalName(flowElement, "links")) != null) {
            Links links = this.xml2Links(linksElement);
            flow.setLinks(links);
        }
        if ((completionConditionElement = this.getBPELChildElementByLocalName(flowElement, "completionCondition")) != null) {
            CompletionCondition completionCondition = this.xml2CompletionCondition(completionConditionElement);
            flow.setCompletionCondition(completionCondition);
        }
        this.setStandardAttributes(flowElement, flow);
        NodeList flowElements = flowElement.getChildNodes();
        Element activityElement = null;
        if (flowElements != null && flowElements.getLength() > 0) {
            int i = 0;
            while (i < flowElements.getLength()) {
                Activity activity;
                if (flowElements.item(i).getNodeType() == 1 && !((Element)flowElements.item(i)).getLocalName().equals("links") && (activity = this.xml2Activity(activityElement = (Element)flowElements.item(i))) != null) {
                    flow.getActivities().add((Object)activity);
                }
                ++i;
            }
        }
        return flow;
    }

    protected Links xml2Links(Element linksElement) {
        if (!linksElement.getLocalName().equals("links")) {
            return null;
        }
        Links links = BPELFactory.eINSTANCE.createLinks();
        links.setElement(linksElement);
        this.saveNamespacePrefix((EObject)links, linksElement);
        for (Element e : this.getBPELChildElementsByLocalName(linksElement, "link")) {
            links.getChildren().add((Object)this.xml2Link(e));
        }
        this.xml2ExtensibleElement(links, linksElement);
        return links;
    }

    protected Link xml2Link(Element linkElement) {
        Link link = BPELFactory.eINSTANCE.createLink();
        link.setElement(linkElement);
        this.saveNamespacePrefix((EObject)link, linkElement);
        Attr name = linkElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            link.setName(name.getValue());
        }
        this.xml2ExtensibleElement(link, linkElement);
        return link;
    }

    protected Activity xml2Pick(Element pickElement) {
        Attr createInstance;
        Pick pick = BPELFactory.eINSTANCE.createPick();
        pick.setElement(pickElement);
        Attr name = pickElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            pick.setName(name.getValue());
        }
        if ((createInstance = pickElement.getAttributeNode("createInstance")) != null && createInstance.getSpecified()) {
            pick.setCreateInstance(Boolean.valueOf(createInstance.getValue().equals("yes") ? "True" : "False"));
        }
        NodeList pickElements = pickElement.getChildNodes();
        Element pickInstanceElement = null;
        if (pickElements != null && pickElements.getLength() > 0) {
            int i = 0;
            while (i < pickElements.getLength()) {
                if (pickElements.item(i).getNodeType() == 1) {
                    pickInstanceElement = (Element)pickElements.item(i);
                    if (pickInstanceElement.getLocalName().equals("onAlarm")) {
                        OnAlarm onAlarm = this.xml2OnAlarm(pickInstanceElement);
                        pick.getAlarm().add((Object)onAlarm);
                    } else if (pickInstanceElement.getLocalName().equals("onMessage")) {
                        OnMessage onMessage = this.xml2OnMessage(pickInstanceElement);
                        pick.getMessages().add((Object)onMessage);
                    }
                }
                ++i;
            }
        }
        this.setStandardAttributes(pickElement, pick);
        return pick;
    }

    protected EventHandler xml2EventHandler(Element eventHandlerElement) {
        EventHandler eventHandler = BPELFactory.eINSTANCE.createEventHandler();
        eventHandler.setElement(eventHandlerElement);
        this.saveNamespacePrefix((EObject)eventHandler, eventHandlerElement);
        NodeList eventHandlerElements = eventHandlerElement.getChildNodes();
        Element eventHandlerInstanceElement = null;
        if (eventHandlerElements != null && eventHandlerElements.getLength() > 0) {
            int i = 0;
            while (i < eventHandlerElements.getLength()) {
                if (eventHandlerElements.item(i).getNodeType() == 1) {
                    eventHandlerInstanceElement = (Element)eventHandlerElements.item(i);
                    if (eventHandlerInstanceElement.getLocalName().equals("onAlarm")) {
                        OnAlarm onAlarm = this.xml2OnAlarm(eventHandlerInstanceElement);
                        eventHandler.getAlarm().add((Object)onAlarm);
                    } else if (eventHandlerInstanceElement.getLocalName().equals("onEvent")) {
                        OnEvent onEvent = this.xml2OnEvent(eventHandlerInstanceElement);
                        eventHandler.getEvents().add((Object)onEvent);
                    }
                }
                ++i;
            }
        }
        this.xml2ExtensibleElement(eventHandler, eventHandlerElement);
        return eventHandler;
    }

    protected OnMessage xml2OnMessage(Element onMessageElement) {
        OnMessage onMessage = BPELFactory.eINSTANCE.createOnMessage();
        onMessage.setElement(onMessageElement);
        this.saveNamespacePrefix((EObject)onMessage, onMessageElement);
        this.setOperationParmsOnMessage(onMessageElement, onMessage);
        onMessage.setActivity(this.getChildActivity(onMessageElement));
        Element fromPartsElement = this.getBPELChildElementByLocalName(onMessageElement, "fromParts");
        if (fromPartsElement != null) {
            FromParts fromParts = this.xml2FromParts(fromPartsElement);
            onMessage.setFromParts(fromParts);
        }
        this.setMessageExchange(onMessageElement, (EObject)onMessage, BPELPackage.eINSTANCE.getOnMessage_MessageExchange());
        this.xml2ExtensibleElement(onMessage, onMessageElement);
        return onMessage;
    }

    protected OnEvent xml2OnEvent(Element onEventElement) {
        Element correlationSetsElement;
        OnEvent onEvent = BPELFactory.eINSTANCE.createOnEvent();
        onEvent.setElement(onEventElement);
        this.saveNamespacePrefix((EObject)onEvent, onEventElement);
        this.setOperationParmsOnEvent(onEventElement, onEvent);
        onEvent.setActivity(this.getChildActivity(onEventElement));
        Element fromPartsElement = this.getBPELChildElementByLocalName(onEventElement, "fromParts");
        if (fromPartsElement != null) {
            FromParts fromParts = this.xml2FromParts(fromPartsElement);
            onEvent.setFromParts(fromParts);
        }
        if ((correlationSetsElement = this.getBPELChildElementByLocalName(onEventElement, "correlationSets")) != null) {
            onEvent.setCorrelationSets(this.xml2CorrelationSets(correlationSetsElement));
        }
        this.setMessageExchange(onEventElement, (EObject)onEvent, BPELPackage.eINSTANCE.getOnEvent_MessageExchange());
        this.xml2ExtensibleElement(onEvent, onEventElement);
        return onEvent;
    }

    protected OnAlarm xml2OnAlarm(Element onAlarmElement) {
        Element repeatEveryElement;
        Element untilElement;
        OnAlarm onAlarm = BPELFactory.eINSTANCE.createOnAlarm();
        onAlarm.setElement(onAlarmElement);
        this.saveNamespacePrefix((EObject)onAlarm, onAlarmElement);
        Element forElement = this.getBPELChildElementByLocalName(onAlarmElement, "for");
        if (forElement != null) {
            Expression expression = this.xml2Expression(forElement);
            onAlarm.setFor(expression);
        }
        if ((untilElement = this.getBPELChildElementByLocalName(onAlarmElement, "until")) != null) {
            Expression expression = this.xml2Expression(untilElement);
            onAlarm.setUntil(expression);
        }
        if ((repeatEveryElement = this.getBPELChildElementByLocalName(onAlarmElement, "repeatEvery")) != null) {
            Expression expression = this.xml2Expression(repeatEveryElement);
            onAlarm.setRepeatEvery(expression);
        }
        onAlarm.setActivity(this.getChildActivity(onAlarmElement));
        this.xml2ExtensibleElement(onAlarm, onAlarmElement);
        return onAlarm;
    }

    protected Activity xml2While(Element whileElement) {
        While _while = BPELFactory.eINSTANCE.createWhile();
        _while.setElement(whileElement);
        Element conditionElement = this.getBPELChildElementByLocalName(whileElement, "condition");
        if (conditionElement != null) {
            Condition condition = this.xml2Condition(conditionElement);
            _while.setCondition(condition);
        }
        NodeList whileElements = whileElement.getChildNodes();
        Element activityElement = null;
        if (whileElements != null && whileElements.getLength() > 0) {
            int i = 0;
            while (i < whileElements.getLength()) {
                Activity activity;
                if (whileElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(activityElement = (Element)whileElements.item(i))) != null) {
                    _while.setActivity(activity);
                    break;
                }
                ++i;
            }
        }
        this.setStandardAttributes(whileElement, _while);
        return _while;
    }

    protected TerminationHandler xml2TerminationHandler(Element terminationHandlerElement) {
        TerminationHandler terminationHandler = BPELFactory.eINSTANCE.createTerminationHandler();
        terminationHandler.setElement(terminationHandlerElement);
        this.saveNamespacePrefix((EObject)terminationHandler, terminationHandlerElement);
        terminationHandler.setActivity(this.getChildActivity(terminationHandlerElement));
        this.xml2ExtensibleElement(terminationHandler, terminationHandlerElement);
        return terminationHandler;
    }

    protected Activity xml2If(Element ifElement) {
        Element conditionElement;
        If _if = BPELFactory.eINSTANCE.createIf();
        _if.setElement(ifElement);
        Activity activity = this.getChildActivity(ifElement);
        if (activity != null) {
            _if.setActivity(activity);
        }
        if ((conditionElement = this.getBPELChildElementByLocalName(ifElement, "condition")) != null) {
            Condition condition = this.xml2Condition(conditionElement);
            _if.setCondition(condition);
        }
        for (Element e : this.getBPELChildElementsByLocalName(ifElement, "elseif")) {
            _if.getElseIf().add((Object)this.xml2ElseIf(e));
        }
        Element elseElement = this.getBPELChildElementByLocalName(ifElement, "else");
        if (elseElement != null) {
            Else _else = this.xml2Else(elseElement);
            _if.setElse(_else);
        }
        this.setStandardAttributes(ifElement, _if);
        return _if;
    }

    protected ElseIf xml2ElseIf(Element elseIfElement) {
        Activity activity;
        ElseIf elseIf = BPELFactory.eINSTANCE.createElseIf();
        elseIf.setElement(elseIfElement);
        this.saveNamespacePrefix((EObject)elseIf, elseIfElement);
        Element conditionElement = this.getBPELChildElementByLocalName(elseIfElement, "condition");
        if (conditionElement != null) {
            Condition condition = this.xml2Condition(conditionElement);
            elseIf.setCondition(condition);
        }
        if ((activity = this.getChildActivity(elseIfElement)) != null) {
            elseIf.setActivity(activity);
        }
        return elseIf;
    }

    protected Condition xml2Condition(Element conditionElement) {
        Condition condition = BPELFactory.eINSTANCE.createCondition();
        condition.setElement(conditionElement);
        this.xml2Expression(conditionElement, condition);
        return condition;
    }

    protected Expression xml2Expression(Element expressionElement, Expression expression) {
        String data;
        this.saveNamespacePrefix((EObject)expression, expressionElement);
        if (expressionElement == null) {
            return expression;
        }
        if (expressionElement.hasAttribute("expressionLanguage")) {
            expression.setExpressionLanguage(expressionElement.getAttribute("expressionLanguage"));
        }
        if (expressionElement.hasAttribute("opaque")) {
            expression.setOpaque(expressionElement.getAttribute("opaque").equals("yes"));
        }
        if ((data = this.getText(expressionElement)) != null) {
            expression.setBody(data);
        }
        return expression;
    }

    protected Expression xml2Expression(Element expressionElement) {
        Expression expression = BPELFactory.eINSTANCE.createExpression();
        expression.setElement(expressionElement);
        return this.xml2Expression(expressionElement, expression);
    }

    protected Else xml2Else(Element elseElement) {
        Else _else = BPELFactory.eINSTANCE.createElse();
        _else.setElement(elseElement);
        this.saveNamespacePrefix((EObject)_else, elseElement);
        Activity activity = this.getChildActivity(elseElement);
        _else.setActivity(activity);
        return _else;
    }

    protected Activity xml2Sequence(Element sequenceElement) {
        Sequence sequence = BPELFactory.eINSTANCE.createSequence();
        sequence.setElement(sequenceElement);
        Attr name = sequenceElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            sequence.setName(name.getValue());
        }
        NodeList sequenceElements = sequenceElement.getChildNodes();
        Element activityElement = null;
        if (sequenceElements != null && sequenceElements.getLength() > 0) {
            int i = 0;
            while (i < sequenceElements.getLength()) {
                Activity activity;
                if (sequenceElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(activityElement = (Element)sequenceElements.item(i))) != null) {
                    sequence.getActivities().add((Object)activity);
                }
                ++i;
            }
        }
        this.setStandardAttributes(sequenceElement, sequence);
        return sequence;
    }

    protected Activity xml2Empty(Element emptyElement) {
        Empty empty = BPELFactory.eINSTANCE.createEmpty();
        empty.setElement(emptyElement);
        this.setStandardAttributes(emptyElement, empty);
        return empty;
    }

    protected Activity xml2OpaqueActivity(Element opaqueActivityElement) {
        OpaqueActivity opaqueActivity = BPELFactory.eINSTANCE.createOpaqueActivity();
        opaqueActivity.setElement(opaqueActivityElement);
        this.setStandardAttributes(opaqueActivityElement, opaqueActivity);
        return opaqueActivity;
    }

    protected Activity xml2Validate(Element validateElement) {
        final Validate validate = BPELFactory.eINSTANCE.createValidate();
        validate.setElement(validateElement);
        this.setStandardAttributes(validateElement, validate);
        if (validateElement.hasAttribute("variables")) {
            String variables = validateElement.getAttribute("variables");
            StringTokenizer st = new StringTokenizer(variables);
            while (st.hasMoreTokens()) {
                final String variableName = st.nextToken();
                this.fPass2Runnables.add(new Runnable(){

                    @Override
                    public void run() {
                        Variable targetVariable = BPELReader.getVariable((EObject)validate, variableName);
                        if (targetVariable == null) {
                            targetVariable = new VariableProxy(BPELReader.this.getResource().getURI(), variableName);
                        }
                        validate.getVariables().add((Object)targetVariable);
                    }
                });
            }
        }
        return validate;
    }

    protected Activity xml2Rethrow(Element rethrowElement) {
        Rethrow rethrow = BPELFactory.eINSTANCE.createRethrow();
        rethrow.setElement(rethrowElement);
        this.setStandardAttributes(rethrowElement, rethrow);
        return rethrow;
    }

    protected Activity xml2ExtensionActivity(Element extensionActivityElement) {
        Activity extensionActivity = BPELFactory.eINSTANCE.createExtensionActivity();
        List<Element> nodeList = this.getChildElements(extensionActivityElement);
        if (nodeList.size() == 1) {
            final Element child = nodeList.get(0);
            String localName = child.getLocalName();
            String namespace = child.getNamespaceURI();
            final QName qname = new QName(namespace, localName);
            final BPELActivityDeserializer deserializer = this.extensionRegistry.getActivityDeserializer(qname);
            if (deserializer != null) {
                final Map<String, String> nsMap = this.getAllNamespacesForElement(child);
                extensionActivity = deserializer.unmarshall(qname, child, extensionActivity, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
                this.setStandardAttributes(child, extensionActivity);
                this.setStandardElements(child, extensionActivity);
                extensionActivity.setElement(extensionActivityElement);
                final Activity ea = extensionActivity;
                this.fPass2Runnables.add(new Runnable(){

                    @Override
                    public void run() {
                        deserializer.unmarshall(qname, child, ea, BPELReader.this.process, nsMap, BPELReader.this.extensionRegistry, BPELReader.this.getResource().getURI(), BPELReader.this);
                    }
                });
                return extensionActivity;
            }
        }
        this.setStandardAttributes(extensionActivityElement, extensionActivity);
        this.setStandardElements(extensionActivityElement, extensionActivity);
        extensionActivity.setElement(extensionActivityElement);
        return extensionActivity;
    }

    protected Activity xml2Wait(Element waitElement) {
        Element untilElement;
        Element forElement;
        Wait wait = BPELFactory.eINSTANCE.createWait();
        wait.setElement(waitElement);
        Attr name = waitElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            wait.setName(name.getValue());
        }
        if ((forElement = this.getBPELChildElementByLocalName(waitElement, "for")) != null) {
            Expression expression = this.xml2Expression(forElement);
            wait.setFor(expression);
        }
        if ((untilElement = this.getBPELChildElementByLocalName(waitElement, "until")) != null) {
            Expression expression = this.xml2Expression(untilElement);
            wait.setUntil(expression);
        }
        this.setStandardAttributes(waitElement, wait);
        return wait;
    }

    protected Activity xml2Exit(Element exitElement) {
        Exit exit = BPELFactory.eINSTANCE.createExit();
        exit.setElement(exitElement);
        Attr name = exitElement.getAttributeNode("name");
        if (name != null && name.getSpecified()) {
            exit.setName(name.getValue());
        }
        this.setStandardAttributes(exitElement, exit);
        return exit;
    }

    protected Activity xml2Throw(Element throwElement) {
        Throw _throw = BPELFactory.eINSTANCE.createThrow();
        _throw.setElement(throwElement);
        if (throwElement.hasAttribute("name")) {
            _throw.setName(throwElement.getAttribute("name"));
        }
        if (throwElement.hasAttribute("faultName")) {
            QName qName = BPELUtils.createAttributeValue(throwElement, "faultName");
            _throw.setFaultName(qName);
        }
        this.setVariable(throwElement, (EObject)_throw, "faultVariable", BPELPackage.eINSTANCE.getThrow_FaultVariable());
        this.setStandardAttributes(throwElement, _throw);
        return _throw;
    }

    protected Activity xml2Assign(Element assignElement) {
        Assign assign = BPELFactory.eINSTANCE.createAssign();
        assign.setElement(assignElement);
        if (assignElement.hasAttribute("validate")) {
            assign.setValidate(assignElement.getAttribute("validate").equals("yes"));
        }
        for (Element copyElement : this.getBPELChildElementsByLocalName(assignElement, "copy")) {
            assign.getCopy().add((Object)this.xml2Copy(copyElement));
        }
        this.setStandardAttributes(assignElement, assign);
        return assign;
    }

    protected Copy xml2Copy(Element copyElement) {
        Element toElement;
        Copy copy = BPELFactory.eINSTANCE.createCopy();
        copy.setElement(copyElement);
        this.saveNamespacePrefix((EObject)copy, copyElement);
        Element fromElement = this.getBPELChildElementByLocalName(copyElement, "from");
        if (fromElement != null) {
            From from = BPELFactory.eINSTANCE.createFrom();
            from.setElement(fromElement);
            this.xml2From(from, fromElement);
            copy.setFrom(from);
        }
        if ((toElement = this.getBPELChildElementByLocalName(copyElement, "to")) != null) {
            To to = BPELFactory.eINSTANCE.createTo();
            to.setElement(toElement);
            this.xml2To(to, toElement);
            copy.setTo(to);
        }
        if (copyElement.hasAttribute("keepSrcElementName")) {
            copy.setKeepSrcElementName(copyElement.getAttribute("keepSrcElementName").equals("yes"));
        }
        if (copyElement.hasAttribute("ignoreMissingFromData")) {
            copy.setIgnoreMissingFromData(copyElement.getAttribute("ignoreMissingFromData").equals("yes"));
        }
        this.xml2ExtensibleElement(copy, copyElement);
        return copy;
    }

    protected ToPart xml2ToPart(Element toPartElement) {
        ToPart toPart = BPELFactory.eINSTANCE.createToPart();
        toPart.setElement(toPartElement);
        this.saveNamespacePrefix((EObject)toPart, toPartElement);
        Attr part = toPartElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = toPartElement.getAttribute("part");
            ((ToPartImpl)toPart).setPartName(partAttr);
        }
        this.setVariable(toPartElement, (EObject)toPart, "fromVariable", BPELPackage.eINSTANCE.getToPart_FromVariable());
        return toPart;
    }

    protected FromPart xml2FromPart(Element fromPartElement) {
        FromPart fromPart = BPELFactory.eINSTANCE.createFromPart();
        fromPart.setElement(fromPartElement);
        this.saveNamespacePrefix((EObject)fromPart, fromPartElement);
        Attr part = fromPartElement.getAttributeNode("part");
        if (part != null && part.getSpecified()) {
            String partAttr = fromPartElement.getAttribute("part");
            ((FromPartImpl)fromPart).setPartName(partAttr);
        }
        this.setVariable(fromPartElement, (EObject)fromPart, "toVariable", BPELPackage.eINSTANCE.getFromPart_ToVariable());
        return fromPart;
    }

    protected To xml2To(To to, Element toElement) {
        Element queryElement;
        Attr property;
        Attr partnerLink;
        Attr part;
        this.saveNamespacePrefix(to, toElement);
        Attr variable = toElement.getAttributeNode("variable");
        if (variable != null && variable.getSpecified()) {
            this.setVariable(toElement, to, "variable", BPELPackage.eINSTANCE.getAbstractAssignBound_Variable());
        }
        if ((part = toElement.getAttributeNode("part")) != null && part.getSpecified()) {
            String partAttr = toElement.getAttribute("part");
            ((ToImpl)to).setPartName(partAttr);
        }
        if ((partnerLink = toElement.getAttributeNode("partnerLink")) != null && partnerLink.getSpecified()) {
            this.setPartnerLink(toElement, to, BPELPackage.eINSTANCE.getAbstractAssignBound_PartnerLink());
        }
        if ((property = toElement.getAttributeNode("property")) != null && property.getSpecified()) {
            this.setProperties(toElement, to, "property");
        }
        if ((queryElement = this.getBPELChildElementByLocalName(toElement, "query")) != null) {
            String data;
            Query queryObject = BPELFactory.eINSTANCE.createQuery();
            queryObject.setElement(queryElement);
            to.setQuery(queryObject);
            if (queryElement.hasAttribute("queryLanguage")) {
                String queryLanguage = queryElement.getAttribute("queryLanguage");
                queryObject.setQueryLanguage(queryLanguage);
            }
            if ((data = this.getText(queryElement)) != null) {
                queryObject.setValue(data);
            }
        } else if (partnerLink == null && variable == null) {
            String data;
            Expression expressionObject = BPELFactory.eINSTANCE.createExpression();
            to.setExpression(expressionObject);
            if (toElement.hasAttribute("expressionLanguage")) {
                expressionObject.setExpressionLanguage(toElement.getAttribute("expressionLanguage"));
            }
            if ((data = this.getText(toElement)) != null) {
                expressionObject.setBody(data);
            }
        }
        return to;
    }

    protected From xml2From(From from, Element fromElement) {
        Attr opaque;
        Attr endpointReference;
        Element queryElement;
        Attr property;
        Attr partnerLink;
        Attr part;
        this.saveNamespacePrefix(from, fromElement);
        Attr variable = fromElement.getAttributeNode("variable");
        if (variable != null && variable.getSpecified()) {
            this.setVariable(fromElement, from, "variable", BPELPackage.eINSTANCE.getAbstractAssignBound_Variable());
        }
        if ((part = fromElement.getAttributeNode("part")) != null && part.getSpecified()) {
            String partAttr = fromElement.getAttribute("part");
            ((FromImpl)from).setPartName(partAttr);
        }
        if ((partnerLink = fromElement.getAttributeNode("partnerLink")) != null && partnerLink.getSpecified()) {
            this.setPartnerLink(fromElement, from, BPELPackage.eINSTANCE.getAbstractAssignBound_PartnerLink());
        }
        if ((property = fromElement.getAttributeNode("property")) != null && property.getSpecified()) {
            this.setProperties(fromElement, from, "property");
        }
        if ((queryElement = this.getBPELChildElementByLocalName(fromElement, "query")) != null) {
            String data;
            Query queryObject = BPELFactory.eINSTANCE.createQuery();
            queryObject.setElement(queryElement);
            from.setQuery(queryObject);
            if (queryElement.hasAttribute("queryLanguage")) {
                String queryLanguage = queryElement.getAttribute("queryLanguage");
                queryObject.setQueryLanguage(queryLanguage);
            }
            if ((data = this.getText(queryElement)) != null) {
                queryObject.setValue(data);
            }
        }
        if ((endpointReference = fromElement.getAttributeNode("endpointReference")) != null && endpointReference.getSpecified()) {
            from.setEndpointReference(EndpointReferenceRole.get(endpointReference.getValue()));
        }
        Element serviceRefElement = this.getBPELChildElementByLocalName(fromElement, "service-ref");
        Element literalElement = this.getBPELChildElementByLocalName(fromElement, "literal");
        if (serviceRefElement != null) {
            String data;
            ServiceRef serviceRef = BPELFactory.eINSTANCE.createServiceRef();
            from.setServiceRef(serviceRef);
            if (serviceRefElement.hasAttribute("reference-scheme")) {
                String scheme = serviceRefElement.getAttribute("reference-scheme");
                serviceRef.setReferenceScheme(scheme);
            }
            Node candidateChild = null;
            NodeList nodeList = serviceRefElement.getChildNodes();
            int length = nodeList.getLength();
            int i = 0;
            while (i < length) {
                Node child = nodeList.item(i);
                if (child.getNodeType() == 1) {
                    candidateChild = child;
                    break;
                }
                ++i;
            }
            if (candidateChild == null) {
                candidateChild = serviceRefElement.getFirstChild();
            }
            if ((data = this.getText(candidateChild)) == null) {
                if (candidateChild != null && candidateChild.getNodeType() == 1) {
                    Element childElement = (Element)candidateChild;
                    QName qname = new QName(childElement.getNamespaceURI(), childElement.getLocalName());
                    BPELExtensionDeserializer deserializer = null;
                    try {
                        deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
                    }
                    catch (WSDLException wSDLException) {
                        // empty catch block
                    }
                    if (deserializer != null && !(deserializer instanceof BPELUnknownExtensionDeserializer)) {
                        try {
                            Map<String, String> nsMap = this.getAllNamespacesForElement(serviceRefElement);
                            ExtensibilityElement extensibilityElement = deserializer.unmarshall(BPELExtensibleElement.class, qname, childElement, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
                            serviceRef.setValue(extensibilityElement);
                        }
                        catch (WSDLException e) {
                            throw new WrappedException((Exception)((Object)e));
                        }
                    } else {
                        ServiceReferenceDeserializer referenceDeserializer = this.extensionRegistry.getServiceReferenceDeserializer(serviceRef.getReferenceScheme());
                        if (referenceDeserializer != null) {
                            Object serviceReference = referenceDeserializer.unmarshall(childElement, this.process);
                            serviceRef.setValue(serviceReference);
                        }
                    }
                }
            } else {
                serviceRef.setValue(data);
            }
        }
        if (literalElement != null) {
            StringBuilder elementData = new StringBuilder(256);
            NodeList nl = literalElement.getChildNodes();
            int i = 0;
            block9: while (i < nl.getLength()) {
                Node n = nl.item(i);
                switch (n.getNodeType()) {
                    case 1: {
                        elementData.setLength(0);
                        elementData.append(BPELUtils.elementToString((Element)n));
                        break block9;
                    }
                    case 3: 
                    case 4: {
                        elementData.append(this.getText(n));
                    }
                    default: {
                        ++i;
                    }
                }
            }
            from.setUnsafeLiteral(Boolean.FALSE);
            String elementDataFinal = elementData.toString();
            if (!BPELReader.isEmptyOrWhitespace(elementDataFinal)) {
                from.setUnsafeLiteral(Boolean.TRUE);
                from.setLiteral(elementDataFinal);
            }
        } else {
            String data;
            Expression expressionObject = BPELFactory.eINSTANCE.createExpression();
            from.setExpression(expressionObject);
            if (fromElement.hasAttribute("expressionLanguage")) {
                expressionObject.setExpressionLanguage(fromElement.getAttribute("expressionLanguage"));
            }
            if ((data = this.getText(fromElement)) != null) {
                expressionObject.setBody(data);
            }
        }
        if ((opaque = fromElement.getAttributeNode("opaque")) != null && opaque.getSpecified()) {
            from.setOpaque(opaque.getValue().equals("yes"));
        }
        if (fromElement.hasAttribute("xsi:type")) {
            QName qName = BPELUtils.createAttributeValue(fromElement, "xsi:type");
            XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
            from.setType((XSDTypeDefinition)type);
        }
        return from;
    }

    protected Import xml2Import(Element importElement) {
        if (!importElement.getLocalName().equals("import")) {
            return null;
        }
        Import imp = BPELFactory.eINSTANCE.createImport();
        imp.setElement(importElement);
        this.saveNamespacePrefix((EObject)imp, importElement);
        if (importElement.hasAttribute("namespace")) {
            imp.setNamespace(importElement.getAttribute("namespace"));
        }
        if (importElement.hasAttribute("location")) {
            imp.setLocation(importElement.getAttribute("location"));
        }
        if (importElement.hasAttribute("importType")) {
            imp.setImportType(importElement.getAttribute("importType"));
        }
        return imp;
    }

    protected Activity xml2Invoke(Element invokeElement) {
        Element fromPartsElement;
        Element toPartsElement;
        Invoke invoke = BPELFactory.eINSTANCE.createInvoke();
        invoke.setElement(invokeElement);
        this.setStandardAttributes(invokeElement, invoke);
        this.setOperationParms(invokeElement, invoke, null, BPELPackage.eINSTANCE.getInvoke_InputVariable(), BPELPackage.eINSTANCE.getInvoke_OutputVariable(), BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        this.setCompensationHandler(invokeElement, (EObject)invoke);
        FaultHandler faultHandler = this.xml2FaultHandler(invokeElement);
        if (!(faultHandler == null || faultHandler.getCatch().isEmpty() && faultHandler.getCatchAll() == null)) {
            invoke.setFaultHandler(faultHandler);
        }
        if ((toPartsElement = this.getBPELChildElementByLocalName(invokeElement, "toParts")) != null) {
            ToParts toParts = this.xml2ToParts(toPartsElement);
            invoke.setToParts(toParts);
        }
        if ((fromPartsElement = this.getBPELChildElementByLocalName(invokeElement, "fromParts")) != null) {
            FromParts fromParts = this.xml2FromParts(fromPartsElement);
            invoke.setFromParts(fromParts);
        }
        return invoke;
    }

    protected Activity xml2Reply(Element replyElement) {
        Element toPartsElement;
        Reply reply = BPELFactory.eINSTANCE.createReply();
        reply.setElement(replyElement);
        this.setStandardAttributes(replyElement, reply);
        this.setOperationParms(replyElement, reply, BPELPackage.eINSTANCE.getReply_Variable(), null, null, BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        if (replyElement.hasAttribute("faultName")) {
            QName qName = BPELUtils.createAttributeValue(replyElement, "faultName");
            reply.setFaultName(qName);
        }
        if ((toPartsElement = this.getBPELChildElementByLocalName(replyElement, "toParts")) != null) {
            ToParts toParts = this.xml2ToParts(toPartsElement);
            reply.setToParts(toParts);
        }
        this.setMessageExchange(replyElement, (EObject)reply, BPELPackage.eINSTANCE.getReply_MessageExchange());
        return reply;
    }

    protected Activity xml2Receive(Element receiveElement) {
        Element fromPartsElement;
        Receive receive = BPELFactory.eINSTANCE.createReceive();
        receive.setElement(receiveElement);
        this.setStandardAttributes(receiveElement, receive);
        this.setOperationParms(receiveElement, receive, BPELPackage.eINSTANCE.getReceive_Variable(), null, null, BPELPackage.eINSTANCE.getPartnerActivity_PartnerLink());
        if (receiveElement.hasAttribute("createInstance")) {
            String createInstance = receiveElement.getAttribute("createInstance");
            receive.setCreateInstance(createInstance.equals("yes"));
        }
        if ((fromPartsElement = this.getBPELChildElementByLocalName(receiveElement, "fromParts")) != null) {
            FromParts fromParts = this.xml2FromParts(fromPartsElement);
            receive.setFromParts(fromParts);
        }
        this.setMessageExchange(receiveElement, (EObject)receive, BPELPackage.eINSTANCE.getReceive_MessageExchange());
        return receive;
    }

    protected void setMessageExchange(Element activityElement, final EObject eObject, final EReference reference) {
        if (!activityElement.hasAttribute("messageExchange")) {
            return;
        }
        final String messageExchangeName = activityElement.getAttribute("messageExchange");
        this.fPass2Runnables.add(new Runnable(){

            @Override
            public void run() {
                MessageExchange targetMessageExchange = BPELUtils.getMessageExchange(eObject, messageExchangeName);
                if (targetMessageExchange == null) {
                    targetMessageExchange = new MessageExchangeProxy(BPELReader.this.getResource().getURI(), messageExchangeName);
                }
                eObject.eSet((EStructuralFeature)reference, (Object)targetMessageExchange);
            }
        });
    }

    protected Activity xml2ForEach(Element forEachElement) {
        Activity activity;
        Element completionConditionElement;
        Element finalCounterValueElement;
        Element startCounterValueElement;
        ForEach forEach = BPELFactory.eINSTANCE.createForEach();
        forEach.setElement(forEachElement);
        this.setStandardAttributes(forEachElement, forEach);
        if (forEachElement.hasAttribute("parallel")) {
            forEach.setParallel(forEachElement.getAttribute("parallel").equals("yes"));
        }
        if (forEachElement.hasAttribute("counterName")) {
            Variable variable = BPELFactory.eINSTANCE.createVariable();
            variable.setName(forEachElement.getAttribute("counterName"));
            QName qName = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
            XSDTypeDefinitionProxy type = new XSDTypeDefinitionProxy(this.getResource().getURI(), qName);
            variable.setType((XSDTypeDefinition)type);
            forEach.setCounterName(variable);
        }
        if ((startCounterValueElement = this.getBPELChildElementByLocalName(forEachElement, "startCounterValue")) != null) {
            Expression expression = this.xml2Expression(startCounterValueElement);
            forEach.setStartCounterValue(expression);
        }
        if ((finalCounterValueElement = this.getBPELChildElementByLocalName(forEachElement, "finalCounterValue")) != null) {
            Expression expression = this.xml2Expression(finalCounterValueElement);
            forEach.setFinalCounterValue(expression);
        }
        if ((completionConditionElement = this.getBPELChildElementByLocalName(forEachElement, "completionCondition")) != null) {
            CompletionCondition completionCondition = this.xml2CompletionCondition(completionConditionElement);
            forEach.setCompletionCondition(completionCondition);
        }
        if ((activity = this.getChildActivity(forEachElement)) instanceof Scope) {
            forEach.setActivity(activity);
        }
        return forEach;
    }

    protected CompletionCondition xml2CompletionCondition(Element completionConditionElement) {
        CompletionCondition completionCondition = BPELFactory.eINSTANCE.createCompletionCondition();
        completionCondition.setElement(completionConditionElement);
        Element branchesElement = this.getBPELChildElementByLocalName(completionConditionElement, "branches");
        if (branchesElement != null) {
            Branches branches = this.xml2Branches(branchesElement);
            completionCondition.setBranches(branches);
        }
        return completionCondition;
    }

    protected Branches xml2Branches(Element branchesElement) {
        Branches branches = BPELFactory.eINSTANCE.createBranches();
        branches.setElement(branchesElement);
        this.xml2Expression(branchesElement, branches);
        if (branchesElement.hasAttribute("successfulBranchesOnly")) {
            branches.setCountCompletedBranchesOnly(branchesElement.getAttribute("successfulBranchesOnly").equals("yes"));
        }
        return branches;
    }

    protected Documentation xml2Documentation(Element documentationElement) {
        String text;
        Documentation documentation = BPELFactory.eINSTANCE.createDocumentation();
        documentation.setElement(documentationElement);
        if (documentationElement.hasAttribute("xml:lang")) {
            documentation.setLang(documentationElement.getAttribute("xml:lang"));
        }
        if (documentationElement.hasAttribute("source")) {
            documentation.setSource(documentationElement.getAttribute("source"));
        }
        if ((text = this.getText(documentationElement)) != null) {
            documentation.setValue(text);
        }
        return documentation;
    }

    protected Activity xml2RepeatUntil(Element repeatUntilElement) {
        RepeatUntil repeatUntil = BPELFactory.eINSTANCE.createRepeatUntil();
        repeatUntil.setElement(repeatUntilElement);
        this.setStandardAttributes(repeatUntilElement, repeatUntil);
        Element conditionElement = this.getBPELChildElementByLocalName(repeatUntilElement, "condition");
        if (conditionElement != null) {
            Condition condition = this.xml2Condition(conditionElement);
            repeatUntil.setCondition(condition);
        }
        NodeList repeatUntilElements = repeatUntilElement.getChildNodes();
        Element activityElement = null;
        if (repeatUntilElements != null && repeatUntilElements.getLength() > 0) {
            int i = 0;
            while (i < repeatUntilElements.getLength()) {
                Activity activity;
                if (repeatUntilElements.item(i).getNodeType() == 1 && (activity = this.xml2Activity(activityElement = (Element)repeatUntilElements.item(i))) != null) {
                    repeatUntil.setActivity(activity);
                    break;
                }
                ++i;
            }
        }
        return repeatUntil;
    }

    protected Correlations xml2Correlations(Element correlationsElement) {
        if (!correlationsElement.getLocalName().equals("correlations")) {
            return null;
        }
        Correlations correlations = BPELFactory.eINSTANCE.createCorrelations();
        correlations.setElement(correlationsElement);
        this.saveNamespacePrefix((EObject)correlations, correlationsElement);
        for (Element e : this.getBPELChildElementsByLocalName(correlationsElement, "correlation")) {
            correlations.getChildren().add((Object)this.xml2Correlation(e));
        }
        this.xml2ExtensibleElement(correlations, correlationsElement);
        return correlations;
    }

    protected Correlation xml2Correlation(Element correlationElement) {
        Attr pattern;
        Attr initiation;
        final Correlation correlation = BPELFactory.eINSTANCE.createCorrelation();
        correlation.setElement(correlationElement);
        this.saveNamespacePrefix((EObject)correlation, correlationElement);
        if (correlationElement == null) {
            return correlation;
        }
        if (correlationElement.hasAttribute("set")) {
            final String correlationSetName = correlationElement.getAttribute("set");
            this.fPass2Runnables.add(new Runnable(){

                @Override
                public void run() {
                    CorrelationSet cSet = BPELUtils.getCorrelationSetForActivity(correlation, correlationSetName);
                    if (cSet == null) {
                        cSet = new CorrelationSetProxy(BPELReader.this.getResource().getURI(), correlationSetName);
                    }
                    correlation.setSet(cSet);
                }
            });
        }
        if ((initiation = correlationElement.getAttributeNode("initiate")) != null && initiation.getSpecified()) {
            if (initiation.getValue().equals("yes")) {
                correlation.setInitiate("yes");
            } else if (initiation.getValue().equals("no")) {
                correlation.setInitiate("no");
            } else if (initiation.getValue().equals("join")) {
                correlation.setInitiate("join");
            }
        }
        if ((pattern = correlationElement.getAttributeNode("pattern")) != null && pattern.getSpecified()) {
            if (pattern.getValue().equals("request")) {
                correlation.setPattern(CorrelationPattern.REQUEST_LITERAL);
            } else if (pattern.getValue().equals("response")) {
                correlation.setPattern(CorrelationPattern.RESPONSE_LITERAL);
            } else if (pattern.getValue().equals("request-response")) {
                correlation.setPattern(CorrelationPattern.REQUESTRESPONSE_LITERAL);
            }
        }
        this.xml2ExtensibleElement(correlation, correlationElement);
        return correlation;
    }

    protected Compensate xml2Compensate(Element compensateElement) {
        Compensate compensate = BPELFactory.eINSTANCE.createCompensate();
        compensate.setElement(compensateElement);
        this.setStandardAttributes(compensateElement, compensate);
        return compensate;
    }

    protected CompensateScope xml2CompensateScope(Element compensateScopeElement) {
        final CompensateScope compensateScope = BPELFactory.eINSTANCE.createCompensateScope();
        compensateScope.setElement(compensateScopeElement);
        final String target = compensateScopeElement.getAttribute("target");
        if (target != null && target.length() > 0) {
            this.fPass2Runnables.add(new Runnable(){

                @Override
                public void run() {
                    compensateScope.setTarget(target);
                }
            });
        }
        this.setStandardAttributes(compensateScopeElement, compensateScope);
        return compensateScope;
    }

    protected void xml2ExtensibleElement(BPELExtensibleElement extensibleElement, Element element) {
        if (this.extensionRegistry == null) {
            return;
        }
        Element documentationElement = this.getBPELChildElementByLocalName(element, "documentation");
        if (documentationElement != null) {
            Documentation documentation = this.xml2Documentation(documentationElement);
            extensibleElement.setDocumentation(documentation);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        int n = nodeList.getLength();
        while (i < n) {
            String namespaceURI;
            if (nodeList.item(i) instanceof Element && !BPELConstants.isBPELNamespace(namespaceURI = ((Element)nodeList.item(i)).getNamespaceURI())) {
                nodes.add(nodeList.item(i));
            }
            ++i;
        }
        NamedNodeMap nodeMap = element.getAttributes();
        int i2 = 0;
        int n2 = nodeMap.getLength();
        while (i2 < n2) {
            Attr attr = (Attr)nodeMap.item(i2);
            if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
                nodes.add(attr);
            }
            ++i2;
        }
        for (Node node : nodes) {
            if (MessagepropertiesConstants.isMessagePropertiesNamespace(node.getNamespaceURI())) continue;
            if (node.getNodeType() == 1) {
                this.deserialize(extensibleElement, (Element)node);
                continue;
            }
            if (node.getNodeType() != 2) continue;
            this.deserialize(extensibleElement, (Attr)node);
        }
    }

    protected void deserialize(BPELExtensibleElement ee, Element elm) {
        QName qname = new QName(elm.getNamespaceURI(), elm.getLocalName());
        BPELExtensionDeserializer deserializer = null;
        try {
            deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        if (deserializer == null) {
            return;
        }
        Map<String, String> nsMap = this.getAllNamespacesForElement(elm);
        try {
            ExtensibilityElement extensibilityElement = deserializer.unmarshall(ee.getClass(), qname, elm, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
            ee.addExtensibilityElement(extensibilityElement);
        }
        catch (WSDLException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    protected void deserialize(BPELExtensibleElement ee, Attr attr) {
        if (!attr.getSpecified()) {
            return;
        }
        QName qname = new QName(attr.getNamespaceURI(), "extensibilityAttributes");
        BPELExtensionDeserializer deserializer = null;
        try {
            deserializer = (BPELExtensionDeserializer)this.extensionRegistry.queryDeserializer(BPELExtensibleElement.class, qname);
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        if (deserializer == null) {
            return;
        }
        Element tempElement = attr.getOwnerDocument().createElementNS(attr.getNamespaceURI(), String.valueOf(attr.getPrefix()) + ":extensibilityAttributes");
        tempElement.setAttribute("xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
        tempElement.setAttribute(attr.getLocalName(), attr.getNodeValue());
        Map<String, String> nsMap = this.getAllNamespacesForElement((Element)attr.getParentNode());
        try {
            ExtensibilityElement extensibilityElement = deserializer.unmarshall(BPELExtensibleElement.class, qname, tempElement, this.process, nsMap, this.extensionRegistry, this.getResource().getURI(), this);
            if (extensibilityElement != null) {
                ee.addExtensibilityElement(extensibilityElement);
            }
        }
        catch (WSDLException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    public boolean isAbstractProcess(Element processElement) {
        Map<String, String> nsMap;
        return processElement != null && (nsMap = this.getAllNamespacesForElement(processElement)).containsValue("http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
    }

    public String getProfileNamespace(Element processElement) {
        if (processElement.getAttribute("abstractProcessProfile") != null) {
            return processElement.getAttribute("abstractProcessProfile");
        }
        return null;
    }

    public static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String getText(Node node) {
        StringBuilder sb = new StringBuilder(128);
        if (node instanceof Element) {
            node = ((Element)node).getFirstChild();
        }
        boolean bCData = false;
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    if (bCData) break;
                    Text text = (Text)node;
                    sb.append(text.getData());
                    break;
                }
                case 4: {
                    if (!bCData) {
                        sb.setLength(0);
                        bCData = true;
                    }
                    CDATASection cdata = (CDATASection)node;
                    sb.append(cdata.getData());
                }
            }
            node = node.getNextSibling();
        }
        String data = sb.toString();
        if (BPELReader.isEmptyOrWhitespace(data)) {
            return null;
        }
        return data;
    }

    public static Variable getVariable(EObject eObject, String variableName) {
        return VARIABLE_RESOLVER.getVariable(eObject, variableName);
    }

    public static Link getLink(Activity activity, String linkName) {
        return LINK_RESOLVER.getLink(activity, linkName);
    }

    @Override
    public void error(SAXParseException exception) {
        String message = MessageFormat.format("Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 4);
        if (this.fCurrentResource != null) {
            this.fCurrentResource.getErrors().add((Object)new SAXParseDiagnostic(exception, 2));
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        String message = MessageFormat.format("Fatal Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 4);
        if (this.fCurrentResource != null) {
            this.fCurrentResource.getErrors().add((Object)new SAXParseDiagnostic(exception, 3));
        }
    }

    @Override
    public void warning(SAXParseException exception) {
        String message = MessageFormat.format("Warning in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        BPELPlugin.logMessage(message, exception, 2);
        if (this.fCurrentResource != null) {
            this.fCurrentResource.getErrors().add((Object)new SAXParseDiagnostic(exception, 1));
        }
    }
}

