/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import java.util.List;
import java.util.Vector;
import org.eclipse.bpel.common.ui.tray.TrayEditPart;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Point;

public class TrayAccessibleEditPart
extends AccessibleEditPart {
    protected TrayEditPart part;

    public TrayAccessibleEditPart(TrayEditPart part) {
        this.part = part;
    }

    public void getChildCount(AccessibleControlEvent e) {
        this.getChildren(e);
        e.detail = e.children.length;
    }

    public void getChildren(AccessibleControlEvent e) {
        List list = this.part.getChildren();
        Vector<Integer> childList = new Vector<Integer>();
        int i = 0;
        while (i < list.size()) {
            EditPart child = (EditPart)list.get(i);
            AccessibleEditPart access = (AccessibleEditPart)child.getAdapter(AccessibleEditPart.class);
            if (access != null) {
                childList.add(access.getAccessibleID());
            }
            ++i;
        }
        e.children = childList.toArray();
    }

    public void getName(AccessibleEvent e) {
        Label label = this.part.getDirectEditLabel();
        e.result = label != null ? label.getText() : null;
    }

    public void getLocation(AccessibleControlEvent e) {
        Rectangle bounds = this.part.getFigure().getBounds().getCopy();
        this.part.getFigure().translateToAbsolute((Translatable)bounds);
        Point p = new Point(0, 0);
        p = this.part.getViewer().getControl().toDisplay(p);
        e.x = bounds.x + p.x;
        e.y = bounds.y + p.y;
        e.width = bounds.width;
        e.height = bounds.height;
    }

    public void getState(AccessibleControlEvent e) {
        e.detail = 0x300000;
        if (this.part.getSelected() != 0) {
            e.detail |= 2;
        }
        if (this.part.getViewer().getFocusEditPart() == this.part) {
            e.detail = 4;
        }
    }
}

