/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class MultiViewerSelectionProvider
implements ISelectionProvider,
IPostSelectionProvider {
    static ISelectionChangedListener[] EMPTY_LISTENERS = new ISelectionChangedListener[0];
    protected List<EditPartViewer> viewers = new ArrayList<EditPartViewer>();
    protected List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    protected List<ISelectionChangedListener> postListeners = new ArrayList<ISelectionChangedListener>();
    protected boolean changingSelection = false;
    protected boolean broadcastingSelectionChange = false;
    protected IStructuredSelection cachedSelection;

    public MultiViewerSelectionProvider() {
    }

    public MultiViewerSelectionProvider(EditPartViewer viewer) {
        this.addViewer(viewer);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove(listener);
    }

    public void addViewer(EditPartViewer viewer) {
        this.viewers.add(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MultiViewerSelectionProvider.this.changingSelection) {
                    return;
                }
                MultiViewerSelectionProvider.this.setSelection(event.getSelection());
            }
        });
    }

    public ISelection getSelection() {
        if (this.cachedSelection == null) {
            ArrayList result = new ArrayList();
            for (EditPartViewer next : this.viewers) {
                result.addAll(next.getSelectedEditParts());
            }
            this.cachedSelection = this.calculateSelection((IStructuredSelection)new StructuredSelection(result));
        }
        return this.cachedSelection;
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.cachedSelection = this.calculateSelection((IStructuredSelection)selection);
        this.internalSetSelection(this.cachedSelection);
        this.fireSelectionChanged(this, (ISelection)this.cachedSelection);
    }

    protected void fireSelectionChanged(ISelectionProvider provider, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(provider, selection);
        try {
            ISelectionChangedListener listener;
            this.broadcastingSelectionChange = true;
            ISelectionChangedListener[] iSelectionChangedListenerArray = this.listeners.toArray(EMPTY_LISTENERS);
            int n = iSelectionChangedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                listener = iSelectionChangedListenerArray[n2];
                listener.selectionChanged(event);
                ++n2;
            }
            iSelectionChangedListenerArray = this.postListeners.toArray(EMPTY_LISTENERS);
            n = iSelectionChangedListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                listener = iSelectionChangedListenerArray[n2];
                listener.selectionChanged(event);
                ++n2;
            }
        }
        finally {
            this.broadcastingSelectionChange = false;
        }
    }

    protected IStructuredSelection calculateSelection(IStructuredSelection baseSelection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>();
        for (EditPartViewer viewer : this.viewers) {
            Map registry = viewer.getEditPartRegistry();
            Object[] objectArray = baseSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object n3 = objectArray[n2];
                EditPart part = (EditPart)n3;
                Object model = part.getModel();
                EditPart viewerEditPart = (EditPart)registry.get(model);
                if (viewerEditPart != null) {
                    result.add(viewerEditPart);
                }
                ++n2;
            }
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result);
    }

    protected void internalSetSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        try {
            this.changingSelection = true;
            for (EditPartViewer viewer : this.viewers) {
                Map registry = viewer.getEditPartRegistry();
                ArrayList<EditPart> newList = new ArrayList<EditPart>();
                HashSet<EditPart> newSet = new HashSet<EditPart>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object n3 = objectArray[n2];
                    EditPart part = (EditPart)n3;
                    Object model = part.getModel();
                    EditPart viewerEditPart = (EditPart)registry.get(model);
                    if (viewerEditPart != null && newSet.add(viewerEditPart)) {
                        newList.add(viewerEditPart);
                    }
                    ++n2;
                }
                viewer.setSelection((ISelection)new StructuredSelection(newList));
            }
        }
        finally {
            this.changingSelection = false;
        }
    }

    public boolean isBroadcastingSelectionChange() {
        return this.broadcastingSelectionChange;
    }
}

