/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.editmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.Messages;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.common.ui.editmodel.IEditModelCommand;
import org.eclipse.bpel.common.ui.editmodel.PlaceHolderCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class EditModelCommandStack
extends CommandStack {
    protected int saveLocation = 0;
    protected int fCurrentLocation = 0;
    protected Set<Resource> dirtyUntilSave = new HashSet<Resource>();
    protected List<Context> fContexts = new ArrayList<Context>(30);
    protected static Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];

    public Command getUndoCommand() {
        if (this.fCurrentLocation < 1) {
            return null;
        }
        return this.fContexts.get((int)(this.fCurrentLocation - 1)).fCommand;
    }

    public boolean canUndo() {
        Command c = this.getUndoCommand();
        return c != null && c.canUndo();
    }

    public Command getRedoCommand() {
        if (this.fCurrentLocation >= this.fContexts.size()) {
            return null;
        }
        return this.fContexts.get((int)this.fCurrentLocation).fCommand;
    }

    public boolean canRedo() {
        return this.getRedoCommand() != null;
    }

    public void execute(Command command) {
        SharedCommandStackChangedEvent event = this.notifyListeners(1);
        if (!event.doit) {
            return;
        }
        if (this.getUndoCommand() instanceof PlaceHolderCommand) {
            throw new IllegalStateException();
        }
        if (command == null) {
            return;
        }
        if (!this.validateEdit(command)) {
            return;
        }
        if (!command.canExecute()) {
            return;
        }
        this.drop(this.fCurrentLocation, this.fContexts.size());
        if (this.getUndoCommand() instanceof PlaceHolderCommand) {
            throw new IllegalStateException();
        }
        command.execute();
        if (this.getUndoCommand() instanceof PlaceHolderCommand) {
            throw new IllegalStateException();
        }
        int limit = this.getUndoLimit();
        if (limit > 0) {
            while (this.fCurrentLocation >= limit) {
                if (this.saveLocation == 0) {
                    this.saveLocation = -1;
                }
                this.drop(0);
                this.notifyListeners(11);
            }
        }
        if (this.getUndoCommand() instanceof PlaceHolderCommand) {
            throw new IllegalStateException();
        }
        Resource[] resources = EditModelCommandStack.getModifiedResources(command);
        if (resources.length > 0 || command instanceof PlaceHolderCommand) {
            Context c = new Context(command, resources);
            this.fContexts.add(c);
            this.fCurrentLocation = this.fContexts.size();
            c.setModifiedFlags(true);
        }
        this.notifyListeners(2);
    }

    protected boolean validateEdit(Command command) {
        Shell shell;
        Resource[] resources = EditModelCommandStack.getResources(command);
        if (resources.length == 0) {
            return true;
        }
        boolean disposeShell = false;
        IWorkbenchWindow win = CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (win != null) {
            shell = win.getShell();
        } else {
            disposeShell = true;
            shell = new Shell();
        }
        try {
            IFile[] files = new IFile[resources.length];
            StringBuffer filesString = new StringBuffer();
            int i = 0;
            while (i < resources.length) {
                Resource resource = resources[i];
                files[i] = EditModel.getIFileForURI(resource.getURI());
                filesString.append(files[i].getName());
                if (i < resources.length - 1) {
                    filesString.append(", ");
                }
                ++i;
            }
            IStatus stat = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)shell);
            if (stat.getSeverity() == 8) {
                return false;
            }
            if (!stat.isOK()) {
                String[] buttons = new String[]{IDialogConstants.OK_LABEL};
                String msg = files.length == 1 ? NLS.bind((String)Messages.EditModelCommandStack_validateEdit_message0, (Object[])new String[]{filesString.toString(), stat.getMessage()}) : NLS.bind((String)Messages.EditModelCommandStack_validateEdit_message1, (Object[])new String[]{filesString.toString(), stat.getMessage()});
                MessageDialog dialog = new MessageDialog(shell, Messages.EditModelCommandStack_validateEdit_title, null, msg, 4, buttons, 0);
                dialog.open();
                return false;
            }
        }
        finally {
            if (disposeShell) {
                shell.dispose();
            }
        }
        return true;
    }

    public void dispose() {
        this.drop(0, this.fContexts.size());
    }

    public void flush() {
        SharedCommandStackChangedEvent event = this.notifyListeners(7);
        if (!event.doit) {
            return;
        }
        this.drop(0, this.fContexts.size());
        this.fContexts.clear();
        this.saveLocation = -1;
        this.fCurrentLocation = 0;
        this.notifyListeners(8);
    }

    public Object[] getCommands() {
        Object[] commands = new Object[this.fContexts.size()];
        int i = 0;
        while (i < this.fContexts.size()) {
            commands[i] = this.fContexts.get((int)i).fCommand;
            ++i;
        }
        return commands;
    }

    public boolean isDirty() {
        return this.fCurrentLocation != this.saveLocation || !this.dirtyUntilSave.isEmpty();
    }

    public void markSaveLocation() {
        this.dirtyUntilSave.clear();
        this.saveLocation = this.fCurrentLocation;
        this.notifyListeners(12);
    }

    public void undo() {
        SharedCommandStackChangedEvent event = this.notifyListeners(3);
        if (!event.doit) {
            return;
        }
        if (!this.canUndo()) {
            return;
        }
        Context c = this.fContexts.get(this.fCurrentLocation - 1);
        c.fCommand.undo();
        --this.fCurrentLocation;
        if (this.fCurrentLocation < this.saveLocation) {
            c.setModifiedFlags(true);
        } else {
            this.updateModifiedFlags();
        }
        this.notifyListeners();
        this.notifyListeners(4);
    }

    public void redo() {
        SharedCommandStackChangedEvent event = this.notifyListeners(5);
        if (!event.doit) {
            return;
        }
        if (!this.canRedo()) {
            return;
        }
        Context c = this.fContexts.get(this.fCurrentLocation);
        c.fCommand.redo();
        ++this.fCurrentLocation;
        if (this.fCurrentLocation > this.saveLocation) {
            c.setModifiedFlags(true);
        } else {
            this.updateModifiedFlags();
        }
        if (this.getUndoCommand() instanceof PlaceHolderCommand) {
            throw new IllegalStateException();
        }
        this.notifyListeners();
        this.notifyListeners(6);
    }

    protected SharedCommandStackChangedEvent notifyListeners(int property) {
        SharedCommandStackChangedEvent event = new SharedCommandStackChangedEvent((Object)this);
        event.property = property;
        for (Object next : this.listeners) {
            CommandStackListener csl = (CommandStackListener)next;
            csl.commandStackChanged((EventObject)event);
        }
        return event;
    }

    protected void drop(int pos) {
        if (pos < 0 || pos >= this.fContexts.size()) {
            throw new IllegalArgumentException();
        }
        Context c = this.fContexts.get(pos);
        int a = Math.min(this.saveLocation, this.fCurrentLocation);
        int b = Math.max(this.saveLocation, this.fCurrentLocation);
        if (a <= pos && pos < b) {
            this.dirtyUntilSave.addAll(Arrays.asList(c.fResources));
        }
        c.fCommand.dispose();
        this.fContexts.remove(pos);
        if (this.fCurrentLocation > pos) {
            --this.fCurrentLocation;
        }
        if (this.saveLocation > pos) {
            --this.saveLocation;
        }
    }

    protected void drop(int from, int to) {
        if (to < from) {
            int a = to;
            to = from;
            from = a;
        }
        while (to > from) {
            this.drop(from);
            --to;
        }
    }

    protected static void setResourceModified(Resource r, boolean modified) {
        if (r.isModified() != modified) {
            r.setModified(modified);
        }
    }

    protected void updateModifiedFlags() {
        HashSet<Resource> cleanResources = new HashSet<Resource>();
        for (Context c : this.fContexts) {
            cleanResources.addAll(Arrays.asList(c.fResources));
        }
        for (Resource resource : this.dirtyUntilSave) {
            cleanResources.remove(resource);
            EditModelCommandStack.setResourceModified(resource, true);
        }
        int a = Math.min(this.fCurrentLocation, this.saveLocation);
        int b = Math.max(this.fCurrentLocation, this.saveLocation);
        int i = Math.max(a, 0);
        while (i < b) {
            Context c = this.fContexts.get(i);
            cleanResources.removeAll(Arrays.asList(c.fResources));
            c.setModifiedFlags(true);
            ++i;
        }
        for (Resource resource : cleanResources) {
            EditModelCommandStack.setResourceModified(resource, false);
        }
    }

    public static Resource[] getResources(Command command) {
        if (command instanceof IEditModelCommand) {
            return ((IEditModelCommand)command).getResources();
        }
        if (command instanceof CompoundCommand) {
            CompoundCommand ccmd = (CompoundCommand)command;
            HashSet<Resource> set = new HashSet<Resource>();
            Object[] objectArray = ccmd.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object n3 = objectArray[n2];
                Resource[] resourceArray = EditModelCommandStack.getResources((Command)n3);
                int n4 = resourceArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Resource r = resourceArray[n5];
                    set.add(r);
                    ++n5;
                }
                ++n2;
            }
            if (set.isEmpty()) {
                return EMPTY_RESOURCE_ARRAY;
            }
            return set.toArray(EMPTY_RESOURCE_ARRAY);
        }
        throw new IllegalArgumentException();
    }

    public static Resource[] getModifiedResources(Command command) {
        if (command instanceof IEditModelCommand) {
            return ((IEditModelCommand)command).getModifiedResources();
        }
        if (command instanceof CompoundCommand) {
            CompoundCommand ccmd = (CompoundCommand)command;
            HashSet<Resource> set = new HashSet<Resource>();
            Object[] objectArray = ccmd.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object n3 = objectArray[n2];
                Resource[] resourceArray = EditModelCommandStack.getModifiedResources((Command)n3);
                int n4 = resourceArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Resource r = resourceArray[n5];
                    set.add(r);
                    ++n5;
                }
                ++n2;
            }
            if (set.isEmpty()) {
                return EMPTY_RESOURCE_ARRAY;
            }
            return set.toArray(EMPTY_RESOURCE_ARRAY);
        }
        throw new IllegalArgumentException();
    }

    protected static class Context {
        public Command fCommand;
        public Resource[] fResources;

        public Context(Command command, Resource[] resources) {
            this.fCommand = command;
            this.fResources = resources;
        }

        public void setModifiedFlags(boolean value) {
            Resource[] resourceArray = this.fResources;
            int n = this.fResources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                EditModelCommandStack.setResourceModified(r, value);
                ++n2;
            }
        }
    }

    public static class SharedCommandStackChangedEvent
    extends EventObject {
        int property;
        public boolean doit = true;

        SharedCommandStackChangedEvent(Object source) {
            super(source);
        }

        public EditModelCommandStack getStack() {
            return (EditModelCommandStack)((Object)this.getSource());
        }

        public int getProperty() {
            return this.property;
        }
    }

    public static interface SharedCommandStackListener
    extends CommandStackListener {
        public static final int EVENT_START_EXECUTE = 1;
        public static final int EVENT_FINISH_EXECUTE = 2;
        public static final int EVENT_START_UNDO = 3;
        public static final int EVENT_FINISH_UNDO = 4;
        public static final int EVENT_START_REDO = 5;
        public static final int EVENT_FINISH_REDO = 6;
        public static final int EVENT_START_FLUSH = 7;
        public static final int EVENT_FINISH_FLUSH = 8;
        public static final int EVENT_START_MARK_SAVED = 9;
        public static final int EVENT_FINISH_MARK_SAVED = 10;
        public static final int EVENT_DROP_LAST_UNDO_STACK_ENTRY = 11;
        public static final int EVENT_MARK_SAVED = 12;
    }
}

