/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.details.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class StatusLabel2 {
    private static final int MAX_MESSAGES = 5;
    private static final String STATUS_MESSAGE_ID = "STATUS_MESSAGE";
    private static final String NEW_LINE = "\n";
    private static final String ETCETERA = "...";
    protected DecoratedLabel label;
    protected List<StatusMessage> statusMessageList;
    protected static Image blankImage;
    protected static Image infoImage;
    protected static Image warnImage;
    protected static Image errorImage;

    public StatusLabel2(DecoratedLabel aLabel) {
        this.label = aLabel;
        if (blankImage == null) {
            StatusLabel2.initSharedImages();
        }
        this.setStatusMessageList(new ArrayList<StatusMessage>());
        this.clear();
    }

    protected static void initSharedImages() {
        ImageRegistry registry = CommonUIPlugin.getDefault().getImageRegistry();
        infoImage = registry.get("obj/sm_info.gif");
        warnImage = registry.get("obj/sm_warn.gif");
        errorImage = registry.get("obj/sm_error.gif");
    }

    public DecoratedLabel getLabel() {
        return this.label;
    }

    public Control getControl() {
        return this.label;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String s) {
        this.label.setText(s);
    }

    public Object getLayoutData() {
        return this.label.getLayoutData();
    }

    public void setLayoutData(Object layoutData) {
        this.label.setLayoutData(layoutData);
    }

    public void clear() {
        this.statusMessageList.clear();
        this.updateLabel();
    }

    public void clear(String messageId) {
        if (messageId == null) {
            this.clear();
            return;
        }
        ArrayList<StatusMessage> removeList = new ArrayList<StatusMessage>();
        for (StatusMessage m : this.statusMessageList) {
            if (!messageId.equals(m.getId())) continue;
            removeList.add(m);
        }
        this.statusMessageList.removeAll(removeList);
        this.updateLabel();
    }

    public void setSeverity(String messageId, int severity, String message) {
        this.statusMessageList.clear();
        this.addSeverity(severity, message);
    }

    public void setSeverity(int severity, String message) {
        this.setSeverity(STATUS_MESSAGE_ID, severity, message);
    }

    public void setStatus(IStatus status) {
        if (status == null) {
            this.setSeverity(STATUS_MESSAGE_ID, 0, null);
        } else {
            this.setSeverity(STATUS_MESSAGE_ID, status.getSeverity(), status.getMessage());
        }
    }

    public void addSeverity(String messageId, int severity, String message) {
        this.statusMessageList.add(new StatusMessage(messageId, severity, message));
        this.updateLabel();
    }

    public void addSeverity(int severity, String message) {
        this.addSeverity(STATUS_MESSAGE_ID, severity, message);
    }

    public void addStatus(IStatus status) {
        if (status != null) {
            this.addSeverity(status.getSeverity(), status.getMessage());
        }
    }

    protected void updateLabel() {
        this.label.setToolTipText(this.getToolTipText());
        switch (this.getHighestSeverity()) {
            case 0: {
                this.label.setImage(blankImage);
                break;
            }
            case 1: {
                this.label.setImage(infoImage);
                break;
            }
            case 2: {
                this.label.setImage(warnImage);
                break;
            }
            default: {
                this.label.setImage(errorImage);
            }
        }
    }

    protected String getToolTipText() {
        StringBuilder toolTipText = new StringBuilder(256);
        ArrayList<String> toolTipTextList = new ArrayList<String>();
        this.appendToolTipTextList(toolTipTextList, 4, 5);
        this.appendToolTipTextList(toolTipTextList, 2, 5);
        this.appendToolTipTextList(toolTipTextList, 1, 5);
        this.appendToolTipTextList(toolTipTextList, 0, 5);
        for (String t : toolTipTextList) {
            toolTipText.append(t).append(NEW_LINE);
        }
        if (this.statusMessageList.size() > toolTipTextList.size() && toolTipText.length() > 0) {
            toolTipText.append(ETCETERA);
        }
        return toolTipText.toString().trim();
    }

    protected void appendToolTipTextList(List<String> toolTipTextList, int severity, int maxMessages) {
        for (String m : this.getMessageList(severity)) {
            if (toolTipTextList.size() >= maxMessages) break;
            toolTipTextList.add(m);
        }
    }

    protected List<String> getMessageList(int severity) {
        ArrayList<String> messageList = new ArrayList<String>();
        for (StatusMessage m : this.statusMessageList) {
            if (m.getSeverity() != severity) continue;
            messageList.add(m.getMessage());
        }
        return messageList;
    }

    protected int getHighestSeverity() {
        int severity = 0;
        for (StatusMessage m : this.statusMessageList) {
            if (m.getSeverity() <= severity) continue;
            severity = m.getSeverity();
        }
        return severity;
    }

    protected List<StatusMessage> getStatusMessageList() {
        return this.statusMessageList;
    }

    protected void setStatusMessageList(List<StatusMessage> list) {
        this.statusMessageList = list;
    }

    protected class StatusMessage {
        protected String id;
        protected int severity;
        protected String message;

        protected StatusMessage(String messageId, int sev, String msg) {
            this.setSeverity(messageId, sev, msg);
        }

        protected StatusMessage() {
            this.setStatus(null);
        }

        protected void setSeverity(String messageId, int sev, String msg) {
            this.setId(messageId);
            this.setSeverity(sev);
            this.setMessage(msg);
        }

        protected void setStatus(IStatus status) {
            if (status == null) {
                this.setSeverity(StatusLabel2.STATUS_MESSAGE_ID, 0, null);
            } else {
                this.setSeverity(StatusLabel2.STATUS_MESSAGE_ID, status.getSeverity(), status.getMessage());
            }
        }

        protected int getSeverity() {
            return this.severity;
        }

        protected void setSeverity(int i) {
            this.severity = i;
        }

        protected String getMessage() {
            return this.message;
        }

        protected void setMessage(String string) {
            this.message = string;
        }

        protected String getId() {
            return this.id;
        }

        protected void setId(String string) {
            this.id = string;
        }
    }
}

