/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TService;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;

public class ServiceCellEditor
extends ComboBoxCellEditor {
    IProject bpelProject = null;
    ResourceSet resourceSet = null;
    List<Port> portList = null;

    public ServiceCellEditor(Table parent, IProject bpelProject, ResourceSet resourceSet) {
        super((Composite)parent, new String[0], 8);
        this.bpelProject = bpelProject;
        this.resourceSet = resourceSet != null ? resourceSet : new ResourceSetImpl();
    }

    protected Object doGetValue() {
        Integer integer = (Integer)super.doGetValue();
        CCombo combo = (CCombo)this.getControl();
        String string = combo.getItem(integer.intValue());
        Port port = this.findPortByName(string);
        return port;
    }

    private Port findPortByName(String string) {
        for (Port currentPort : this.portList) {
            if (!currentPort.getName().equals(string)) continue;
            return currentPort;
        }
        return null;
    }

    protected void doSetValue(Object value) {
        ArrayList<Service> serviceList = new ArrayList<Service>();
        this.portList = new ArrayList<Port>();
        List<Definition> wsdlDefs = DeployUtils.loadAllWSDLFromProject(this.bpelProject, this.resourceSet);
        for (Definition current : wsdlDefs) {
            Map services = current.getServices();
            if (services.isEmpty()) continue;
            Collection values = services.values();
            for (Service name : values) {
                serviceList.add(name);
            }
        }
        for (Service currentService : serviceList) {
            Map portMap = currentService.getPorts();
            Collection ports = portMap.values();
            this.portList.addAll(ports);
        }
        String[] items = new String[this.portList.size() + 1];
        items[0] = "-- none -- ";
        int i = 1;
        while (i < this.portList.size() + 1) {
            Port currentPort = this.portList.get(i - 1);
            items[i] = currentPort.getName();
            ++i;
        }
        this.setItems(items);
        if (value != null) {
            TService service = (TService)value;
            int i2 = 0;
            while (i2 < this.portList.size()) {
                Port p = this.portList.get(i2);
                if (p.getName().equals(service.getPort()) && ((Service)p.getContainer()).getQName().equals(service.getName())) {
                    super.doSetValue((Object)(i2 + 1));
                    return;
                }
                ++i2;
            }
        }
        super.doSetValue((Object)0);
    }
}

