/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.birt.core.framework.jar.ConfigurationElement;
import org.eclipse.birt.core.framework.jar.Extension;
import org.eclipse.birt.core.framework.jar.ExtensionPoint;
import org.eclipse.birt.core.framework.jar.ServicePlatform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BundleLoader {
    static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    static final String PLUGIN_ENTRY = "plugin.xml";
    static final String PROPERTIES_ENTRY = "plugin.properties";
    protected ServicePlatform platform;
    protected URL root;
    protected Bundle bundle;
    protected Properties properties;

    BundleLoader(ServicePlatform platform, URL root) {
        this.platform = platform;
        this.root = root;
    }

    Bundle load() throws IOException, ParserConfigurationException, SAXException {
        this.properties = this.loadProperties(this.root);
        this.bundle = this.loadManifest(this.root);
        if (this.bundle != null) {
            this.loadExtensions(this.bundle);
        }
        return this.bundle;
    }

    protected Bundle loadManifest(URL root) throws IOException {
        InputStream in = this.openInputStream(root, MANIFEST_ENTRY);
        if (in == null) {
            return null;
        }
        try {
            String symbolicName;
            Manifest manifest = new Manifest(in);
            Attributes attr = manifest.getMainAttributes();
            if (attr != null && (symbolicName = attr.getValue(BUNDLE_SYMBOLIC_NAME)) != null) {
                int dotPos = symbolicName.indexOf(59);
                if (dotPos != -1) {
                    symbolicName = symbolicName.substring(0, dotPos);
                }
                symbolicName = this.loadProperty(symbolicName);
                String version = attr.getValue(BUNDLE_VERSION);
                version = this.loadProperty(version);
                Bundle bundle = new Bundle(this.platform, root, symbolicName);
                bundle.version = version;
                Bundle bundle2 = bundle;
                return bundle2;
            }
        }
        finally {
            in.close();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    protected Properties loadProperties(URL root) {
        InputStream in = this.openInputStream(root, PROPERTIES_ENTRY);
        if (in == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(in);
        Properties properties2 = properties;
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return properties2;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException3) {}
        }
        return null;
    }

    protected void loadExtensions(Bundle bundle) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = this.openInputStream(bundle.root, PLUGIN_ENTRY);
        if (in == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            Element root = document.getDocumentElement();
            ArrayList<ExtensionPoint> extensionPoints = new ArrayList<ExtensionPoint>();
            ArrayList<Extension> extensions = new ArrayList<Extension>();
            NodeList elements = root.getChildNodes();
            int i = 0;
            while (i < elements.getLength()) {
                Node node = elements.item(i);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    String tagName = child.getTagName();
                    if ("extension-point".equals(tagName)) {
                        ExtensionPoint extPoint = this.parseExtensionPoint(child);
                        extensionPoints.add(extPoint);
                    } else if ("extension".equals(tagName)) {
                        Extension extension = this.parseExtension(child);
                        extensions.add(extension);
                    }
                }
                ++i;
            }
            bundle.extensionPoints = extensionPoints.toArray(new ExtensionPoint[extensionPoints.size()]);
            bundle.extensions = extensions.toArray(new Extension[extensions.size()]);
        }
        finally {
            in.close();
        }
    }

    protected ExtensionPoint parseExtensionPoint(Element element) {
        String name = element.getAttribute("name");
        name = this.loadProperty(name);
        String id = element.getAttribute("id");
        id = this.loadProperty(id);
        String schema = element.getAttribute("schema");
        ExtensionPoint point = new ExtensionPoint(this.bundle, id);
        point.schema = schema;
        return point;
    }

    protected Extension parseExtension(Element element) {
        String id = element.getAttribute("id");
        id = this.loadProperty(id);
        String name = element.getAttribute("name");
        name = this.loadProperty(name);
        String point = element.getAttribute("point");
        Extension extension = new Extension(this.bundle, id);
        extension.label = name;
        extension.extensionPointId = point;
        ArrayList<ConfigurationElement> configurations = new ArrayList<ConfigurationElement>();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                ConfigurationElement config = this.parseConfiguration(extension, (Element)node);
                configurations.add(config);
            }
            ++i;
        }
        extension.configuration = configurations.toArray(new ConfigurationElement[configurations.size()]);
        return extension;
    }

    protected ConfigurationElement parseConfiguration(Object parent, Element element) {
        ConfigurationElement config = new ConfigurationElement();
        config.parent = parent;
        config.name = element.getNodeName();
        config.attributes = new HashMap();
        NamedNodeMap nodeAttrs = element.getAttributes();
        int i = 0;
        while (i < nodeAttrs.getLength()) {
            Node attr = nodeAttrs.item(i);
            String nodeName = attr.getNodeName();
            String nodeValue = attr.getNodeValue();
            nodeValue = this.loadProperty(nodeValue);
            config.attributes.put(nodeName, nodeValue);
            ++i;
        }
        ArrayList<ConfigurationElement> childConfigs = new ArrayList<ConfigurationElement>();
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node node = children.item(i2);
            if (node.getNodeType() == 1) {
                ConfigurationElement childConfig = this.parseConfiguration(config, (Element)node);
                childConfigs.add(childConfig);
            }
            ++i2;
        }
        config.children = childConfigs.toArray(new ConfigurationElement[childConfigs.size()]);
        return config;
    }

    protected String loadProperty(String key) {
        if (key != null && key.length() > 0 && key.charAt(0) == '%') {
            String value;
            key = key.substring(1);
            if (this.properties != null && (value = this.properties.getProperty(key)) != null) {
                return value;
            }
        }
        return key;
    }

    protected InputStream openInputStream(URL root, String name) {
        try {
            URL manifestUrl = new URL(root, name);
            InputStream in = manifestUrl.openStream();
            if (in != null) {
                return in;
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

