/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RiserType implements Enumerator
{
    RECTANGLE_LITERAL(0, "Rectangle", "Rectangle"),
    TRIANGLE_LITERAL(1, "Triangle", "Triangle"),
    TUBE_LITERAL(2, "Tube", "Tube"),
    CONE_LITERAL(3, "Cone", "Cone");

    public static final int RECTANGLE = 0;
    public static final int TRIANGLE = 1;
    public static final int TUBE = 2;
    public static final int CONE = 3;
    private static final RiserType[] VALUES_ARRAY;
    public static final List<RiserType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RiserType[]{RECTANGLE_LITERAL, TRIANGLE_LITERAL, TUBE_LITERAL, CONE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RiserType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiserType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiserType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RiserType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RiserType get(int value) {
        switch (value) {
            case 0: {
                return RECTANGLE_LITERAL;
            }
            case 1: {
                return TRIANGLE_LITERAL;
            }
            case 2: {
                return TUBE_LITERAL;
            }
            case 3: {
                return CONE_LITERAL;
            }
        }
        return null;
    }

    private RiserType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

