/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.factory;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.withaxes.SharedScaleContext;
import org.eclipse.birt.chart.device.IStructureDefinitionListener;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.StructureChangeEvent;
import org.eclipse.birt.chart.factory.IExternalizer;
import org.eclipse.birt.chart.factory.IMessageLookup;
import org.eclipse.birt.chart.factory.IResourceFinder;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.script.IScriptContext;
import org.eclipse.birt.core.i18n.ResourceHandle;

public final class RunTimeContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ULocale lcl = null;
    private IScriptContext csc = null;
    private transient AbstractScriptHandler<?> sh = null;
    private transient ResourceHandle rh = null;
    private transient IMessageLookup iml = null;
    private transient IStructureDefinitionListener isdl = null;
    private transient IActionRenderer iar = null;
    private transient IScriptClassLoader iscl = null;
    private transient LegendLayoutHints lilh = null;
    private transient Map<Series, LegendItemRenderingHints> seriesRenderers = null;
    private HashMap<Object, Object> stateStore = new HashMap(2);
    private boolean enableScripting = true;
    private int iRightToLeft = -1;
    private int iRightToLeftText = -1;
    private transient SharedScaleContext sharedScale;
    private boolean isSharingQuery = false;
    private transient IResourceFinder resourceFinder = null;
    private transient IExternalizer externalizer = null;
    private transient Chart defaultValueChart;
    private TimeZone timeZone = null;
    private boolean useNonHierarchyCategoryData = false;

    public void putState(Object key, Object state) {
        this.stateStore.put(key, state);
    }

    public Object getState(Object key) {
        return this.stateStore.get(key);
    }

    public Object removeState(Object key) {
        return this.stateStore.remove(key);
    }

    public void clearState() {
        IChartComputation cComp = this.getState(StateKey.CHART_COMPUTATION_KEY);
        if (cComp != null) {
            cComp.dispose();
        }
        Iterator<Map.Entry<Object, Object>> iter = this.stateStore.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            Object key = entry.getKey();
            if (key instanceof StateKey) {
                if (!((StateKey)key).needClear()) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
    }

    public boolean isScriptingEnabled() {
        return this.enableScripting;
    }

    public void setScriptingEnabled(boolean value) {
        this.enableScripting = value;
    }

    public IScriptClassLoader getScriptClassLoader() {
        return this.iscl;
    }

    public void setScriptClassLoader(IScriptClassLoader value) {
        this.iscl = value;
    }

    public void setStructureDefinitionListener(IStructureDefinitionListener isdl) {
        this.isdl = isdl;
    }

    public IStructureDefinitionListener getStructureDefinitionListener() {
        return this.isdl;
    }

    public void setActionRenderer(IActionRenderer iar) {
        this.iar = iar;
    }

    public IActionRenderer getActionRenderer() {
        return this.iar;
    }

    public void setLegendLayoutHints(LegendLayoutHints lilh) {
        this.lilh = lilh;
    }

    public LegendLayoutHints getLegendLayoutHints() {
        return this.lilh;
    }

    public void setSeriesRenderers(Map<Series, LegendItemRenderingHints> msr) {
        this.seriesRenderers = msr;
    }

    public Map<Series, LegendItemRenderingHints> getSeriesRenderers() {
        return this.seriesRenderers;
    }

    public boolean notifyStructureChange(String sEventName, Object oSource) {
        if (this.isdl == null) {
            return false;
        }
        StructureChangeEvent scev = ((EventObjectCache)((Object)this.isdl)).getEventObject(oSource, StructureChangeEvent.class);
        scev.setEventName(sEventName);
        this.isdl.changeStructure(scev);
        return true;
    }

    public Locale getLocale() {
        return this.lcl == null ? null : this.lcl.toLocale();
    }

    public void setLocale(Locale lcl) {
        this.lcl = ULocale.forLocale((Locale)lcl);
    }

    public ULocale getULocale() {
        return this.lcl;
    }

    public void setULocale(ULocale lcl) {
        this.lcl = lcl;
    }

    public boolean isRightToLeft() {
        return this.iRightToLeft == 1;
    }

    public void setRightToLeft(boolean value) {
        this.iRightToLeft = value ? 1 : 0;
    }

    public ResourceHandle getResourceHandle() {
        return this.rh;
    }

    public void setResourceHandle(ResourceHandle rh) {
        this.rh = rh;
    }

    public AbstractScriptHandler getScriptHandler() {
        return this.sh;
    }

    public void setScriptHandler(AbstractScriptHandler sh) {
        this.sh = sh;
    }

    public IScriptContext getScriptContext() {
        return this.csc;
    }

    public void setScriptContext(IScriptContext csc) {
        this.csc = csc;
    }

    public void setMessageLookup(IMessageLookup iml) {
        this.iml = iml;
    }

    public String externalizedMessage(String sChartKey) {
        if (sChartKey == null) {
            return "";
        }
        String sKey = sChartKey;
        String sDefaultValue = sChartKey;
        int iKeySeparator = sChartKey.indexOf(61);
        if (iKeySeparator != -1) {
            sDefaultValue = sChartKey.substring(iKeySeparator + 1);
        }
        if (this.externalizer == null) {
            return sDefaultValue;
        }
        if (iKeySeparator > 0) {
            sKey = sChartKey.substring(0, iKeySeparator);
        } else {
            if (iKeySeparator == 0) {
                return sDefaultValue;
            }
            sKey = sDefaultValue;
        }
        return this.externalizer.externalizedMessage(sKey, sDefaultValue, this.getULocale());
    }

    public void setSharedScale(SharedScaleContext ssContext) {
        this.sharedScale = ssContext;
    }

    public SharedScaleContext getSharedScale() {
        return this.sharedScale;
    }

    public boolean isSharingQuery() {
        return this.isSharingQuery;
    }

    public void setSharingQuery(boolean isSharingQuery) {
        this.isSharingQuery = isSharingQuery;
    }

    public boolean isRightToLeftText() {
        return this.iRightToLeftText == 1;
    }

    public void setRightToLeftText(boolean value) {
        this.iRightToLeftText = value ? 1 : 0;
    }

    public IResourceFinder getResourceFinder() {
        return this.resourceFinder;
    }

    public void setResourceFinder(IResourceFinder resourceFinder) {
        this.resourceFinder = resourceFinder;
    }

    public IExternalizer getExternalizer() {
        return this.externalizer;
    }

    public void setExternalizer(IExternalizer externalizer) {
        this.externalizer = externalizer;
    }

    public <T> T getState(StateKey<T> key) {
        return (T)this.stateStore.get(key);
    }

    public <T> void putState(StateKey<T> key, T value) {
        this.stateStore.put(key, value);
    }

    public void setDefaultValueChart(Chart cm) {
        this.defaultValueChart = cm;
    }

    public Chart getDefaultValueChart() {
        return this.defaultValueChart;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void enableNonHierarchyCategoryData(boolean enabled) {
        this.useNonHierarchyCategoryData = enabled;
    }

    public boolean useNonHierarchyCategoryData() {
        return this.useNonHierarchyCategoryData;
    }

    public static class StateKey<T> {
        private boolean needClear = true;
        public static final StateKey<Boolean> DATA_EMPTY_KEY = StateKey.create(false);
        public static final StateKey<Map<Label, LabelLimiter>> LABEL_LIMITER_LOOKUP_KEY = StateKey.create(false);
        public static final StateKey<IChartComputation> CHART_COMPUTATION_KEY = StateKey.create(false);

        private StateKey(boolean needClear) {
            this.needClear = needClear;
        }

        public boolean needClear() {
            return this.needClear;
        }

        public static <T> StateKey<T> create(boolean needClear) {
            return new StateKey<T>(needClear);
        }
    }
}

