/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.documentation.utils;

import org.eclipse.acceleo.parser.AcceleoSourceBuffer;

public final class DocumentationUtils {
    private DocumentationUtils() {
    }

    public static void parseToDoFixMe(AcceleoSourceBuffer source, int startPosition, int endPosition, CommentType type) {
        int startBody = -1;
        int endBody = -1;
        switch (type) {
            case COMMENT_IN_HEADER: {
                startBody = startPosition + "[".length() + "comment".length();
                endBody = endPosition - ("/".length() + "]".length());
                break;
            }
            case COMMENT_WITH_END_HEADER: {
                startBody = startPosition + "[".length() + "comment".length() + "]".length();
                endBody = endPosition - ("[".length() + "/".length() + "comment".length() + "]".length());
                break;
            }
            case DOCUMENTATION: {
                startBody = startPosition + "[".length() + "**".length();
                endBody = endPosition - ("/".length() + "]".length());
                break;
            }
        }
        if (startBody != -1 && endBody != -1 && startBody < endBody) {
            DocumentationUtils.checkKeyword(source.getBuffer().substring(startBody, endBody), "@TODO", source, startBody, endBody);
            DocumentationUtils.checkKeyword(source.getBuffer().substring(startBody, endBody), "@FIXME", source, startBody, endBody);
        }
    }

    public static void checkKeyword(String body, String keyword, AcceleoSourceBuffer source, int bodyStartIndex, int bodyStopIndex) {
        int index = 0;
        while (index != -1 && index != body.length()) {
            if ((index = body.indexOf(keyword, index + 1)) == -1) continue;
            int eol = body.indexOf(System.getProperty("line.separator"), index);
            String message = "";
            int end = 0;
            int begin = bodyStartIndex + index;
            if (eol == -1) {
                eol = bodyStopIndex;
                message = body.substring(index);
                end = eol;
            } else {
                message = body.substring(index, eol);
                end = begin + (eol - index);
            }
            if ("@TODO".equals(keyword)) {
                source.logInfo("AcceleoParserInfo.TODO" + message, begin, end);
                continue;
            }
            if (!"@FIXME".equals(keyword)) continue;
            source.logInfo("AcceleoParserInfo.FIXME" + message, begin, end);
        }
    }

    public static enum CommentType {
        COMMENT_IN_HEADER,
        COMMENT_WITH_END_HEADER,
        DOCUMENTATION;

    }
}

