/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.model;

import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ocl.utilities.ASTNode;

public class AcceleoRunToLineBreakpoint
extends AcceleoLineBreakpoint {
    public AcceleoRunToLineBreakpoint(final ASTNode astNode, final IFile resource, final int lineNumber, final int offset, final int length) throws DebugException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.acceleo.ide.ui.debug.markerType.lineBreakpoint");
                AcceleoRunToLineBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)AcceleoRunToLineBreakpoint.this.getModelIdentifier());
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
                marker.setAttribute("astFragment", (Object)new ASTFragment(astNode).toString());
                marker.setAttribute("message", (Object)AcceleoUIMessages.getString("AcceleoLineBreakpoint.HoverText", astNode.eClass().getName(), resource.getName(), Integer.toString(lineNumber)));
                AcceleoRunToLineBreakpoint.this.setRegistered(false);
            }
        };
        this.run(this.getMarkerRule((IResource)resource), runnable);
    }

    public boolean isRunToLineBreakpoint() {
        return true;
    }
}

