/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.emf.common.EMFPlugin;

public final class AcceleoLaunchingUtil {
    public static final String LAUNCH_ID_ARGUMENTS = "args=";
    public static final String LAUNCH_ID_LAUNCHER = "launcher=";
    public static final String LAUNCH_ID_LAUNCHER_PATH = "launcherPath=";
    public static final String LAUNCH_ID_MODEL_PATH = "model=";
    public static final String LAUNCH_ID_TARGET_PATH = "target=";
    public static final char LAUNCHER_ID_ELEMENT_SEPARATOR = '|';
    public static final char LAUNCHER_ID_SEPARATOR = '&';

    private AcceleoLaunchingUtil() {
    }

    public static String computeUIProjectID(String project, String qualifiedName, String model, String targetFolder, List<String> args) {
        String launcherID = LAUNCH_ID_LAUNCHER + Launcher.UI_PROJECT.ordinal();
        String launcherPath = LAUNCH_ID_LAUNCHER_PATH + project + '|' + qualifiedName;
        String modelPath = LAUNCH_ID_MODEL_PATH + model;
        String targetPath = LAUNCH_ID_TARGET_PATH + targetFolder;
        StringBuilder arguments = new StringBuilder(LAUNCH_ID_ARGUMENTS);
        Iterator<String> argIterator = args.iterator();
        while (argIterator.hasNext()) {
            arguments.append(argIterator.next());
            if (!argIterator.hasNext()) continue;
            arguments.append('|');
        }
        StringBuilder launchID = new StringBuilder();
        launchID.append(launcherID);
        launchID.append('&');
        launchID.append(launcherPath);
        launchID.append('&');
        launchID.append(modelPath);
        launchID.append('&');
        launchID.append(targetPath);
        if (!args.isEmpty()) {
            launchID.append('&');
            launchID.append(arguments.toString());
        }
        return launchID.toString();
    }

    public static String computeLaunchConfigID(String project, String qualifiedName, String model, String targetFolder, List<String> args) {
        String launcherID = LAUNCH_ID_LAUNCHER + Launcher.LAUNCH_CONFIG.ordinal();
        String launcherPath = LAUNCH_ID_LAUNCHER_PATH + project + '|' + qualifiedName;
        String modelPath = LAUNCH_ID_MODEL_PATH + model;
        String targetPath = LAUNCH_ID_TARGET_PATH + targetFolder;
        StringBuilder arguments = new StringBuilder(LAUNCH_ID_ARGUMENTS);
        Iterator<String> argIterator = args.iterator();
        while (argIterator.hasNext()) {
            arguments.append(argIterator.next());
            if (!argIterator.hasNext()) continue;
            arguments.append('|');
        }
        StringBuilder launchID = new StringBuilder();
        launchID.append(launcherID);
        launchID.append('&');
        launchID.append(launcherPath);
        launchID.append('&');
        launchID.append(modelPath);
        launchID.append('&');
        launchID.append(targetPath);
        if (!args.isEmpty()) {
            launchID.append('&');
            launchID.append(arguments.toString());
        }
        return launchID.toString();
    }

    public static boolean checkMandatoryLaunchConfigParameters(String launchID) {
        String launcherPath = AcceleoLaunchingUtil.getLauncherPath(launchID);
        String modelPath = AcceleoLaunchingUtil.getModelPath(launchID);
        String targetPath = AcceleoLaunchingUtil.getTargetPath(launchID);
        return launcherPath.length() > 0 && modelPath.length() > 0 && targetPath.length() > 0;
    }

    public static List<String> getArguments(String launchID) {
        int argumentsOffset = launchID.indexOf(LAUNCH_ID_ARGUMENTS);
        if (argumentsOffset > 0) {
            String arguments = launchID.substring(argumentsOffset + LAUNCH_ID_ARGUMENTS.length());
            return Arrays.asList(arguments.split(String.valueOf('|')));
        }
        return Collections.emptyList();
    }

    public static Launcher getLauncherKind(String launchID) {
        int launcherOffset = launchID.indexOf(LAUNCH_ID_LAUNCHER);
        int firstSeparatorIndex = launchID.indexOf(38);
        if (launcherOffset == 0 && firstSeparatorIndex > 0) {
            String launcherKind = launchID.substring(launcherOffset + LAUNCH_ID_LAUNCHER.length(), firstSeparatorIndex);
            try {
                int kind = Integer.valueOf(launcherKind);
                if (kind >= 0 && kind < Launcher.values().length) {
                    return Launcher.values()[kind];
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getLauncherPath(String launchID) {
        int launcherPathSeparator;
        int launcherPathOffset = launchID.indexOf(LAUNCH_ID_LAUNCHER_PATH);
        if (launcherPathOffset > 0 && (launcherPathSeparator = launchID.indexOf(38, launcherPathOffset)) > 0) {
            return launchID.substring(launcherPathOffset + LAUNCH_ID_LAUNCHER_PATH.length(), launcherPathSeparator);
        }
        return "";
    }

    public static String getModelPath(String launchID) {
        int modelPathSeparator;
        int modelPathOffset = launchID.indexOf(LAUNCH_ID_MODEL_PATH);
        if (modelPathOffset > 0 && (modelPathSeparator = launchID.indexOf(38, modelPathOffset)) > 0) {
            return launchID.substring(modelPathOffset + LAUNCH_ID_MODEL_PATH.length(), modelPathSeparator);
        }
        return "";
    }

    public static String getTargetPath(String launchID) {
        int targetPathOffset = launchID.indexOf(LAUNCH_ID_TARGET_PATH);
        if (targetPathOffset > 0) {
            int targetPathSeparator = launchID.indexOf(38, targetPathOffset);
            if (targetPathSeparator == -1) {
                targetPathSeparator = launchID.length();
            }
            return launchID.substring(targetPathOffset + LAUNCH_ID_TARGET_PATH.length(), targetPathSeparator);
        }
        return "";
    }

    public static void switchTraceability(boolean activate) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            AcceleoPreferences.switchTraceability((boolean)activate);
        }
    }

    static enum Launcher {
        LAUNCH_CONFIG,
        UI_PROJECT;

    }
}

