/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.generation.IAcceleoEngineCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class AcceleoEngineCreatorDescriptor {
    public static final String ENGINE_CREATORS_ATTRIBUTE_CLASS = "class";
    private static final String ENGINE_CREATORS_ATTRIBUTE_LABEL = "label";
    private final IConfigurationElement element;
    private final String engineClassName;
    private IAcceleoEngineCreator engineCreator;
    private final String label;

    public AcceleoEngineCreatorDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.label = configuration.getAttribute(ENGINE_CREATORS_ATTRIBUTE_LABEL);
        this.engineClassName = configuration.getAttribute(ENGINE_CREATORS_ATTRIBUTE_CLASS);
    }

    public String getClassName() {
        return this.engineClassName;
    }

    public IAcceleoEngineCreator getEngineCreator() {
        if (this.engineCreator == null) {
            try {
                this.engineCreator = (IAcceleoEngineCreator)this.element.createExecutableExtension(ENGINE_CREATORS_ATTRIBUTE_CLASS);
            }
            catch (CoreException e) {
                AcceleoEnginePlugin.log((Exception)((Object)e), false);
            }
        }
        return this.engineCreator;
    }

    public String getLabel() {
        return this.label;
    }
}

